/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.kotlin.incremental.storage.version.CacheAttributesDiff;
import org.jetbrains.kotlin.incremental.storage.version.CacheAttributesManagerKt;
import org.jetbrains.kotlin.incremental.storage.version.CacheStatus;
import org.jetbrains.kotlin.jps.build.HasKotlinMarker;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext$WhenMappings;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolderKt;
import org.jetbrains.kotlin.jps.build.RebuildAfterCacheVersionChangeMarker;
import org.jetbrains.kotlin.jps.build.TestingBuildLogger;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.CompositeLookupsCacheAttributes;
import org.jetbrains.kotlin.jps.incremental.CompositeLookupsCacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheKt;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageKt;
import org.jetbrains.kotlin.jps.incremental.KotlinDataContainerTarget;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinTargetsIndex;
import org.jetbrains.kotlin.jps.targets.KotlinTargetsIndexBuilder;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u0002082\u0006\u0010:\u001a\u00020;J\u0006\u0010<\u001a\u000208J\b\u0010=\u001a\u000208H\u0002J\b\u0010>\u001a\u000208H\u0002J\u0006\u0010?\u001a\u000208J\u0006\u0010@\u001a\u000208J\u0010\u0010A\u001a\u0004\u0018\u00010;2\u0006\u0010B\u001a\u00020CJ\u0006\u0010D\u001a\u00020\"J\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0018\u0010F\u001a\u00020\"2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\"H\u0002J\b\u0010J\u001a\u00020\u001aH\u0002J\u0010\u0010K\u001a\u0002082\u0006\u0010L\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u0002082\u0006\u0010:\u001a\u00020;H\u0002R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R!\u0010)\u001a\u0012\u0012\u0004\u0012\u00020+\u0012\b\u0012\u0006\u0012\u0002\b\u00030,0*8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0013\u00103\u001a\u0004\u0018\u0001048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006O"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "", "jpsContext", "Lorg/jetbrains/jps/incremental/CompileContext;", "(Lorg/jetbrains/jps/incremental/CompileContext;)V", "dataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "kotlin.jvm.PlatformType", "getDataManager", "()Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "dataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "getDataPaths", "()Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "hasKotlinMarker", "Lorg/jetbrains/kotlin/jps/build/HasKotlinMarker;", "getHasKotlinMarker", "()Lorg/jetbrains/kotlin/jps/build/HasKotlinMarker;", "initialLookupsCacheStateDiff", "Lorg/jetbrains/kotlin/incremental/storage/version/CacheAttributesDiff;", "Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributes;", "getJpsContext", "()Lorg/jetbrains/jps/incremental/CompileContext;", "lookupAttributesSaved", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lookupsCacheAttributesManager", "Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributesManager;", "getLookupsCacheAttributesManager", "()Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributesManager;", "rebuildAfterCacheVersionChanged", "Lorg/jetbrains/kotlin/jps/build/RebuildAfterCacheVersionChangeMarker;", "getRebuildAfterCacheVersionChanged", "()Lorg/jetbrains/kotlin/jps/build/RebuildAfterCacheVersionChangeMarker;", "rebuildingAllKotlin", "", "getRebuildingAllKotlin", "()Z", "setRebuildingAllKotlin", "(Z)V", "shouldCheckCacheVersions", "getShouldCheckCacheVersions", "targetsBinding", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "getTargetsBinding", "()Ljava/util/Map;", "targetsIndex", "Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndex;", "getTargetsIndex", "()Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndex;", "testingLogger", "Lorg/jetbrains/kotlin/jps/build/TestingBuildLogger;", "getTestingLogger", "()Lorg/jetbrains/kotlin/jps/build/TestingBuildLogger;", "checkCacheVersions", "", "checkChunkCacheVersion", "chunk", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "cleanupCaches", "clearAllCaches", "clearLookupCache", "dispose", "ensureLookupsCacheAttributesSaved", "getChunk", "rawChunk", "Lorg/jetbrains/jps/ModuleChunk;", "hasKotlin", "loadLookupsCacheStateDiff", "logMarkDirtyForTestingBeforeRound", "file", "Ljava/io/File;", "shouldProcess", "makeLookupsCacheAttributesManager", "markAllKotlinForRebuild", "reason", "", "markChunkForRebuildBeforeBuild", "jps-plugin"})
public final class KotlinCompileContext {
    private final BuildDataManager dataManager;
    private final BuildDataPaths dataPaths;
    @NotNull
    private final KotlinTargetsIndex targetsIndex;
    @NotNull
    private final CompositeLookupsCacheAttributesManager lookupsCacheAttributesManager;
    private final boolean shouldCheckCacheVersions;
    @NotNull
    private final HasKotlinMarker hasKotlinMarker;
    @NotNull
    private final RebuildAfterCacheVersionChangeMarker rebuildAfterCacheVersionChanged;
    private boolean rebuildingAllKotlin;
    private final CacheAttributesDiff<CompositeLookupsCacheAttributes> initialLookupsCacheStateDiff;
    private final AtomicBoolean lookupAttributesSaved;
    @NotNull
    private final CompileContext jpsContext;

    public final BuildDataManager getDataManager() {
        return this.dataManager;
    }

    public final BuildDataPaths getDataPaths() {
        return this.dataPaths;
    }

    @Nullable
    public final TestingBuildLogger getTestingLogger() {
        TestingContext testingContext = TestingContextKt.getTestingContext(this.jpsContext);
        return testingContext != null ? testingContext.getBuildLogger() : null;
    }

    @NotNull
    public final KotlinTargetsIndex getTargetsIndex() {
        return this.targetsIndex;
    }

    @NotNull
    public final Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> getTargetsBinding() {
        return this.targetsIndex.getByJpsTarget();
    }

    @NotNull
    public final CompositeLookupsCacheAttributesManager getLookupsCacheAttributesManager() {
        return this.lookupsCacheAttributesManager;
    }

    public final boolean getShouldCheckCacheVersions() {
        return this.shouldCheckCacheVersions;
    }

    @NotNull
    public final HasKotlinMarker getHasKotlinMarker() {
        return this.hasKotlinMarker;
    }

    @NotNull
    public final RebuildAfterCacheVersionChangeMarker getRebuildAfterCacheVersionChanged() {
        return this.rebuildAfterCacheVersionChanged;
    }

    public final boolean getRebuildingAllKotlin() {
        return this.rebuildingAllKotlin;
    }

    public final void setRebuildingAllKotlin(boolean bl) {
        this.rebuildingAllKotlin = bl;
    }

    private final CompositeLookupsCacheAttributesManager makeLookupsCacheAttributesManager() {
        File lookupsCacheRootPath;
        Set expectedLookupsCacheComponents = new LinkedHashSet();
        Iterable $receiver$iv = this.targetsIndex.getChunks();
        for (Object element$iv : $receiver$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            Iterable $receiver$iv2 = chunk.getTargets();
            for (Object element$iv2 : $receiver$iv2) {
                KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv2;
                if (!target.isIncrementalCompilationEnabled()) continue;
                expectedLookupsCacheComponents.add(target.getGlobalLookupCacheId());
            }
        }
        File file = lookupsCacheRootPath = this.dataPaths.getTargetDataRoot((BuildTarget)KotlinDataContainerTarget.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"lookupsCacheRootPath");
        return new CompositeLookupsCacheAttributesManager(file, expectedLookupsCacheComponents);
    }

    private final CacheAttributesDiff<CompositeLookupsCacheAttributes> loadLookupsCacheStateDiff() {
        CacheAttributesDiff diff = CacheAttributesManagerKt.loadDiff$default(this.lookupsCacheAttributesManager, null, null, 3, null);
        if (diff.getStatus() == CacheStatus.VALID) {
            try {
                BuildDataManager buildDataManager = this.dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                JpsLookupStorageKt.withLookupStorage(buildDataManager, loadLookupsCacheStateDiff.1.INSTANCE);
            }
            catch (Exception e) {
                this.jpsContext.processMessage((BuildMessage)new CompilerMessage("Kotlin", BuildMessage.Kind.WARNING, "Incremental caches are corrupted. All Kotlin code will be rebuilt."));
                KotlinBuilder.Companion.getLOG().info((Throwable)new Error("Lookup storage is corrupted, probe failed: " + e.getMessage(), e));
                this.markAllKotlinForRebuild("Lookup storage is corrupted");
                return CacheAttributesDiff.copy$default(diff, null, null, null, 5, null);
            }
        }
        return diff;
    }

    public final boolean hasKotlin() {
        boolean bl;
        block7: {
            Iterable $receiver$iv = this.targetsIndex.getChunks();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    boolean bl2;
                    block6: {
                        KotlinChunk chunk = (KotlinChunk)element$iv;
                        Iterable $receiver$iv2 = chunk.getTargets();
                        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $receiver$iv2) {
                                KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv2;
                                if (!Intrinsics.areEqual((Object)this.hasKotlinMarker.get(target), (Object)true)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void checkCacheVersions() {
        switch (KotlinCompileContext$WhenMappings.$EnumSwitchMapping$0[this.initialLookupsCacheStateDiff.getStatus().ordinal()]) {
            case 1: {
                TestingBuildLogger testingBuildLogger = this.getTestingLogger();
                if (testingBuildLogger != null) {
                    testingBuildLogger.invalidOrUnusedCache(null, null, this.initialLookupsCacheStateDiff);
                }
                if (this.initialLookupsCacheStateDiff.getActual() != null) {
                    this.markAllKotlinForRebuild("Kotlin incremental cache settings or format was changed");
                    this.clearLookupCache();
                    break;
                }
                this.markAllKotlinForRebuild("Kotlin incremental cache is missed or corrupted");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                Object object = TestingContextKt.getTestingContext(this.jpsContext);
                if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
                    object.invalidOrUnusedCache(null, null, this.initialLookupsCacheStateDiff);
                }
                KotlinBuilder.Companion.getLOG().info("Removing global cache as it is not required anymore: " + this.initialLookupsCacheStateDiff);
                this.clearAllCaches();
                break;
            }
            case 4: {
            }
        }
    }

    public final void ensureLookupsCacheAttributesSaved() {
        if (this.lookupAttributesSaved.compareAndSet(false, true)) {
            CacheAttributesDiff<CompositeLookupsCacheAttributes> diff = this.initialLookupsCacheStateDiff;
            diff.getManager().writeActualVersion(diff.getExpected());
        }
    }

    public final void checkChunkCacheVersion(@NotNull KotlinChunk chunk) {
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        if (this.shouldCheckCacheVersions && !this.rebuildingAllKotlin && chunk.shouldRebuild()) {
            this.markChunkForRebuildBeforeBuild(chunk);
        }
    }

    private final boolean logMarkDirtyForTestingBeforeRound(File file, boolean shouldProcess) {
        block1: {
            if (!shouldProcess) break block1;
            TestingBuildLogger testingBuildLogger = this.getTestingLogger();
            if (testingBuildLogger != null) {
                testingBuildLogger.markedAsDirtyBeforeRound(CollectionsKt.listOf((Object)file));
            }
        }
        return shouldProcess;
    }

    private final void markAllKotlinForRebuild(String reason) {
        if (this.rebuildingAllKotlin) {
            return;
        }
        this.rebuildingAllKotlin = true;
        KotlinBuilder.Companion.getLOG().info("Rebuilding all Kotlin: " + reason);
        BuildDataManager dataManager = this.jpsContext.getProjectDescriptor().dataManager;
        Iterable $receiver$iv = this.targetsIndex.getChunks();
        for (Object element$iv : $receiver$iv) {
            KotlinChunk it = (KotlinChunk)element$iv;
            this.markChunkForRebuildBeforeBuild(it);
        }
        BuildDataManager buildDataManager = dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
        JpsLookupStorageKt.cleanLookupStorage(buildDataManager, KotlinBuilder.Companion.getLOG());
    }

    private final void markChunkForRebuildBeforeBuild(KotlinChunk chunk) {
        Iterable $receiver$iv = chunk.getTargets();
        for (Object element$iv : $receiver$iv) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            FSOperations.markDirty((CompileContext)this.jpsContext, (CompilationRound)CompilationRound.NEXT, (ModuleBuildTarget)it.getJpsModuleBuildTarget(), (FileFilter)new FileFilter(this){
                final /* synthetic */ KotlinCompileContext this$0;
                {
                    this.this$0 = kotlinCompileContext;
                }

                public final boolean accept(File file) {
                    File file2 = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                    return KotlinCompileContext.access$logMarkDirtyForTestingBeforeRound(this.this$0, file2, KotlinDirtySourceFilesHolderKt.isKotlinSourceFile(file));
                }
            });
            BuildDataManager buildDataManager = this.dataManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
            JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, it);
            if (jpsIncrementalCache != null) {
                jpsIncrementalCache.clean();
            }
            this.hasKotlinMarker.clean(it);
            this.rebuildAfterCacheVersionChanged.set(it, true);
        }
    }

    private final void clearAllCaches() {
        this.clearLookupCache();
        KotlinBuilder.Companion.getLOG().info("Clearing caches for all targets");
        Iterable $receiver$iv = this.targetsIndex.getChunks();
        for (Object element$iv : $receiver$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            Iterable $receiver$iv2 = chunk.getTargets();
            for (Object element$iv2 : $receiver$iv2) {
                KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv2;
                BuildDataManager buildDataManager = this.dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, it);
                if (jpsIncrementalCache == null) continue;
                jpsIncrementalCache.clean();
            }
        }
    }

    private final void clearLookupCache() {
        KotlinBuilder.Companion.getLOG().info("Clearing lookup cache");
        BuildDataManager buildDataManager = this.dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
        JpsLookupStorageKt.cleanLookupStorage(buildDataManager, KotlinBuilder.Companion.getLOG());
        this.initialLookupsCacheStateDiff.getManager().writeActualVersion(null);
    }

    public final void cleanupCaches() {
        Iterable $receiver$iv = this.targetsIndex.getChunks();
        for (Object element$iv : $receiver$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            Iterable $receiver$iv2 = chunk.getTargets();
            for (Object element$iv2 : $receiver$iv2) {
                KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv2;
                if (target.getInitialLocalCacheAttributesDiff().getStatus() != CacheStatus.SHOULD_BE_CLEARED) continue;
                KotlinBuilder.Companion.getLOG().info(target + " caches is cleared as not required anymore: " + target.getInitialLocalCacheAttributesDiff());
                TestingBuildLogger testingBuildLogger = this.getTestingLogger();
                if (testingBuildLogger != null) {
                    testingBuildLogger.invalidOrUnusedCache(null, target, target.getInitialLocalCacheAttributesDiff());
                }
                BuildDataManager buildDataManager = this.dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, target);
                if (jpsIncrementalCache == null) continue;
                jpsIncrementalCache.clean();
            }
        }
    }

    public final void dispose() {
    }

    @Nullable
    public final KotlinChunk getChunk(@NotNull ModuleChunk rawChunk) {
        Intrinsics.checkParameterIsNotNull((Object)rawChunk, (String)"rawChunk");
        ModuleBuildTarget rawRepresentativeTarget = rawChunk.representativeTarget();
        Object object = this.getTargetsBinding();
        Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> map2 = object;
        if (!map2.containsKey(rawRepresentativeTarget)) {
            return null;
        }
        KotlinChunk kotlinChunk = this.targetsIndex.getChunksByJpsRepresentativeTarget().get(rawRepresentativeTarget);
        if (kotlinChunk == null) {
            object = "Kotlin binding for chunk " + this + " is not loaded at build start";
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return kotlinChunk;
    }

    @NotNull
    public final CompileContext getJpsContext() {
        return this.jpsContext;
    }

    public KotlinCompileContext(@NotNull CompileContext jpsContext) {
        Intrinsics.checkParameterIsNotNull((Object)jpsContext, (String)"jpsContext");
        this.jpsContext = jpsContext;
        BuildDataManager buildDataManager = this.dataManager = this.jpsContext.getProjectDescriptor().dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
        this.dataPaths = buildDataManager.getDataPaths();
        this.targetsIndex = new KotlinTargetsIndexBuilder(this).build();
        this.lookupsCacheAttributesManager = this.makeLookupsCacheAttributesManager();
        this.shouldCheckCacheVersions = System.getProperty("kotlin.jps.skip.cache.version.check") == null;
        BuildDataManager buildDataManager2 = this.dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager2, (String)"dataManager");
        this.hasKotlinMarker = new HasKotlinMarker(buildDataManager2);
        BuildDataManager buildDataManager3 = this.dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager3, (String)"dataManager");
        this.rebuildAfterCacheVersionChanged = new RebuildAfterCacheVersionChangeMarker(buildDataManager3);
        this.initialLookupsCacheStateDiff = this.loadLookupsCacheStateDiff();
        this.lookupAttributesSaved = new AtomicBoolean(false);
    }

    public static final /* synthetic */ boolean access$logMarkDirtyForTestingBeforeRound(KotlinCompileContext $this, @NotNull File file, boolean shouldProcess) {
        return $this.logMarkDirtyForTestingBeforeRound(file, shouldProcess);
    }
}

