/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolderKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001'B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010$\u001a\u00020\tJ\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0&2\u0006\u0010$\u001a\u00020\tR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\u0014R\u00020\u00000\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001e\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "delegate", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "(Lorg/jetbrains/jps/ModuleChunk;Lorg/jetbrains/jps/incremental/CompileContext;Lorg/jetbrains/jps/builders/DirtyFilesHolder;)V", "allDirtyFiles", "", "Ljava/io/File;", "getAllDirtyFiles", "()Ljava/util/Set;", "allRemovedFilesFiles", "getAllRemovedFilesFiles", "byTarget", "", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder$TargetFiles;", "getByTarget", "()Ljava/util/Map;", "getChunk", "()Lorg/jetbrains/jps/ModuleChunk;", "getContext", "()Lorg/jetbrains/jps/incremental/CompileContext;", "hasDirtyFiles", "", "getHasDirtyFiles", "()Z", "hasDirtyOrRemovedFiles", "getHasDirtyOrRemovedFiles", "hasRemovedFiles", "getHasRemovedFiles", "getDirtyFiles", "target", "getRemovedFiles", "", "TargetFiles", "jps-plugin"})
public final class KotlinDirtySourceFilesHolder {
    @NotNull
    private final Map<ModuleBuildTarget, TargetFiles> byTarget;
    @NotNull
    private final ModuleChunk chunk;
    @NotNull
    private final CompileContext context;

    @NotNull
    public final Map<ModuleBuildTarget, TargetFiles> getByTarget() {
        return this.byTarget;
    }

    public final boolean getHasRemovedFiles() {
        boolean bl;
        block3: {
            Map<ModuleBuildTarget, TargetFiles> $receiver$iv = this.byTarget;
            if ($receiver$iv.isEmpty()) {
                bl = false;
            } else {
                Map<ModuleBuildTarget, TargetFiles> map2 = $receiver$iv;
                for (Map.Entry<ModuleBuildTarget, TargetFiles> element$iv : map2.entrySet()) {
                    Map.Entry<ModuleBuildTarget, TargetFiles> it = element$iv;
                    Collection<File> collection = it.getValue().getRemoved();
                    if (!(!collection.isEmpty())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean getHasDirtyFiles() {
        boolean bl;
        block3: {
            Map<ModuleBuildTarget, TargetFiles> $receiver$iv = this.byTarget;
            if ($receiver$iv.isEmpty()) {
                bl = false;
            } else {
                Map<ModuleBuildTarget, TargetFiles> map2 = $receiver$iv;
                for (Map.Entry<ModuleBuildTarget, TargetFiles> element$iv : map2.entrySet()) {
                    Map.Entry<ModuleBuildTarget, TargetFiles> it = element$iv;
                    Collection collection = it.getValue().getDirty();
                    if (!(!collection.isEmpty())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean getHasDirtyOrRemovedFiles() {
        return this.getHasRemovedFiles() || this.getHasDirtyFiles();
    }

    @NotNull
    public final Set<File> getDirtyFiles(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Object object = this.byTarget.get(target);
        if (object == null || (object = ((TargetFiles)object).getDirty()) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @NotNull
    public final Collection<File> getRemovedFiles(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Object object = this.byTarget.get(target);
        if (object == null || (object = ((TargetFiles)object).getRemoved()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<File> getAllDirtyFiles() {
        void var2_2;
        void $receiver$iv;
        Map<ModuleBuildTarget, TargetFiles> map2 = this.byTarget;
        Collection destination$iv = new LinkedHashSet();
        void var3_3 = $receiver$iv;
        Iterator iterator2 = var3_3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            Iterable list$iv = ((TargetFiles)it.getValue()).getDirty();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<File> getAllRemovedFilesFiles() {
        void var2_2;
        void $receiver$iv;
        Map<ModuleBuildTarget, TargetFiles> map2 = this.byTarget;
        Collection destination$iv = new LinkedHashSet();
        void var3_3 = $receiver$iv;
        Iterator iterator2 = var3_3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            Iterable list$iv = ((TargetFiles)it.getValue()).getRemoved();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var2_2;
    }

    @NotNull
    public final ModuleChunk getChunk() {
        return this.chunk;
    }

    @NotNull
    public final CompileContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public KotlinDirtySourceFilesHolder(@NotNull ModuleChunk chunk, @NotNull CompileContext context, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> delegate) {
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
        this.chunk = chunk;
        this.context = context;
        final Map byTarget = new LinkedHashMap();
        Set set = this.chunk.getTargets();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.targets");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            void $receiver$iv$iv;
            Iterable $receiver$iv2;
            ModuleBuildTarget target = (ModuleBuildTarget)element$iv;
            Collection collection = delegate.getRemovedFiles((BuildTarget)target);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"delegate.getRemovedFiles(target)");
            Iterable iterable = $receiver$iv2 = (Iterable)collection;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                File file = new File((String)it);
                collection2.add(file);
            }
            List removedFiles = (List)destination$iv$iv;
            Map map2 = byTarget;
            ModuleBuildTarget moduleBuildTarget = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            iterable = moduleBuildTarget;
            TargetFiles targetFiles = new TargetFiles(target, removedFiles);
            map2.put(iterable, targetFiles);
        }
        delegate.processDirtyFiles((FileProcessor)new FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget>(){

            public final boolean apply(ModuleBuildTarget target, File file, JavaSourceRootDescriptor root) {
                TargetFiles targetFiles = (TargetFiles)byTarget.get(target);
                if (targetFiles == null) {
                    String string = "processDirtyFiles should callback only on chunk `" + this.getChunk() + "` targets (`" + target + "` is not)";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                TargetFiles targetInfo = targetFiles;
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                if (KotlinDirtySourceFilesHolderKt.isKotlinSourceFile(file2)) {
                    targetInfo._markDirty$jps_plugin(file);
                }
                return true;
            }
        });
        this.byTarget = byTarget;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0015R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder$TargetFiles;", "", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "removed", "", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;Lorg/jetbrains/jps/incremental/ModuleBuildTarget;Ljava/util/Collection;)V", "_dirty", "", "dirty", "", "getDirty", "()Ljava/util/Set;", "getRemoved", "()Ljava/util/Collection;", "getTarget", "()Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "_markDirty", "", "file", "_markDirty$jps_plugin", "jps-plugin"})
    public final class TargetFiles {
        private final Set<File> _dirty;
        @NotNull
        private final ModuleBuildTarget target;
        @NotNull
        private final Collection<File> removed;

        @NotNull
        public final Set<File> getDirty() {
            return this._dirty;
        }

        public final void _markDirty$jps_plugin(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            File file2 = file.getCanonicalFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file.canonicalFile");
            this._dirty.add(file2);
        }

        @NotNull
        public final ModuleBuildTarget getTarget() {
            return this.target;
        }

        @NotNull
        public final Collection<File> getRemoved() {
            return this.removed;
        }

        public TargetFiles(@NotNull ModuleBuildTarget target, Collection<? extends File> removed2) {
            Set set;
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            Intrinsics.checkParameterIsNotNull(removed2, (String)"removed");
            this.target = target;
            this.removed = removed2;
            TargetFiles targetFiles = this;
            targetFiles._dirty = set = (Set)new LinkedHashSet();
        }
    }
}

