/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.targets;

import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinCommonModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinJsModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinJvmModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinTargetsIndex;
import org.jetbrains.kotlin.jps.targets.KotlinUnsupportedModuleBuildTarget;
import org.jetbrains.kotlin.platform.DefaultIdeTargetPlatformKindProvider;
import org.jetbrains.kotlin.platform.IdePlatform;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformUtil;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformUtil;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformUtil;
import org.jetbrains.kotlin.utils.LibraryUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0014\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0014\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndexBuilder;", "", "uninitializedContext", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;)V", "byJpsModuleBuildTarget", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "chunks", "", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "isKotlinJsStdlibJar", "", "", "build", "Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndex;", "calculateChunkDependencies", "", "calculateTargetDependencies", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Dependency;", "srcTarget", "detectTargetPlatform", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "target", "ensureLoaded", "hasJsStdLib", "jps-plugin"})
public final class KotlinTargetsIndexBuilder {
    private final Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> byJpsModuleBuildTarget;
    private final Map<String, Boolean> isKotlinJsStdlibJar;
    private final List<KotlinChunk> chunks;
    private final KotlinCompileContext uninitializedContext;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KotlinTargetsIndex build() {
        Map map2;
        void $receiver$iv$iv;
        void $receiver$iv;
        Object chunk;
        long start$iv22 = System.currentTimeMillis();
        CompileContext jpsContext = this.uninitializedContext.getJpsContext();
        ProjectDescriptor projectDescriptor = jpsContext.getProjectDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectDescriptor, (String)"jpsContext.projectDescriptor");
        List list = projectDescriptor.getBuildTargetIndex().getSortedTargetChunks(jpsContext);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"jpsContext.projectDescri\u2026dTargetChunks(jpsContext)");
        Iterable $receiver$iv2 = list;
        for (Object element$iv : $receiver$iv2) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv3;
            BuildTargetChunk buildTargetChunk = chunk = (BuildTargetChunk)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)buildTargetChunk, (String)"chunk");
            Set set = buildTargetChunk.getTargets();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"chunk.targets");
            Iterable iterable = $receiver$iv3 = (Iterable)set;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv2;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                KotlinModuleBuildTarget<?> kotlinModuleBuildTarget;
                Object element$iv$iv = element$iv$iv$iv;
                BuildTarget it = (BuildTarget)element$iv$iv;
                KotlinModuleBuildTarget<?> kotlinModuleBuildTarget2 = it instanceof ModuleBuildTarget ? this.ensureLoaded((ModuleBuildTarget)it) : null;
                if (kotlinModuleBuildTarget2 == null) continue;
                KotlinModuleBuildTarget<?> it$iv$iv = kotlinModuleBuildTarget = kotlinModuleBuildTarget2;
                destination$iv$iv.add(it$iv$iv);
            }
            List moduleBuildTargets = (List)destination$iv$iv;
            $receiver$iv3 = moduleBuildTargets;
            if (!(!$receiver$iv3.isEmpty())) continue;
            KotlinChunk kotlinChunk = new KotlinChunk(this.uninitializedContext, moduleBuildTargets);
            Iterable $receiver$iv4 = moduleBuildTargets;
            for (Object element$iv2 : $receiver$iv4) {
                KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv2;
                it.setChunk(kotlinChunk);
            }
            this.chunks.add(kotlinChunk);
        }
        this.calculateChunkDependencies();
        long time = System.currentTimeMillis() - start$iv22;
        KotlinBuilder.Companion.getLOG().info("KotlinTargetsIndex created in " + time + " ms");
        Iterable start$iv22 = this.chunks;
        List<KotlinChunk> list2 = this.chunks;
        Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> map3 = this.byJpsModuleBuildTarget;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        jpsContext = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it;
            chunk = (KotlinChunk)element$iv$iv;
            map2 = destination$iv$iv;
            ModuleBuildTarget moduleBuildTarget = it.getRepresentativeTarget().getJpsModuleBuildTarget();
            map2.put(moduleBuildTarget, element$iv$iv);
        }
        Map map4 = map2 = destination$iv$iv;
        List<KotlinChunk> list3 = list2;
        Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> map5 = map3;
        return new KotlinTargetsIndex(map5, list3, map4);
    }

    private final void calculateChunkDependencies() {
        Iterable $receiver$iv = this.chunks;
        for (Object element$iv : $receiver$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            Set dependencies = new LinkedHashSet();
            Iterable $receiver$iv2 = chunk.getTargets();
            for (Object element$iv2 : $receiver$iv2) {
                KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv2;
                dependencies.addAll((Collection)this.calculateTargetDependencies(it));
            }
            chunk.setDependencies$jps_plugin(CollectionsKt.toList((Iterable)dependencies));
            $receiver$iv2 = chunk.getDependencies();
            for (Object element$iv2 : $receiver$iv2) {
                KotlinModuleBuildTarget.Dependency dependency = (KotlinModuleBuildTarget.Dependency)element$iv2;
                Set<KotlinModuleBuildTarget.Dependency> set = dependency.getTarget().getChunk().get_dependent$jps_plugin();
                if (set == null) {
                    Intrinsics.throwNpe();
                }
                set.add(dependency);
            }
        }
        $receiver$iv = this.chunks;
        for (Object element$iv : $receiver$iv) {
            KotlinChunk it = (KotlinChunk)element$iv;
            Set<KotlinModuleBuildTarget.Dependency> set = it.get_dependent$jps_plugin();
            if (set == null) {
                Intrinsics.throwNpe();
            }
            it.setDependent$jps_plugin(CollectionsKt.toList((Iterable)set));
            it.set_dependent$jps_plugin(null);
        }
    }

    private final List<KotlinModuleBuildTarget.Dependency> calculateTargetDependencies(KotlinModuleBuildTarget<?> srcTarget) {
        KotlinModuleBuildTarget<?> srcProductionTarget;
        List dependencies = new ArrayList();
        JpsJavaClasspathKind classpathKind = JpsJavaClasspathKind.compile((boolean)srcTarget.isTests());
        Set dependentTargets = new LinkedHashSet();
        JpsJavaExtensionService.dependencies((JpsModule)srcTarget.getModule()).includedIn(classpathKind).processModules((Consumer)new Consumer<JpsModule>(this, srcTarget, dependentTargets){
            final /* synthetic */ KotlinTargetsIndexBuilder this$0;
            final /* synthetic */ KotlinModuleBuildTarget $srcTarget;
            final /* synthetic */ Set $dependentTargets;

            public final void consume(JpsModule destModule) {
                Map map2 = KotlinTargetsIndexBuilder.access$getByJpsModuleBuildTarget$p(this.this$0);
                JpsModule jpsModule = destModule;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"destModule");
                KotlinModuleBuildTarget destKotlinTarget = (KotlinModuleBuildTarget)map2.get(JpsUtilKt.ModuleBuildTarget(jpsModule, this.$srcTarget.isTests()));
                if (destKotlinTarget != null) {
                    this.$dependentTargets.add(destKotlinTarget);
                }
            }
            {
                this.this$0 = kotlinTargetsIndexBuilder;
                this.$srcTarget = kotlinModuleBuildTarget;
                this.$dependentTargets = set;
            }
        });
        JpsJavaExtensionService.dependencies((JpsModule)srcTarget.getModule()).includedIn(classpathKind).exportedOnly().processModules((Consumer)new Consumer<JpsModule>(this, srcTarget, dependentTargets, dependencies){
            final /* synthetic */ KotlinTargetsIndexBuilder this$0;
            final /* synthetic */ KotlinModuleBuildTarget $srcTarget;
            final /* synthetic */ Set $dependentTargets;
            final /* synthetic */ List $dependencies;

            public final void consume(JpsModule module) {
                Map map2 = KotlinTargetsIndexBuilder.access$getByJpsModuleBuildTarget$p(this.this$0);
                JpsModule jpsModule = module;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
                KotlinModuleBuildTarget destKotlinTarget = (KotlinModuleBuildTarget)map2.get(JpsUtilKt.ModuleBuildTarget(jpsModule, this.$srcTarget.isTests()));
                if (destKotlinTarget != null) {
                    this.$dependentTargets.remove(destKotlinTarget);
                    this.$dependencies.add(new KotlinModuleBuildTarget.Dependency(this.$srcTarget, destKotlinTarget, true));
                }
            }
            {
                this.this$0 = kotlinTargetsIndexBuilder;
                this.$srcTarget = kotlinModuleBuildTarget;
                this.$dependentTargets = set;
                this.$dependencies = list;
            }
        });
        Iterable $receiver$iv = dependentTargets;
        for (Object element$iv : $receiver$iv) {
            KotlinModuleBuildTarget destTarget = (KotlinModuleBuildTarget)element$iv;
            dependencies.add(new KotlinModuleBuildTarget.Dependency(srcTarget, destTarget, false));
        }
        if (srcTarget.isTests() && (srcProductionTarget = this.byJpsModuleBuildTarget.get(JpsUtilKt.ModuleBuildTarget(srcTarget.getModule(), false))) != null) {
            dependencies.add(new KotlinModuleBuildTarget.Dependency(srcTarget, srcProductionTarget, true));
        }
        return dependencies;
    }

    private final KotlinModuleBuildTarget<?> ensureLoaded(ModuleBuildTarget target) {
        KotlinModuleBuildTarget<?> kotlinModuleBuildTarget = this.byJpsModuleBuildTarget.computeIfAbsent(target, new Function<ModuleBuildTarget, KotlinModuleBuildTarget<?>>(this, target){
            final /* synthetic */ KotlinTargetsIndexBuilder this$0;
            final /* synthetic */ ModuleBuildTarget $target;

            @NotNull
            public final KotlinModuleBuildTarget<?> apply(@NotNull ModuleBuildTarget it) {
                IdePlatform<Object, Object> platform;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                JpsModule jpsModule = this.$target.getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"target.module");
                IdePlatform<Object, Object> idePlatform = ModuleSettingsKt.getPlatform(jpsModule);
                if (idePlatform == null || (idePlatform = idePlatform.getKind()) == null) {
                    idePlatform = platform = KotlinTargetsIndexBuilder.access$detectTargetPlatform(this.this$0, this.$target);
                }
                return CommonIdePlatformUtil.isCommon(platform) ? (KotlinModuleBuildTarget)new KotlinCommonModuleBuildTarget(KotlinTargetsIndexBuilder.access$getUninitializedContext$p(this.this$0), this.$target) : (JsIdePlatformUtil.isJavaScript(platform) ? (KotlinModuleBuildTarget)new KotlinJsModuleBuildTarget(KotlinTargetsIndexBuilder.access$getUninitializedContext$p(this.this$0), this.$target) : (JvmIdePlatformUtil.isJvm(platform) ? (KotlinModuleBuildTarget)new KotlinJvmModuleBuildTarget(KotlinTargetsIndexBuilder.access$getUninitializedContext$p(this.this$0), this.$target) : (KotlinModuleBuildTarget)new KotlinUnsupportedModuleBuildTarget(KotlinTargetsIndexBuilder.access$getUninitializedContext$p(this.this$0), this.$target)));
            }
            {
                this.this$0 = kotlinTargetsIndexBuilder;
                this.$target = moduleBuildTarget;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(kotlinModuleBuildTarget, (String)"byJpsModuleBuildTarget.c\u2026)\n            }\n        }");
        return kotlinModuleBuildTarget;
    }

    private final IdePlatformKind<?> detectTargetPlatform(ModuleBuildTarget target) {
        if (this.hasJsStdLib(target)) {
            return JsIdePlatformKind.INSTANCE;
        }
        return DefaultIdeTargetPlatformKindProvider.Companion.getDefaultPlatform().getKind();
    }

    private final boolean hasJsStdLib(ModuleBuildTarget target) {
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = JpsJavaExtensionService.dependencies((JpsModule)target.getModule()).recursively().exportedOnly().includedIn(JpsJavaClasspathKind.compile((boolean)target.isTests()));
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsJavaDependenciesEnumerator, (String)"JpsJavaExtensionService.\u2026.compile(target.isTests))");
        Set set = jpsJavaDependenciesEnumerator.getLibraries();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"JpsJavaExtensionService.\u2026))\n            .libraries");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            JpsLibrary library = (JpsLibrary)element$iv;
            Iterator iterator2 = library.getRoots(JpsOrderRootType.COMPILED).iterator();
            while (iterator2.hasNext()) {
                String url;
                JpsLibraryRoot root;
                JpsLibraryRoot jpsLibraryRoot = root = (JpsLibraryRoot)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsLibraryRoot, (String)"root");
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsLibraryRoot.getUrl(), (String)"root.url");
                Boolean bl = this.isKotlinJsStdlibJar.computeIfAbsent(url, new Function<String, Boolean>(url){
                    final /* synthetic */ String $url;

                    public final boolean apply(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        File file = JpsPathUtil.urlToFile((String)this.$url);
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"JpsPathUtil.urlToFile(url)");
                        return LibraryUtils.isKotlinJavascriptStdLibrary(file);
                    }
                    {
                        this.$url = string;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"isKotlinJsStdlibJar.comp\u2026l))\n                    }");
                boolean isKotlinJsLib2 = bl;
                if (!isKotlinJsLib2) continue;
                return true;
            }
        }
        return false;
    }

    public KotlinTargetsIndexBuilder(@NotNull KotlinCompileContext uninitializedContext) {
        Intrinsics.checkParameterIsNotNull((Object)uninitializedContext, (String)"uninitializedContext");
        this.uninitializedContext = uninitializedContext;
        KotlinTargetsIndexBuilder kotlinTargetsIndexBuilder = this;
        Object object = new LinkedHashMap();
        kotlinTargetsIndexBuilder.byJpsModuleBuildTarget = object;
        kotlinTargetsIndexBuilder = this;
        object = new LinkedHashMap();
        kotlinTargetsIndexBuilder.isKotlinJsStdlibJar = object;
        kotlinTargetsIndexBuilder = this;
        kotlinTargetsIndexBuilder.chunks = object = (List)new ArrayList();
    }

    @NotNull
    public static final /* synthetic */ Map access$getByJpsModuleBuildTarget$p(KotlinTargetsIndexBuilder $this) {
        return $this.byJpsModuleBuildTarget;
    }

    @NotNull
    public static final /* synthetic */ IdePlatformKind access$detectTargetPlatform(KotlinTargetsIndexBuilder $this, @NotNull ModuleBuildTarget target) {
        return $this.detectTargetPlatform(target);
    }

    @NotNull
    public static final /* synthetic */ KotlinCompileContext access$getUninitializedContext$p(KotlinTargetsIndexBuilder $this) {
        return $this.uninitializedContext;
    }
}

