/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.descriptors;

import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ConstUtil;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.ValueParameterData;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.types.KotlinType;

public class JavaPropertyDescriptor
extends PropertyDescriptorImpl
implements JavaCallableMemberDescriptor {
    private final boolean isStaticFinal;
    @Nullable
    private final Pair<CallableDescriptor.UserDataKey<?>, ?> singleUserData;

    private JavaPropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, @NotNull Name name, @NotNull SourceElement source, @Nullable PropertyDescriptor original, @NotNull CallableMemberDescriptor.Kind kind, boolean isStaticFinal, @Nullable Pair<CallableDescriptor.UserDataKey<?>, ?> singleUserData) {
        super(containingDeclaration, original, annotations, modality, visibility, isVar, name, kind, source, false, false, false, false, false, false);
        this.isStaticFinal = isStaticFinal;
        this.singleUserData = singleUserData;
    }

    @NotNull
    public static JavaPropertyDescriptor create(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations, @NotNull Modality modality, @NotNull Visibility visibility, boolean isVar, @NotNull Name name, @NotNull SourceElement source, boolean isStaticFinal) {
        return new JavaPropertyDescriptor(containingDeclaration, annotations, modality, visibility, isVar, name, source, null, CallableMemberDescriptor.Kind.DECLARATION, isStaticFinal, null);
    }

    @Override
    @NotNull
    protected PropertyDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @NotNull Modality newModality, @NotNull Visibility newVisibility, @Nullable PropertyDescriptor original, @NotNull CallableMemberDescriptor.Kind kind, @NotNull Name newName) {
        return new JavaPropertyDescriptor(newOwner, this.getAnnotations(), newModality, newVisibility, this.isVar(), newName, SourceElement.NO_SOURCE, original, kind, this.isStaticFinal, this.singleUserData);
    }

    @Override
    public boolean hasSynthesizedParameterNames() {
        return false;
    }

    @Override
    @NotNull
    public JavaCallableMemberDescriptor enhance(@Nullable KotlinType enhancedReceiverType, @NotNull List<ValueParameterData> enhancedValueParametersData, @NotNull KotlinType enhancedReturnType, @Nullable Pair<CallableDescriptor.UserDataKey<?>, ?> additionalUserData) {
        JavaPropertyDescriptor enhanced = new JavaPropertyDescriptor(this.getContainingDeclaration(), this.getAnnotations(), this.getModality(), this.getVisibility(), this.isVar(), this.getName(), this.getSource(), this.getOriginal() == this ? null : this.getOriginal(), this.getKind(), this.isStaticFinal, additionalUserData);
        PropertyGetterDescriptorImpl newGetter = null;
        PropertyGetterDescriptorImpl getter = this.getGetter();
        if (getter != null) {
            newGetter = new PropertyGetterDescriptorImpl(enhanced, getter.getAnnotations(), getter.getModality(), getter.getVisibility(), getter.isDefault(), getter.isExternal(), getter.isInline(), this.getKind(), getter, getter.getSource());
            newGetter.setInitialSignatureDescriptor(getter.getInitialSignatureDescriptor());
            newGetter.initialize(enhancedReturnType);
        }
        PropertySetterDescriptorImpl newSetter = null;
        PropertySetterDescriptor setter = this.getSetter();
        if (setter != null) {
            newSetter = new PropertySetterDescriptorImpl(enhanced, setter.getAnnotations(), setter.getModality(), setter.getVisibility(), setter.isDefault(), setter.isExternal(), setter.isInline(), this.getKind(), setter, setter.getSource());
            newSetter.setInitialSignatureDescriptor(newSetter.getInitialSignatureDescriptor());
            newSetter.initialize(setter.getValueParameters().get(0));
        }
        enhanced.initialize(newGetter, newSetter, this.getBackingField(), this.getDelegateField());
        enhanced.setSetterProjectedOut(this.isSetterProjectedOut());
        if (this.compileTimeInitializer != null) {
            enhanced.setCompileTimeInitializer(this.compileTimeInitializer);
        }
        enhanced.setOverriddenDescriptors(this.getOverriddenDescriptors());
        ReceiverParameterDescriptor enhancedReceiver = enhancedReceiverType == null ? null : DescriptorFactory.createExtensionReceiverParameterForCallable(this, enhancedReceiverType, Annotations.Companion.getEMPTY());
        enhanced.setType(enhancedReturnType, this.getTypeParameters(), this.getDispatchReceiverParameter(), enhancedReceiver);
        return enhanced;
    }

    @Override
    public boolean isConst() {
        KotlinType type2 = this.getType();
        return this.isStaticFinal && ConstUtil.canBeUsedForConstVal(type2) && (!TypeEnhancementKt.hasEnhancedNullability(type2) || KotlinBuiltIns.isString(type2));
    }

    @Override
    @Nullable
    public <V> V getUserData(CallableDescriptor.UserDataKey<V> key) {
        if (this.singleUserData != null && ((CallableDescriptor.UserDataKey)this.singleUserData.getFirst()).equals(key)) {
            return (V)this.singleUserData.getSecond();
        }
        return null;
    }
}

