/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeInsightUtil {
    private static final Logger LOG = Logger.getInstance(CodeInsightUtil.class);

    @Nullable
    public static PsiExpression findExpressionInRange(PsiFile file, int startOffset, int endOffset) {
        int newEndOffset;
        PsiElement element;
        PsiJavaToken token;
        IElementType tokenType;
        PsiElement element2;
        if (!file.getViewProvider().getLanguages().contains(StdLanguages.JAVA)) {
            return null;
        }
        PsiExpression expression2 = CodeInsightUtil.findElementInRange(file, startOffset, endOffset, PsiExpression.class);
        if (expression2 == null && CodeInsightUtil.findStatementsInRange(file, startOffset, endOffset).length == 0 && (element2 = file.getViewProvider().findElementAt(endOffset - 1, StdLanguages.JAVA)) instanceof PsiJavaToken && (tokenType = (token = (PsiJavaToken)element2).getTokenType()).equals(JavaTokenType.SEMICOLON)) {
            expression2 = CodeInsightUtil.findElementInRange(file, startOffset, element2.getTextRange().getStartOffset(), PsiExpression.class);
        }
        if (expression2 == null && CodeInsightUtil.findStatementsInRange(file, startOffset, endOffset).length == 0 && (element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)file.findElementAt(endOffset))) != null && (element = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element.getLastChild())) != null && (newEndOffset = element.getTextRange().getEndOffset()) < endOffset) {
            expression2 = CodeInsightUtil.findExpressionInRange(file, startOffset, newEndOffset);
        }
        if (expression2 instanceof PsiReferenceExpression && expression2.getParent() instanceof PsiMethodCallExpression) {
            return null;
        }
        return expression2;
    }

    public static <T extends PsiElement> T findElementInRange(PsiFile file, int startOffset, int endOffset, Class<T> klass) {
        return (T)CodeInsightUtilCore.findElementInRange((PsiFile)file, (int)startOffset, (int)endOffset, klass, (Language)StdLanguages.JAVA);
    }

    @NotNull
    public static PsiElement[] findStatementsInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        Language language;
        if (file == null) {
            CodeInsightUtil.$$$reportNull$$$0(0);
        }
        if ((language = CodeInsightUtil.findJavaOrLikeLanguage(file)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtil.$$$reportNull$$$0(1);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        FileViewProvider viewProvider = file.getViewProvider();
        PsiElement element1 = viewProvider.findElementAt(startOffset, language);
        PsiElement element2 = viewProvider.findElementAt(endOffset - 1, language);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtil.$$$reportNull$$$0(2);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtil.$$$reportNull$$$0(3);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        while (true) {
            if (parent instanceof PsiStatement) {
                if (element1 instanceof PsiComment) break;
                parent = parent.getParent();
                break;
            }
            if (parent instanceof PsiCodeBlock || FileTypeUtils.isInServerPageFile((PsiElement)parent) && parent instanceof PsiFile || parent instanceof PsiCodeFragment) break;
            if (parent == null || parent instanceof PsiFile) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    CodeInsightUtil.$$$reportNull$$$0(4);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            parent = parent.getParent();
        }
        if (!parent.equals(element1)) {
            while (!parent.equals(element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (startOffset != element1.getTextRange().getStartOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtil.$$$reportNull$$$0(5);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (endOffset != element2.getTextRange().getEndOffset() && !CodeInsightUtil.isAtTrailingComment(element1, element2, endOffset)) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtil.$$$reportNull$$$0(6);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (parent instanceof PsiCodeBlock && element1 == ((PsiCodeBlock)parent).getLBrace() && element2 == ((PsiCodeBlock)parent).getRBrace()) {
            if (parent.getParent() instanceof PsiBlockStatement) {
                PsiElement[] psiElementArray = new PsiElement[]{parent.getParent()};
                if (psiElementArray == null) {
                    CodeInsightUtil.$$$reportNull$$$0(7);
                }
                return psiElementArray;
            }
            PsiElement[] children = parent.getChildren();
            PsiElement[] psiElementArray = CodeInsightUtil.getStatementsInRange(children, ((PsiCodeBlock)parent).getFirstBodyElement(), ((PsiCodeBlock)parent).getLastBodyElement());
            if (psiElementArray == null) {
                CodeInsightUtil.$$$reportNull$$$0(8);
            }
            return psiElementArray;
        }
        PsiElement[] children = parent.getChildren();
        PsiElement[] psiElementArray = CodeInsightUtil.getStatementsInRange(children, element1, element2);
        if (psiElementArray == null) {
            CodeInsightUtil.$$$reportNull$$$0(9);
        }
        return psiElementArray;
    }

    private static boolean isAtTrailingComment(PsiElement element1, PsiElement element2, int offset) {
        if (element1 == element2 && element1 instanceof PsiExpressionStatement) {
            for (PsiElement child = element1.getLastChild(); child != null; child = child.getPrevSibling()) {
                if (!PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.SEMICOLON) || child.getTextRange().getEndOffset() != offset) continue;
                return false;
            }
        }
        PsiElement trailing = element2;
        while (trailing.getTextRange().contains(offset) && trailing.getLastChild() != null) {
            trailing = trailing.getLastChild();
        }
        while (trailing instanceof PsiComment || trailing instanceof PsiWhiteSpace) {
            PsiElement previous = trailing.getPrevSibling();
            if (trailing.getTextRange().contains(offset)) {
                return true;
            }
            trailing = previous;
        }
        return false;
    }

    @NotNull
    private static PsiElement[] getStatementsInRange(PsiElement[] children, PsiElement element1, PsiElement element2) {
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        boolean flag = false;
        for (PsiElement child : children) {
            if (child.equals(element1)) {
                flag = true;
            }
            if (flag && !(child instanceof PsiWhiteSpace)) {
                array.add(child);
            }
            if (child.equals(element2)) break;
        }
        for (PsiElement element : array) {
            if (element instanceof PsiStatement || element instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightUtil.$$$reportNull$$$0(10);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            CodeInsightUtil.$$$reportNull$$$0(11);
        }
        return psiElementArray;
    }

    @Nullable
    public static Language findJavaOrLikeLanguage(@NotNull PsiFile file) {
        if (file == null) {
            CodeInsightUtil.$$$reportNull$$$0(12);
        }
        Set languages = file.getViewProvider().getLanguages();
        for (Language language : languages) {
            if (language != StdLanguages.JAVA) continue;
            return language;
        }
        for (Language language : languages) {
            if (!language.isKindOf(StdLanguages.JAVA)) continue;
            return language;
        }
        return null;
    }

    public static <T extends PsiMember & PsiDocCommentOwner> void sortIdenticalShortNamedMembers(T[] members, @NotNull PsiReference context) {
        if (context == null) {
            CodeInsightUtil.$$$reportNull$$$0(13);
        }
        if (members.length <= 1) {
            return;
        }
        PsiElement leaf = context.getElement().getFirstChild();
        Comparator<T> comparator = CodeInsightUtil.createSortIdenticalNamedMembersComparator(leaf);
        Arrays.sort(members, comparator);
    }

    public static <T extends PsiMember & PsiDocCommentOwner> Comparator<T> createSortIdenticalNamedMembersComparator(PsiElement place) {
        PsiProximityComparator proximityComparator = new PsiProximityComparator(place);
        return (o1, o2) -> {
            String qname2;
            boolean deprecated1 = JavaCompletionUtil.isEffectivelyDeprecated((PsiDocCommentOwner)o1);
            boolean deprecated2 = JavaCompletionUtil.isEffectivelyDeprecated((PsiDocCommentOwner)o2);
            if (deprecated1 && !deprecated2) {
                return 1;
            }
            if (!deprecated1 && deprecated2) {
                return -1;
            }
            int compare = proximityComparator.compare(o1, o2);
            if (compare != 0) {
                return compare;
            }
            String qname1 = o1 instanceof PsiClass ? ((PsiClass)o1).getQualifiedName() : null;
            String string = qname2 = o2 instanceof PsiClass ? ((PsiClass)o2).getQualifiedName() : null;
            if (qname1 == null || qname2 == null) {
                return 0;
            }
            return qname1.compareToIgnoreCase(qname2);
        };
    }

    @NotNull
    public static PsiExpression[] findExpressionOccurrences(PsiElement scope, PsiExpression expr) {
        ArrayList<PsiExpression> array = new ArrayList<PsiExpression>();
        CodeInsightUtil.addExpressionOccurrences(RefactoringUtil.unparenthesizeExpression(expr), array, scope);
        if (expr.isPhysical()) {
            boolean found = false;
            for (PsiExpression psiExpression : array) {
                if (!PsiTreeUtil.isAncestor((PsiElement)expr, (PsiElement)psiExpression, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)psiExpression, (PsiElement)expr, (boolean)false)) continue;
                found = true;
                break;
            }
            if (!found) {
                array.add(expr);
            }
        }
        PsiExpression[] psiExpressionArray = array.toArray(PsiExpression.EMPTY_ARRAY);
        if (psiExpressionArray == null) {
            CodeInsightUtil.$$$reportNull$$$0(14);
        }
        return psiExpressionArray;
    }

    private static void addExpressionOccurrences(PsiExpression expr, List<? super PsiExpression> array, PsiElement scope) {
        PsiElement[] children;
        for (PsiElement child : children = scope.getChildren()) {
            if (child instanceof PsiExpression && JavaPsiEquivalenceUtil.areExpressionsEquivalent(RefactoringUtil.unparenthesizeExpression((PsiExpression)child), expr)) {
                array.add((PsiExpression)((PsiExpression)child));
                continue;
            }
            CodeInsightUtil.addExpressionOccurrences(expr, array, child);
        }
    }

    @NotNull
    public static PsiExpression[] findReferenceExpressions(PsiElement scope, PsiElement referee) {
        if (scope == null) {
            if (PsiExpression.EMPTY_ARRAY == null) {
                CodeInsightUtil.$$$reportNull$$$0(15);
            }
            return PsiExpression.EMPTY_ARRAY;
        }
        ArrayList array = new ArrayList();
        CodeInsightUtil.addReferenceExpressions(array, scope, referee);
        PsiExpression[] psiExpressionArray = array.toArray(PsiExpression.EMPTY_ARRAY);
        if (psiExpressionArray == null) {
            CodeInsightUtil.$$$reportNull$$$0(16);
        }
        return psiExpressionArray;
    }

    private static void addReferenceExpressions(List<? super PsiExpression> array, PsiElement scope, PsiElement referee) {
        PsiElement[] children;
        for (PsiElement child : children = scope.getChildren()) {
            PsiElement ref;
            if (child instanceof PsiReferenceExpression && (ref = ((PsiReferenceExpression)child).resolve()) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)ref, (PsiElement)referee)) {
                array.add((PsiExpression)((PsiExpression)child));
            }
            CodeInsightUtil.addReferenceExpressions(array, child, referee);
        }
    }

    public static Editor positionCursorAtLBrace(Project project, PsiFile targetFile, @NotNull PsiClass psiClass) {
        PsiElement lBrace;
        if (psiClass == null) {
            CodeInsightUtil.$$$reportNull$$$0(17);
        }
        return CodeInsightUtil.positionCursor(project, targetFile, (PsiElement)((lBrace = psiClass.getLBrace()) != null ? lBrace : psiClass));
    }

    public static Editor positionCursor(Project project, PsiFile targetFile, @NotNull PsiElement element) {
        TextRange range;
        if (element == null) {
            CodeInsightUtil.$$$reportNull$$$0(18);
        }
        LOG.assertTrue((range = element.getTextRange()) != null, (Object)("element: " + element + "; valid: " + element.isValid()));
        int textOffset = range.getStartOffset();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, targetFile.getVirtualFile(), textOffset);
        return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }

    public static boolean preparePsiElementsForWrite(PsiElement ... elements) {
        if (elements == null) {
            CodeInsightUtil.$$$reportNull$$$0(19);
        }
        return FileModificationService.getInstance().preparePsiElementsForWrite(Arrays.asList(elements));
    }

    public static void processSubTypes(PsiType psiType, PsiElement context, boolean getRawSubtypes, @NotNull PrefixMatcher matcher, Consumer<? super PsiType> consumer) {
        if (matcher == null) {
            CodeInsightUtil.$$$reportNull$$$0(20);
        }
        int arrayDim = psiType.getArrayDimensions();
        if (!((psiType = psiType.getDeepComponentType()) instanceof PsiClassType)) {
            return;
        }
        PsiClassType baseType = JavaCompletionUtil.originalize((PsiClassType)psiType);
        PsiClassType.ClassResolveResult baseResult = baseType.resolveGenerics();
        PsiClass baseClass = baseResult.getElement();
        PsiSubstitutor baseSubstitutor = baseResult.getSubstitutor();
        if (baseClass == null) {
            return;
        }
        GlobalSearchScope scope = context.getResolveScope();
        Processor<PsiClass> inheritorsProcessor = CodeInsightUtil.createInheritorsProcessor(context, baseType, arrayDim, getRawSubtypes, consumer, baseClass, baseSubstitutor);
        CodeInsightUtil.addContextTypeArguments(context, baseType, inheritorsProcessor);
        if (baseClass.hasModifierProperty("final")) {
            return;
        }
        Set<PsiClass> imported = CodeInsightUtil.processImportedInheritors(context, baseClass, inheritorsProcessor);
        if (matcher.getPrefix().length() > 2) {
            JBTreeTraverser traverser = JBTreeTraverser.of(PsiClass::getInnerClasses);
            AllClassesGetter.processJavaClasses(matcher, context.getProject(), scope, (Processor<? super PsiClass>)((Processor)psiClass -> {
                FilteredTraverserBase inheritors = ((JBTreeTraverser)traverser.withRoot(psiClass)).filter(c -> c.isInheritor(baseClass, true) && !imported.contains(c));
                return ContainerUtil.process((Iterable)inheritors, (Processor)inheritorsProcessor);
            }));
        } else {
            Query baseQuery = ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false);
            FilteredQuery query = new FilteredQuery(baseQuery, psiClass -> {
                if (matcher == null) {
                    CodeInsightUtil.$$$reportNull$$$0(26);
                }
                if (psiClass instanceof PsiTypeParameter) return false;
                if (!ContainerUtil.exists(JavaCompletionUtil.getAllLookupStrings((PsiMember)psiClass), arg_0 -> ((PrefixMatcher)matcher).prefixMatches(arg_0))) return false;
                if (imported.contains(psiClass)) return false;
                return true;
            });
            query.forEach(inheritorsProcessor);
        }
    }

    @NotNull
    private static Set<PsiClass> processImportedInheritors(PsiElement context, final PsiClass baseClass, final Processor<? super PsiClass> inheritorsProcessor) {
        final HashSet<PsiClass> visited = new HashSet<PsiClass>();
        context.getContainingFile().getOriginalFile().processDeclarations(new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof PsiClass && ((PsiClass)element).isInheritor(baseClass, true) && visited.add((PsiClass)element)) {
                    return inheritorsProcessor.process((Object)((PsiClass)element));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/CodeInsightUtil$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, ResolveState.initial(), null, context);
        HashSet<PsiClass> hashSet = visited;
        if (hashSet == null) {
            CodeInsightUtil.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    private static void addContextTypeArguments(PsiElement context, PsiClassType baseType, Processor<? super PsiClass> inheritorsProcessor) {
        PsiTypeParameterListOwner typed;
        HashSet usedNames = ContainerUtil.newHashSet();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        PsiElement each = context;
        while ((typed = (PsiTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)each, PsiTypeParameterListOwner.class)) != null) {
            for (PsiTypeParameter parameter2 : typed.getTypeParameters()) {
                if (!baseType.isAssignableFrom((PsiType)factory.createType((PsiClass)parameter2)) || !usedNames.add(parameter2.getName())) continue;
                inheritorsProcessor.process((Object)CompletionUtil.getOriginalOrSelf((PsiElement)parameter2));
            }
            each = typed;
        }
    }

    public static Processor<PsiClass> createInheritorsProcessor(PsiElement context, PsiClassType baseType, int arrayDim, boolean getRawSubtypes, Consumer<? super PsiType> result, @NotNull PsiClass baseClass, PsiSubstitutor baseSubstitutor) {
        if (baseClass == null) {
            CodeInsightUtil.$$$reportNull$$$0(22);
        }
        PsiManager manager = context.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        PsiElementFactory factory = facade.getElementFactory();
        return inheritor -> {
            if (baseClass == null) {
                CodeInsightUtil.$$$reportNull$$$0(25);
            }
            ProgressManager.checkCanceled();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing inheritor " + inheritor.getQualifiedName());
            }
            if (!resolveHelper.isAccessible((PsiMember)inheritor, context, null)) {
                return true;
            }
            if (inheritor.getQualifiedName() == null && !manager.areElementsEquivalent((PsiElement)inheritor.getContainingFile(), (PsiElement)context.getContainingFile().getOriginalFile())) {
                return true;
            }
            if (JavaCompletionUtil.isInExcludedPackage((PsiMember)inheritor, false)) {
                return true;
            }
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)baseClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (superSubstitutor == null) {
                return true;
            }
            List<PsiType> typeArgs = getRawSubtypes ? null : CodeInsightUtil.getExpectedTypeArgs(context, (PsiTypeParameterListOwner)inheritor, Arrays.asList(inheritor.getTypeParameters()), baseType);
            PsiClassType inheritorType = typeArgs == null || typeArgs.contains(null) ? factory.createType(inheritor, factory.createRawSubstitutor((PsiTypeParameterListOwner)inheritor)) : factory.createType(inheritor, typeArgs.toArray(PsiType.EMPTY_ARRAY));
            PsiType toAdd = PsiTypesUtil.createArrayType((PsiType)inheritorType, (int)arrayDim);
            if (baseType.isAssignableFrom(toAdd)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Inheritor type " + toAdd.getCanonicalText());
                }
                result.consume((Object)toAdd);
            }
            return true;
        };
    }

    @NotNull
    public static List<PsiType> getExpectedTypeArgs(PsiElement context, PsiTypeParameterListOwner paramOwner, Iterable<? extends PsiTypeParameter> typeParams, PsiClassType expectedType) {
        if (paramOwner instanceof PsiClass) {
            List list = GenericsUtil.getExpectedTypeArguments((PsiElement)context, (PsiClass)((PsiClass)paramOwner), typeParams, (PsiClassType)expectedType);
            if (list == null) {
                CodeInsightUtil.$$$reportNull$$$0(23);
            }
            return list;
        }
        PsiSubstitutor substitutor = SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor((PsiMethod)paramOwner, (PsiType)expectedType);
        List list = ContainerUtil.map(typeParams, arg_0 -> ((PsiSubstitutor)substitutor).substitute(arg_0));
        if (list == null) {
            CodeInsightUtil.$$$reportNull$$$0(24);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/CodeInsightUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/CodeInsightUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findStatementsInRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementsInRange";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findExpressionOccurrences";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferenceExpressions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "processImportedInheritors";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findStatementsInRange";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 24: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findJavaOrLikeLanguage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sortIdenticalShortNamedMembers";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "positionCursorAtLBrace";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "positionCursor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "preparePsiElementsForWrite";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processSubTypes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createInheritorsProcessor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createInheritorsProcessor$4";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processSubTypes$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

