/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

class AnnotationInsertHandler
implements InsertHandler<JavaPsiClassReferenceElement> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.AnnotationInsertHandler");
    static final AnnotationInsertHandler INSTANCE = new AnnotationInsertHandler();

    AnnotationInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull JavaPsiClassReferenceElement item) {
        PsiElement parentElement;
        if (context == null) {
            AnnotationInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            AnnotationInsertHandler.$$$reportNull$$$0(1);
        }
        JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER.handleInsert(context, (LookupElement)item);
        PsiFile file = context.getFile();
        PsiElement elementAt = file.findElementAt(context.getStartOffset());
        PsiElement psiElement = parentElement = elementAt != null ? elementAt.getParent() : null;
        if (elementAt instanceof PsiIdentifier && (PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiAnnotationParameterList.class) != null || parentElement instanceof PsiErrorElement && parentElement.getParent() instanceof PsiJavaFile) && AnnotationInsertHandler.isAtTokenNeeded(context)) {
            int expectedOffsetForAtToken = elementAt.getTextRange().getStartOffset();
            context.getDocument().insertString(expectedOffsetForAtToken, (CharSequence)"@");
        }
        if (JavaClassNameInsertHandler.shouldHaveAnnotationParameters(item.getObject())) {
            JavaCompletionUtil.insertParentheses(context, (LookupElement)item, false, true);
        }
    }

    private static boolean isAtTokenNeeded(InsertionContext myContext) {
        HighlighterIterator iterator = ((EditorEx)myContext.getEditor()).getHighlighter().createIterator(myContext.getStartOffset());
        LOG.assertTrue(iterator.getTokenType() == JavaTokenType.IDENTIFIER);
        iterator.retreat();
        if (iterator.getTokenType() == TokenType.WHITE_SPACE) {
            iterator.retreat();
        }
        return iterator.getTokenType() != JavaTokenType.AT && iterator.getTokenType() != JavaTokenType.DOT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/AnnotationInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

