/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveSuppressWarningAction
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.RemoveSuppressWarningAction");
    @NotNull
    private final String myID;

    public RemoveSuppressWarningAction(@NotNull String id) {
        if (id == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(0);
        }
        int idx = id.indexOf(";");
        this.myID = idx > -1 ? id.substring(0, idx) : id;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.suppression.action.family", new Object[0]);
        if (string == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(3);
        }
        PsiElement element = descriptor.getPsiElement();
        try {
            if (element != null) {
                if (element instanceof PsiComment) {
                    this.removeFromComment((PsiComment)element);
                } else {
                    PsiModifierListOwner commentOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)false);
                    if (commentOwner != null) {
                        PsiElement psiElement = JavaSuppressionUtil.getElementMemberSuppressedIn(commentOwner, this.myID);
                        if (psiElement instanceof PsiAnnotation) {
                            this.removeFromAnnotation((PsiAnnotation)psiElement);
                        } else if (psiElement instanceof PsiDocComment) {
                            this.removeFromJavaDoc((PsiDocComment)psiElement);
                        } else {
                            final HashSet comments = new HashSet();
                            commentOwner.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                                public void visitComment(PsiComment comment) {
                                    super.visitComment(comment);
                                    if (comment.getText().contains(RemoveSuppressWarningAction.this.myID)) {
                                        comments.add(comment);
                                    }
                                }
                            });
                            for (PsiComment comment : comments) {
                                try {
                                    this.removeFromComment(comment);
                                }
                                catch (IncorrectOperationException e) {
                                    LOG.error((Throwable)e);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("remove.suppression.action.name", this.myID);
        if (string == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void removeFromComment(PsiComment comment) throws IncorrectOperationException {
        String newText;
        String commentText = comment.getText();
        int secondCommentIdx = commentText.indexOf("//", 2);
        String suffix = "";
        if (secondCommentIdx > 0) {
            suffix = commentText.substring(secondCommentIdx);
        }
        if ((newText = this.removeFromElementText(new PsiElement[]{comment})) != null) {
            if (newText.isEmpty()) {
                if (suffix.isEmpty()) {
                    comment.delete();
                } else {
                    comment.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)comment.getProject()).createCommentFromText(suffix, (PsiElement)comment));
                }
            } else {
                PsiComment newComment = JavaPsiFacade.getElementFactory((Project)comment.getProject()).createCommentFromText("// noinspection " + newText + suffix, (PsiElement)comment);
                comment.replace((PsiElement)newComment);
            }
        }
    }

    private void removeFromJavaDoc(PsiDocComment docComment) throws IncorrectOperationException {
        PsiDocTag tag = docComment.findTagByName("noinspection");
        if (tag == null) {
            return;
        }
        String newText = this.removeFromElementText(tag.getDataElements());
        if (newText != null && newText.isEmpty()) {
            tag.delete();
        } else if (newText != null) {
            newText = "@noinspection " + newText;
            PsiDocTag newTag = JavaPsiFacade.getElementFactory((Project)tag.getProject()).createDocTagFromText(newText);
            tag.replace((PsiElement)newTag);
        }
    }

    @Nullable
    private String removeFromElementText(PsiElement ... elements) {
        List ids;
        int i;
        String text2 = "";
        for (PsiElement element : elements) {
            text2 = text2 + StringUtil.trimStart((String)element.getText(), (String)"//").trim();
        }
        int secondCommentIdx = (text2 = StringUtil.trimStart((String)text2, (String)"@").trim()).indexOf("//");
        if (secondCommentIdx > 0) {
            text2 = text2.substring(0, secondCommentIdx);
        }
        if ((i = ArrayUtil.find((Object[])(ids = StringUtil.split((String)(text2 = StringUtil.trimStart((String)text2, (String)"noinspection").trim()), (String)",")).toArray(), (Object)this.myID)) == -1) {
            return null;
        }
        ids.remove(i);
        return StringUtil.join((Collection)ids, (String)",");
    }

    private void removeFromAnnotation(PsiAnnotation annotation) throws IncorrectOperationException {
        PsiNameValuePair[] attributes;
        for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
            PsiAnnotationMemberValue value2 = attribute.getValue();
            if (value2 instanceof PsiArrayInitializerMemberValue) {
                PsiAnnotationMemberValue[] initializers;
                for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value2).getInitializers()) {
                    if (!this.removeFromValue((PsiAnnotationMemberValue)annotation, initializer, initializers.length == 1)) continue;
                    return;
                }
            }
            if (!this.removeFromValue((PsiAnnotationMemberValue)annotation, value2, attributes.length == 1)) continue;
            return;
        }
    }

    private boolean removeFromValue(PsiAnnotationMemberValue parent, PsiAnnotationMemberValue value2, boolean removeParent) throws IncorrectOperationException {
        String text2 = value2.getText();
        text2 = StringUtil.trimStart((String)text2, (String)"\"");
        if (this.myID.equals(text2 = StringUtil.trimEnd((String)text2, (String)"\""))) {
            if (removeParent) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)parent);
            } else {
                value2.delete();
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/RemoveSuppressWarningAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/RemoveSuppressWarningAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

