/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class MoveCatchUpFix
implements IntentionAction {
    private final PsiCatchSection myCatchSection;
    private final PsiCatchSection myMoveBeforeSection;

    public MoveCatchUpFix(@NotNull PsiCatchSection catchSection, @NotNull PsiCatchSection moveBeforeSection) {
        if (catchSection == null) {
            MoveCatchUpFix.$$$reportNull$$$0(0);
        }
        if (moveBeforeSection == null) {
            MoveCatchUpFix.$$$reportNull$$$0(1);
        }
        this.myCatchSection = catchSection;
        this.myMoveBeforeSection = moveBeforeSection;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("move.catch.up.text", JavaHighlightUtil.formatType(this.myCatchSection.getCatchType()), JavaHighlightUtil.formatType(this.myMoveBeforeSection.getCatchType()));
        if (string == null) {
            MoveCatchUpFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("move.catch.up.family", new Object[0]);
        if (string == null) {
            MoveCatchUpFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            MoveCatchUpFix.$$$reportNull$$$0(4);
        }
        return this.myCatchSection.isValid() && BaseIntentionAction.canModify((PsiElement)this.myCatchSection) && this.myMoveBeforeSection.isValid() && this.myCatchSection.getCatchType() != null && PsiUtil.resolveClassInType((PsiType)this.myCatchSection.getCatchType()) != null && this.myMoveBeforeSection.getCatchType() != null && PsiUtil.resolveClassInType((PsiType)this.myMoveBeforeSection.getCatchType()) != null && !this.myCatchSection.getManager().areElementsEquivalent((PsiElement)PsiUtil.resolveClassInType((PsiType)this.myCatchSection.getCatchType()), (PsiElement)PsiUtil.resolveClassInType((PsiType)this.myMoveBeforeSection.getCatchType()));
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            MoveCatchUpFix.$$$reportNull$$$0(5);
        }
        PsiCatchSection psiCatchSection = this.myCatchSection;
        if (psiCatchSection == null) {
            MoveCatchUpFix.$$$reportNull$$$0(6);
        }
        return psiCatchSection;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            MoveCatchUpFix.$$$reportNull$$$0(7);
        }
        PsiTryStatement statement = this.myCatchSection.getTryStatement();
        statement.addBefore((PsiElement)this.myCatchSection, (PsiElement)this.myMoveBeforeSection);
        this.myCatchSection.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchSection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveBeforeSection";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToMakeWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

