/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.surroundWith.JavaStatementsSurrounder;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

public class JavaWithSynchronizedSurrounder
extends JavaStatementsSurrounder {
    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.synchronized.template", (Object[])new Object[0]);
    }

    @Override
    public TextRange surroundStatements(Project project, Editor editor, PsiElement container, PsiElement[] statements) throws IncorrectOperationException {
        PsiManager manager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        if ((statements = SurroundWithUtil.moveDeclarationsOut(container, statements, false)).length == 0) {
            return null;
        }
        String text2 = "synchronized(a){\n}";
        PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)factory.createStatementFromText(text2, null);
        synchronizedStatement = (PsiSynchronizedStatement)codeStyleManager.reformat((PsiElement)synchronizedStatement);
        PsiCodeBlock synchronizedBlock = (synchronizedStatement = (PsiSynchronizedStatement)container.addAfter((PsiElement)synchronizedStatement, statements[statements.length - 1])).getBody();
        if (synchronizedBlock == null) {
            return null;
        }
        SurroundWithUtil.indentCommentIfNecessary(synchronizedBlock, statements);
        synchronizedBlock.addRange(statements[0], statements[statements.length - 1]);
        container.deleteChildRange(statements[0], statements[statements.length - 1]);
        synchronizedStatement = (PsiSynchronizedStatement)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)synchronizedStatement);
        PsiExpression lockExpression2 = synchronizedStatement.getLockExpression();
        if (lockExpression2 == null) {
            return null;
        }
        TextRange range = lockExpression2.getTextRange();
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        return new TextRange(range.getStartOffset(), range.getStartOffset());
    }
}

