/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.IOUtil;
import com.intellij.xml.util.XmlUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToBasicLatinAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.ConvertToBasicLatinAction");
    private static final Handler[] ourHandlers = new Handler[]{new MyLiteralHandler(), new MyDocCommentHandler(), new MyCommentHandler()};

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ConvertToBasicLatinAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ConvertToBasicLatinAction.$$$reportNull$$$0(1);
        }
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        Pair<PsiElement, Handler> pair = ConvertToBasicLatinAction.findHandler(element);
        if (pair == null) {
            return false;
        }
        String text2 = ((PsiElement)pair.first).getText();
        return !IOUtil.isAscii((String)text2);
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.convert.to.basic.latin", (Object[])new Object[0]);
        if (string == null) {
            ConvertToBasicLatinAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ConvertToBasicLatinAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Pair<PsiElement, Handler> pair;
        if (project == null) {
            ConvertToBasicLatinAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ConvertToBasicLatinAction.$$$reportNull$$$0(5);
        }
        if ((pair = ConvertToBasicLatinAction.findHandler(element)) == null) {
            return;
        }
        PsiElement workElement = (PsiElement)pair.first;
        Handler handler = (Handler)pair.second;
        String newText = handler.processText(workElement);
        PsiElement newElement = handler.createReplacement(workElement, newText);
        workElement.replace(newElement);
    }

    @Nullable
    private static Pair<PsiElement, Handler> findHandler(PsiElement element) {
        for (Handler handler : ourHandlers) {
            PsiElement applicable = handler.findApplicable(element);
            if (applicable == null) continue;
            return Pair.create((Object)applicable, (Object)handler);
        }
        return null;
    }

    private static boolean shouldConvert(char ch) {
        return Character.UnicodeBlock.of(ch) != Character.UnicodeBlock.BASIC_LATIN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ConvertToBasicLatinAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ConvertToBasicLatinAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCommentHandler
    extends MyDocCommentHandler {
        private MyCommentHandler() {
        }

        @Override
        public PsiElement findApplicable(PsiElement element) {
            return element instanceof PsiComment ? element : null;
        }

        @Override
        public PsiElement createReplacement(PsiElement element, String newText) {
            return JavaPsiFacade.getElementFactory((Project)element.getProject()).createCommentFromText(newText, element.getParent());
        }
    }

    private static class MyDocCommentHandler
    extends Handler {
        private static Map<Character, String> ourEntities;

        private MyDocCommentHandler() {
        }

        @Override
        public PsiElement findApplicable(PsiElement element) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocComment.class, (boolean)false);
        }

        @Override
        public String processText(PsiElement element) {
            MyDocCommentHandler.loadEntities(element.getProject());
            return super.processText(element);
        }

        @Override
        protected void convert(StringBuilder sb, char ch) {
            assert (ourEntities != null);
            String entity = ourEntities.get(Character.valueOf(ch));
            if (entity != null) {
                sb.append('&').append(entity).append(';');
            } else {
                sb.append("&#x").append(Integer.toHexString(ch)).append(';');
            }
        }

        @Override
        public PsiElement createReplacement(PsiElement element, String newText) {
            return JavaPsiFacade.getElementFactory((Project)element.getProject()).createDocCommentFromText(newText);
        }

        private static void loadEntities(Project project) {
            XmlFile file;
            if (ourEntities != null) {
                return;
            }
            try {
                String url = ExternalResourceManager.getInstance().getResourceLocation("http://www.w3.org/TR/html4/loose.dtd", project);
                if (url == null) {
                    LOG.error("Namespace not found: http://www.w3.org/TR/html4/loose.dtd");
                    return;
                }
                VirtualFile vFile = VfsUtil.findFileByURL((URL)new URL(url));
                if (vFile == null) {
                    LOG.error("Resource not found: " + url);
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
                if (!(psiFile instanceof XmlFile)) {
                    LOG.error("Unexpected resource: " + psiFile);
                    return;
                }
                file = (XmlFile)psiFile;
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
                return;
            }
            ourEntities = new HashMap<Character, String>();
            final Pattern pattern = Pattern.compile("&#(\\d+);");
            XmlUtil.processXmlElements((XmlElement)file, (PsiElementProcessor)new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    char i;
                    XmlEntityDecl entity;
                    Matcher m;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof XmlEntityDecl && (m = pattern.matcher((entity = (XmlEntityDecl)element).getValueElement().getValue())).matches() && ConvertToBasicLatinAction.shouldConvert(i = (char)Integer.parseInt(m.group(1)))) {
                        ourEntities.put(Character.valueOf(i), entity.getName());
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ConvertToBasicLatinAction$MyDocCommentHandler$1", "execute"));
                }
            }, (boolean)true);
        }
    }

    private static class MyLiteralHandler
    extends Handler {
        private static final TokenSet LITERALS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.CHARACTER_LITERAL, JavaTokenType.STRING_LITERAL});

        private MyLiteralHandler() {
        }

        @Override
        public PsiElement findApplicable(PsiElement element) {
            PsiElement parent = element.getParent();
            return element instanceof PsiJavaToken && LITERALS.contains(((PsiJavaToken)element).getTokenType()) && parent instanceof PsiLiteralExpression ? parent : null;
        }

        @Override
        public PsiElement createReplacement(PsiElement element, String newText) {
            return JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText(newText, element.getParent());
        }

        @Override
        protected void convert(StringBuilder sb, char ch) {
            sb.append(String.format("\\u%04x", ch));
        }
    }

    private static abstract class Handler {
        private Handler() {
        }

        @Nullable
        public abstract PsiElement findApplicable(PsiElement var1);

        public String processText(PsiElement element) {
            String text2 = element.getText();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < text2.length(); ++i) {
                char ch = text2.charAt(i);
                if (!ConvertToBasicLatinAction.shouldConvert(ch)) {
                    sb.append(ch);
                    continue;
                }
                this.convert(sb, ch);
            }
            return sb.toString();
        }

        protected abstract void convert(StringBuilder var1, char var2);

        public abstract PsiElement createReplacement(PsiElement var1, String var2);
    }
}

