/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvertIfConditionAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.InvertIfConditionAction");

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiElement block;
        if (project == null) {
            InvertIfConditionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            InvertIfConditionAction.$$$reportNull$$$0(1);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class);
        if (ifStatement == null) {
            return false;
        }
        PsiExpression condition2 = ifStatement.getCondition();
        if (condition2 == null) {
            return false;
        }
        if (ifStatement.getThenBranch() == null) {
            return false;
        }
        if (SyntaxTraverser.psiTraverser((PsiElement)condition2).filter(PsiPrefixExpression.class).filter(prefixExpr -> PsiUtil.skipParenthesizedExprDown((PsiExpression)prefixExpr.getOperand()) == null).first() != null) {
            return false;
        }
        if (element instanceof PsiKeyword) {
            if (element.getParent() != ifStatement) {
                return false;
            }
            IElementType tokenType = ((PsiKeyword)element).getTokenType();
            if (tokenType != JavaTokenType.IF_KEYWORD && tokenType != JavaTokenType.ELSE_KEYWORD) {
                return false;
            }
        } else {
            TextRange condTextRange = condition2.getTextRange();
            if (condTextRange == null || !condTextRange.contains(offset)) {
                return false;
            }
        }
        if ((block = InvertIfConditionAction.findCodeBlock(ifStatement)) == null) {
            return false;
        }
        if (PsiUtil.skipParenthesizedExprDown((PsiExpression)ifStatement.getCondition()) == null) {
            return true;
        }
        ControlFlow localFlow = InvertIfConditionAction.buildControlFlow(block);
        int startThenOffset = InvertIfConditionAction.getThenOffset(localFlow, ifStatement);
        int afterIfOffset = localFlow.getEndOffset((PsiElement)ifStatement);
        return startThenOffset >= 0 && afterIfOffset >= 0;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            InvertIfConditionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.invert.if.condition", (Object[])new Object[0]);
        if (string == null) {
            InvertIfConditionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiIfStatement ifStatement;
        if (project == null) {
            InvertIfConditionAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            InvertIfConditionAction.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class)) != null);
        PsiElement block = InvertIfConditionAction.findCodeBlock(ifStatement);
        LOG.assertTrue(block != null);
        ControlFlow controlFlow = InvertIfConditionAction.buildControlFlow(block);
        ifStatement = InvertIfConditionAction.setupBranches(ifStatement, controlFlow);
        PsiExpression condition2 = Objects.requireNonNull(ifStatement.getCondition());
        if (condition2 != null) {
            CommentTracker tracker = new CommentTracker();
            String negatedCondition = BoolUtils.getNegatedExpressionText(condition2, tracker);
            tracker.replaceAndRestoreComments((PsiElement)condition2, negatedCondition);
        }
        InvertIfConditionAction.formatIf(ifStatement);
    }

    private static void formatIf(PsiIfStatement ifStatement) throws IncorrectOperationException {
        PsiBlockStatement codeBlock1;
        Project project = ifStatement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiElement thenBranch = Objects.requireNonNull(ifStatement.getThenBranch()).copy();
        PsiElement elseBranch = ifStatement.getElseBranch() != null ? ifStatement.getElseBranch().copy() : null;
        PsiElement condition2 = Objects.requireNonNull(ifStatement.getCondition()).copy();
        CodeStyleManager codeStyle = CodeStyleManager.getInstance((Project)project);
        PsiBlockStatement codeBlock = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)ifStatement);
        codeBlock = (PsiBlockStatement)codeStyle.reformat((PsiElement)codeBlock);
        ifStatement.getThenBranch().replace((PsiElement)codeBlock);
        if (elseBranch != null) {
            ifStatement.getElseBranch().replace((PsiElement)codeBlock);
        }
        ifStatement.getCondition().replace((PsiElement)factory.createExpressionFromText("true", null));
        ifStatement = (PsiIfStatement)codeStyle.reformat((PsiElement)ifStatement);
        if (!(thenBranch instanceof PsiBlockStatement)) {
            codeBlock1 = (PsiBlockStatement)Objects.requireNonNull(ifStatement.getThenBranch()).replace((PsiElement)codeBlock);
            codeBlock1 = (PsiBlockStatement)codeStyle.reformat((PsiElement)codeBlock1);
            codeBlock1.getCodeBlock().add(thenBranch);
        } else {
            Objects.requireNonNull(ifStatement.getThenBranch()).replace(thenBranch);
        }
        if (elseBranch != null) {
            if (!(elseBranch instanceof PsiBlockStatement)) {
                codeBlock1 = (PsiBlockStatement)Objects.requireNonNull(ifStatement.getElseBranch()).replace((PsiElement)codeBlock);
                codeBlock1 = (PsiBlockStatement)codeStyle.reformat((PsiElement)codeBlock1);
                codeBlock1.getCodeBlock().add(elseBranch);
            } else {
                elseBranch = Objects.requireNonNull(ifStatement.getElseBranch()).replace(elseBranch);
                if (InvertIfConditionAction.emptyBlock(((PsiBlockStatement)elseBranch).getCodeBlock())) {
                    ifStatement.getElseBranch().delete();
                }
            }
        }
        Objects.requireNonNull(ifStatement.getCondition()).replace(condition2);
    }

    private static boolean emptyBlock(PsiCodeBlock block) {
        PsiElement[] children;
        for (PsiElement child : children = block.getChildren()) {
            if (child instanceof PsiComment) {
                return false;
            }
            if (child instanceof PsiWhiteSpace || child instanceof PsiJavaToken) continue;
            return false;
        }
        return true;
    }

    private static PsiElement findCodeBlock(PsiIfStatement ifStatement) {
        PsiElement e = PsiTreeUtil.getParentOfType((PsiElement)ifStatement, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class, PsiLambdaExpression.class});
        if (e instanceof PsiMethod) {
            return ((PsiMethod)e).getBody();
        }
        if (e instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)e).getBody();
        }
        if (e instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)e).getBody();
        }
        return null;
    }

    @NotNull
    private static ControlFlow buildControlFlow(@Nullable PsiElement element) {
        ControlFlow controlFlow;
        if (element == null) {
            ControlFlow controlFlow2 = ControlFlow.EMPTY;
            if (controlFlow2 == null) {
                InvertIfConditionAction.$$$reportNull$$$0(6);
            }
            return controlFlow2;
        }
        try {
            controlFlow = ControlFlowFactory.getInstance(element.getProject()).getControlFlow(element, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
        }
        catch (AnalysisCanceledException e) {
            ControlFlow controlFlow3 = ControlFlow.EMPTY;
            if (controlFlow3 == null) {
                InvertIfConditionAction.$$$reportNull$$$0(8);
            }
            return controlFlow3;
        }
        if (controlFlow == null) {
            InvertIfConditionAction.$$$reportNull$$$0(7);
        }
        return controlFlow;
    }

    private static PsiIfStatement setupBranches(PsiIfStatement ifStatement, ControlFlow flow) throws IncorrectOperationException {
        PsiElement parent;
        boolean nextUnreachable;
        PsiElement element;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)ifStatement.getProject());
        Project project = ifStatement.getProject();
        CommentTracker ct = new CommentTracker();
        PsiStatement thenBranch = Objects.requireNonNull(ifStatement.getThenBranch());
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            elseBranch = (PsiStatement)elseBranch.copy();
            InvertIfConditionAction.setElseBranch(ifStatement, thenBranch, flow, ct);
            ct.replaceAndRestoreComments((PsiElement)ifStatement.getThenBranch(), (PsiElement)elseBranch);
            return ifStatement;
        }
        CodeStyleManager codeStyle = CodeStyleManager.getInstance((Project)project);
        if (flow.getSize() == 0) {
            ifStatement.setElseBranch(thenBranch);
            PsiStatement statement = factory.createStatementFromText("{}", (PsiElement)ifStatement);
            statement = (PsiStatement)codeStyle.reformat((PsiElement)statement);
            statement = (PsiStatement)ct.replaceAndRestoreComments((PsiElement)ifStatement.getThenBranch(), (PsiElement)statement);
            codeStyle.reformat((PsiElement)statement);
            return ifStatement;
        }
        int endOffset = InvertIfConditionAction.calcEndOffset(flow, ifStatement);
        LOG.assertTrue(endOffset >= 0);
        if (endOffset >= flow.getSize()) {
            PsiStatement statement = factory.createStatementFromText("return;", (PsiElement)ifStatement);
            statement = (PsiStatement)codeStyle.reformat((PsiElement)statement);
            if (thenBranch instanceof PsiBlockStatement) {
                if (ifStatement.getParent() instanceof PsiIfStatement) {
                    ifStatement = (PsiIfStatement)InvertIfConditionAction.wrapWithCodeBlock((PsiStatement)ifStatement);
                    thenBranch = ifStatement.getThenBranch();
                    assert (thenBranch != null);
                }
                PsiCodeBlock codeBlock = ((PsiBlockStatement)thenBranch).getCodeBlock();
                PsiElement firstElement = codeBlock.getFirstBodyElement();
                PsiElement lastElement = codeBlock.getLastBodyElement();
                if (firstElement != null && lastElement != null) {
                    ifStatement.getParent().addRangeAfter(firstElement, lastElement, (PsiElement)ifStatement);
                    ct.markRangeUnchanged(firstElement, lastElement);
                }
            } else if (!(thenBranch instanceof PsiReturnStatement)) {
                ifStatement = InvertIfConditionAction.addAfterWithinCodeBlock(ifStatement, ct.markUnchanged(thenBranch));
            }
            ct.replaceAndRestoreComments((PsiElement)Objects.requireNonNull(ifStatement.getThenBranch()), (PsiElement)statement);
            return ifStatement;
        }
        for (element = flow.getElement(endOffset); element != null && !(element instanceof PsiStatement); element = element.getParent()) {
        }
        if (element != null && element.getParent() instanceof PsiForStatement && ((PsiForStatement)element.getParent()).getUpdate() == element || element instanceof PsiWhileStatement && flow.getStartOffset(element) == endOffset && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)ifStatement, (boolean)true) || element instanceof PsiForeachStatement && flow.getStartOffset(element) + 1 == endOffset) {
            PsiStatement statement = factory.createStatementFromText("continue;", (PsiElement)ifStatement);
            statement = (PsiStatement)codeStyle.reformat((PsiElement)statement);
            ifStatement = InvertIfConditionAction.addAfterWithinCodeBlock(ifStatement, ct.markUnchanged(thenBranch));
            Objects.requireNonNull(ifStatement.getThenBranch()).replace((PsiElement)statement);
            return ifStatement;
        }
        if (element instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)element;
            ifStatement = InvertIfConditionAction.addAfterWithinCodeBlock(ifStatement, ct.markUnchanged(thenBranch));
            ct.replaceAndRestoreComments((PsiElement)Objects.requireNonNull(ifStatement.getThenBranch()), returnStatement.copy());
            ControlFlow flow2 = InvertIfConditionAction.buildControlFlow(InvertIfConditionAction.findCodeBlock(ifStatement));
            if (!ControlFlowUtil.isInstructionReachable(flow2, flow2.getStartOffset((PsiElement)returnStatement), 0)) {
                returnStatement.delete();
            }
            return ifStatement;
        }
        boolean bl = nextUnreachable = flow.getEndOffset((PsiElement)ifStatement) == flow.getSize();
        if (!nextUnreachable && (parent = ifStatement.getParent()) != null) {
            if (!(parent instanceof PsiCodeBlock)) {
                ifStatement = (PsiIfStatement)InvertIfConditionAction.wrapWithCodeBlock((PsiStatement)ifStatement);
                parent = ifStatement.getParent();
                thenBranch = ifStatement.getThenBranch();
            }
            ControlFlow localFlow = InvertIfConditionAction.buildControlFlow(parent);
            int startThenOffset = InvertIfConditionAction.getThenOffset(localFlow, ifStatement);
            int afterIfOffset = localFlow.getEndOffset((PsiElement)ifStatement);
            boolean bl2 = nextUnreachable = !ControlFlowUtil.isInstructionReachable(localFlow, afterIfOffset, startThenOffset);
        }
        if (nextUnreachable) {
            InvertIfConditionAction.setElseBranch(ifStatement, thenBranch, flow, ct);
            PsiElement first = PsiTreeUtil.skipWhitespacesForward((PsiElement)ifStatement);
            if (first != null) {
                PsiElement last = first;
                for (PsiElement next = last.getNextSibling(); next != null && !(next instanceof PsiSwitchLabelStatement); next = next.getNextSibling()) {
                    last = next;
                }
                while (first != last && (last instanceof PsiWhiteSpace || PsiUtil.isJavaToken((PsiElement)last, (IElementType)JavaTokenType.RBRACE))) {
                    last = last.getPrevSibling();
                }
                PsiBlockStatement codeBlock = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)ifStatement);
                codeBlock.getCodeBlock().addRange(first, last);
                ct.replaceAndRestoreComments((PsiElement)ifStatement.getThenBranch(), (PsiElement)codeBlock);
                first.getParent().deleteChildRange(first, last);
            }
            codeStyle.reformat((PsiElement)ifStatement);
            return ifStatement;
        }
        InvertIfConditionAction.setElseBranch(ifStatement, thenBranch, flow, ct);
        PsiStatement statement = factory.createStatementFromText("{}", (PsiElement)ifStatement);
        statement = (PsiStatement)codeStyle.reformat((PsiElement)statement);
        statement = (PsiStatement)ct.replaceAndRestoreComments((PsiElement)Objects.requireNonNull(ifStatement.getThenBranch()), (PsiElement)statement);
        codeStyle.reformat((PsiElement)statement);
        return ifStatement;
    }

    private static void setElseBranch(PsiIfStatement ifStatement, PsiStatement thenBranch, ControlFlow flow, CommentTracker ct) throws IncorrectOperationException {
        if (flow.getEndOffset((PsiElement)ifStatement) == flow.getEndOffset((PsiElement)thenBranch)) {
            PsiStatement[] statements;
            Object[] statements2;
            PsiStatement body2;
            PsiLoopStatement loopStmt = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, PsiLoopStatement.class);
            if (loopStmt != null && (body2 = loopStmt.getBody()) instanceof PsiBlockStatement && (statements2 = ((PsiBlockStatement)body2).getCodeBlock().getStatements()).length > 0 && !PsiTreeUtil.isAncestor((PsiElement)statements2[statements2.length - 1], (PsiElement)ifStatement, (boolean)false) && ArrayUtilRt.find((Object[])statements2, (Object)ifStatement) < 0) {
                ifStatement.setElseBranch(ct.markUnchanged(thenBranch));
                return;
            }
            if (thenBranch instanceof PsiContinueStatement) {
                PsiStatement elseBranch = ifStatement.getElseBranch();
                if (elseBranch != null) {
                    elseBranch.delete();
                }
                return;
            }
            if (thenBranch instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)thenBranch).getCodeBlock().getStatements()).length > 0 && statements[statements.length - 1] instanceof PsiContinueStatement) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)statements[statements.length - 1]);
            }
        }
        ifStatement.setElseBranch(ct.markUnchanged(thenBranch));
    }

    private static PsiStatement wrapWithCodeBlock(@NotNull PsiStatement statement) {
        if (statement == null) {
            InvertIfConditionAction.$$$reportNull$$$0(9);
        }
        Project project = statement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        CodeStyleManager codeStyle = CodeStyleManager.getInstance((Project)project);
        PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText("if (true) {}", (PsiElement)statement);
        ifStatement = (PsiIfStatement)codeStyle.reformat((PsiElement)ifStatement);
        PsiStatement thenBranch = ifStatement.getThenBranch();
        assert (thenBranch instanceof PsiBlockStatement);
        ((PsiBlockStatement)thenBranch).getCodeBlock().add((PsiElement)statement);
        PsiCodeBlock stmt = ((PsiBlockStatement)statement.replace((PsiElement)thenBranch)).getCodeBlock();
        return stmt.getStatements()[0];
    }

    private static PsiIfStatement addAfterWithinCodeBlock(@NotNull PsiIfStatement ifStatement, @NotNull PsiStatement branch) {
        PsiElement parent;
        if (ifStatement == null) {
            InvertIfConditionAction.$$$reportNull$$$0(10);
        }
        if (branch == null) {
            InvertIfConditionAction.$$$reportNull$$$0(11);
        }
        if ((parent = ifStatement.getParent()) != null && !(parent instanceof PsiCodeBlock)) {
            branch = (PsiStatement)branch.copy();
            ifStatement = (PsiIfStatement)InvertIfConditionAction.wrapWithCodeBlock((PsiStatement)ifStatement);
        }
        InvertIfConditionAction.addAfter(ifStatement, branch);
        return ifStatement;
    }

    static void addAfter(PsiIfStatement ifStatement, PsiStatement branch) throws IncorrectOperationException {
        if (branch instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)branch;
            PsiCodeBlock block = blockStatement.getCodeBlock();
            PsiElement firstBodyElement = block.getFirstBodyElement();
            PsiElement lastBodyElement = block.getLastBodyElement();
            if (firstBodyElement != null && lastBodyElement != null) {
                ifStatement.getParent().addRangeAfter(firstBodyElement, lastBodyElement, (PsiElement)ifStatement);
            }
        } else {
            ifStatement.getParent().addAfter((PsiElement)branch, (PsiElement)ifStatement);
        }
    }

    private static int getThenOffset(ControlFlow controlFlow, PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        for (int i = 0; i < controlFlow.getSize(); ++i) {
            if (!PsiTreeUtil.isAncestor((PsiElement)thenBranch, (PsiElement)controlFlow.getElement(i), (boolean)false)) continue;
            return i;
        }
        return -1;
    }

    private static int calcEndOffset(ControlFlow controlFlow, PsiIfStatement ifStatement) {
        int endOffset = -1;
        List<Instruction> instructions = controlFlow.getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            BranchingInstruction goToInstruction;
            Instruction instruction = instructions.get(i);
            if (controlFlow.getElement(i) != ifStatement) continue;
            if (instruction instanceof GoToInstruction) {
                goToInstruction = (GoToInstruction)instruction;
                if (goToInstruction.role != BranchingInstruction.Role.END) continue;
                endOffset = goToInstruction.offset;
                break;
            }
            if (!(instruction instanceof ConditionalGoToInstruction)) continue;
            goToInstruction = (ConditionalGoToInstruction)instruction;
            if (((ConditionalGoToInstruction)goToInstruction).role != BranchingInstruction.Role.END) continue;
            endOffset = ((ConditionalGoToInstruction)goToInstruction).offset;
            break;
        }
        if (endOffset == -1) {
            endOffset = controlFlow.getSize();
        }
        while (endOffset < instructions.size() && instructions.get(endOffset) instanceof GoToInstruction && !((GoToInstruction)instructions.get((int)endOffset)).isReturn && !(controlFlow.getElement(endOffset) instanceof PsiBreakStatement) && !(controlFlow.getElement(endOffset) instanceof PsiContinueStatement)) {
            endOffset = ((BranchingInstruction)instructions.get((int)endOffset)).offset;
        }
        return endOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/InvertIfConditionAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/InvertIfConditionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildControlFlow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithCodeBlock";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addAfterWithinCodeBlock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

