/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class SplitDeclarationAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.split.declaration.family", (Object[])new Object[0]);
        if (string == null) {
            SplitDeclarationAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            SplitDeclarationAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            SplitDeclarationAction.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        if (!SplitDeclarationAction.canModify((PsiElement)element)) {
            return false;
        }
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiDeclarationStatement.class, PsiClass.class});
        if (context instanceof PsiDeclarationStatement) {
            return this.isAvailableOnDeclarationStatement((PsiDeclarationStatement)context, element);
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (field != null && PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocComment.class) == null && SplitDeclarationAction.isAvailableOnField(field)) {
            this.setText(CodeInsightBundle.message((String)"intention.split.declaration.text", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static boolean isAvailableOnField(PsiField field) {
        PsiElement nextField;
        PsiTypeElement typeElement = field.getTypeElement();
        if (typeElement == null) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiField.class) != field) {
            return true;
        }
        for (nextField = field.getNextSibling(); nextField != null && !(nextField instanceof PsiField); nextField = nextField.getNextSibling()) {
        }
        return nextField != null && ((PsiField)nextField).getTypeElement() == typeElement;
    }

    private boolean isAvailableOnDeclarationStatement(PsiDeclarationStatement decl, PsiElement element) {
        PsiElement[] declaredElements = decl.getDeclaredElements();
        if (declaredElements.length == 0) {
            return false;
        }
        if (!(declaredElements[0] instanceof PsiLocalVariable)) {
            return false;
        }
        if (declaredElements.length == 1) {
            PsiLocalVariable var = (PsiLocalVariable)declaredElements[0];
            if (var.getInitializer() == null) {
                return false;
            }
            if (var.getTypeElement().isInferredType() && !PsiTypesUtil.isDenotableType((PsiType)var.getType(), (PsiElement)var)) {
                return false;
            }
            PsiElement parent = decl.getParent();
            if (parent instanceof PsiForStatement) {
                final String varName = var.getName();
                if (varName == null) {
                    return false;
                }
                for (parent = parent.getNextSibling(); parent != null; parent = parent.getNextSibling()) {
                    final Ref conflictFound = new Ref((Object)false);
                    parent.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitClass(PsiClass aClass) {
                        }

                        public void visitVariable(PsiVariable variable) {
                            super.visitVariable(variable);
                            if (varName.equals(variable.getName())) {
                                conflictFound.set((Object)true);
                                this.stopWalking();
                            }
                        }
                    });
                    if (!((Boolean)conflictFound.get()).booleanValue()) continue;
                    return false;
                }
            }
            this.setText(CodeInsightBundle.message((String)"intention.split.declaration.assignment.text", (Object[])new Object[0]));
            return true;
        }
        if (decl.getParent() instanceof PsiForStatement) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.split.declaration.text", (Object[])new Object[0]));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            SplitDeclarationAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SplitDeclarationAction.$$$reportNull$$$0(4);
        }
        PsiDeclarationStatement decl = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDeclarationStatement.class);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (decl != null) {
            SplitDeclarationAction.invokeOnDeclarationStatement(decl, psiManager, project);
        } else {
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
            if (field != null) {
                field.normalizeDeclaration();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PsiAssignmentExpression invokeOnDeclarationStatement(PsiDeclarationStatement decl, PsiManager psiManager, Project project) {
        if (decl.getDeclaredElements().length == 1) {
            PsiLocalVariable var = (PsiLocalVariable)decl.getDeclaredElements()[0];
            var.normalizeDeclaration();
            PsiTypeElement typeElement = var.getTypeElement();
            if (typeElement.isInferredType()) {
                PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)typeElement);
            }
            String name = var.getName();
            assert (name != null);
            PsiExpressionStatement statement = (PsiExpressionStatement)JavaPsiFacade.getElementFactory((Project)psiManager.getProject()).createStatementFromText(name + "=xxx;", (PsiElement)decl);
            statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)statement);
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement.getExpression();
            PsiExpression initializer = var.getInitializer();
            assert (initializer != null);
            PsiExpression rExpression = RefactoringUtil.convertInitializerToNormalExpression(initializer, var.getType());
            PsiExpression expression2 = assignment.getRExpression();
            assert (expression2 != null);
            expression2.replace((PsiElement)rExpression);
            PsiElement block = decl.getParent();
            if (block instanceof PsiForStatement) {
                PsiDeclarationStatement varDeclStatement = JavaPsiFacade.getElementFactory((Project)psiManager.getProject()).createVariableDeclarationStatement(name, var.getType(), null);
                for (PsiElement varDecl : varDeclStatement.getDeclaredElements()) {
                    if (!(varDecl instanceof PsiModifierListOwner)) continue;
                    PsiModifierList modList = ((PsiModifierListOwner)varDecl).getModifierList();
                    assert (modList != null);
                    modList.setModifierProperty("final", false);
                }
                PsiElement parent = block.getParent();
                PsiExpressionStatement replaced = (PsiExpressionStatement)new CommentTracker().replaceAndRestoreComments((PsiElement)decl, (PsiElement)statement);
                if (!(parent instanceof PsiCodeBlock)) {
                    PsiBlockStatement blockStatement = (PsiBlockStatement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("{}", block);
                    PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                    codeBlock.add((PsiElement)varDeclStatement);
                    codeBlock.add(block);
                    block.replace((PsiElement)blockStatement);
                } else {
                    parent.addBefore((PsiElement)varDeclStatement, block);
                }
                return (PsiAssignmentExpression)replaced.getExpression();
            }
            try {
                PsiElement declaredElement = decl.getDeclaredElements()[0];
                if (!PsiUtil.isJavaToken((PsiElement)declaredElement.getLastChild(), (IElementType)JavaTokenType.SEMICOLON)) {
                    LeafElement semicolon = Factory.createSingleLeafElement((IElementType)JavaTokenType.SEMICOLON, (CharSequence)";", (int)0, (int)1, null, (PsiManager)decl.getManager());
                    CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)decl.addAfter(semicolon.getPsi(), declaredElement));
                }
                PsiAssignmentExpression psiAssignmentExpression = (PsiAssignmentExpression)((PsiExpressionStatement)block.addAfter((PsiElement)statement, (PsiElement)decl)).getExpression();
                return psiAssignmentExpression;
            }
            finally {
                initializer.delete();
            }
        }
        ((PsiLocalVariable)decl.getDeclaredElements()[0]).normalizeDeclaration();
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SplitDeclarationAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SplitDeclarationAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

