/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaCanBeMethodReferenceInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(LambdaCanBeMethodReferenceInspection.class);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Lambda can be replaced with method reference" == null) {
            LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(1);
        }
        return "Lambda can be replaced with method reference";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("Convert2MethodRef" == null) {
            LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(2);
        }
        return "Convert2MethodRef";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(3);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                super.visitLambdaExpression(expression2);
                if (PsiUtil.getLanguageLevel((PsiElement)expression2).isAtLeast(LanguageLevel.JDK_1_8)) {
                    ProblemHighlightType type2;
                    PsiElement body2 = expression2.getBody();
                    PsiType functionalInterfaceType = expression2.getFunctionalInterfaceType();
                    if (functionalInterfaceType == null) {
                        return;
                    }
                    MethodReferenceCandidate methodRefCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression(body2);
                    if (methodRefCandidate == null) {
                        return;
                    }
                    PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiVariable[])expression2.getParameterList().getParameters(), functionalInterfaceType, null, methodRefCandidate.myExpression);
                    if (candidate == null) {
                        return;
                    }
                    if (methodRefCandidate.mySafeQualifier && methodRefCandidate.myConformsCodeStyle) {
                        type2 = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    } else {
                        if (!isOnTheFly) {
                            return;
                        }
                        type2 = ProblemHighlightType.INFORMATION;
                    }
                    PsiLambdaExpression element = type2 == ProblemHighlightType.INFORMATION || InspectionProjectProfileManager.isInformationLevel((String)LambdaCanBeMethodReferenceInspection.this.getShortName(), (PsiElement)expression2) ? expression2 : candidate;
                    holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)element, LambdaCanBeMethodReferenceInspection.this.getDisplayName(), type2 != ProblemHighlightType.INFORMATION, type2, true, new LocalQuickFix[]{new ReplaceWithMethodRefFix(methodRefCandidate.mySafeQualifier ? "" : " (may change semantics)")}));
                }
            }
        };
        if (javaElementVisitor == null) {
            LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    @Nullable
    public static PsiExpression canBeMethodReferenceProblem(@Nullable PsiElement body2, PsiVariable[] parameters2, PsiType functionalInterfaceType, @Nullable PsiElement context) {
        MethodReferenceCandidate methodRefCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression(body2);
        if (methodRefCandidate == null || !methodRefCandidate.mySafeQualifier || !methodRefCandidate.myConformsCodeStyle) {
            return null;
        }
        return LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(parameters2, functionalInterfaceType, context, methodRefCandidate.myExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PsiExpression canBeMethodReferenceProblem(PsiVariable[] parameters2, PsiType functionalInterfaceType, @Nullable PsiElement context, PsiExpression methodRefCandidate) {
        PsiNewExpression newExpression;
        if (methodRefCandidate instanceof PsiNewExpression && ((newExpression = (PsiNewExpression)methodRefCandidate).getAnonymousClass() != null || newExpression.getArrayInitializer() != null)) {
            return null;
        }
        String methodReferenceText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText((PsiElement)methodRefCandidate, functionalInterfaceType, parameters2);
        if (methodReferenceText != null) {
            PsiMethodReferenceExpression methodReferenceExpression;
            LOG.assertTrue(methodRefCandidate != null);
            if (!(methodRefCandidate instanceof PsiCallExpression)) {
                return methodRefCandidate;
            }
            PsiCallExpression callExpression = (PsiCallExpression)methodRefCandidate;
            PsiMethod method = callExpression.resolveMethod();
            if (method != null) {
                if (!LambdaCanBeMethodReferenceInspection.isSimpleCall(parameters2, callExpression, method)) {
                    return null;
                }
            } else {
                LOG.assertTrue(callExpression instanceof PsiNewExpression);
                if (((PsiNewExpression)callExpression).getQualifier() != null) {
                    return null;
                }
                PsiExpression[] dims = ((PsiNewExpression)callExpression).getArrayDimensions();
                if (dims.length == 1 && parameters2.length == 1 ? !ExpressionUtils.isReferenceTo(dims[0], parameters2[0]) : dims.length > 0) {
                    return null;
                }
                if (callExpression.getTypeArguments().length > 0) {
                    return null;
                }
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)callExpression.getProject());
            try {
                methodReferenceExpression = (PsiMethodReferenceExpression)elementFactory.createExpressionFromText(methodReferenceText, (PsiElement)(context != null ? context : callExpression));
            }
            catch (IncorrectOperationException e) {
                LOG.error(callExpression.getText(), (Throwable)e);
                return null;
            }
            Map map2 = LambdaUtil.getFunctionalTypeMap();
            try {
                map2.put(methodReferenceExpression, functionalInterfaceType);
                JavaResolveResult result = methodReferenceExpression.advancedResolve(false);
                PsiElement element = result.getElement();
                if (element != null && result.isAccessible() && (!(result instanceof MethodCandidateInfo) || ((MethodCandidateInfo)result).isApplicable())) {
                    if (!(element instanceof PsiMethod)) {
                        PsiCallExpression psiCallExpression = callExpression;
                        return psiCallExpression;
                    }
                    PsiCallExpression psiCallExpression = method != null && MethodSignatureUtil.areSignaturesEqual((PsiMethod)((PsiMethod)element), (PsiMethod)method) ? callExpression : null;
                    return psiCallExpression;
                }
            }
            finally {
                map2.remove(methodReferenceExpression);
            }
        }
        return null;
    }

    private static boolean isSimpleCall(final PsiVariable[] parameters2, PsiCallExpression callExpression, PsiMethod psiMethod) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return false;
        }
        int calledParametersCount = psiMethod.getParameterList().getParametersCount();
        PsiExpression[] expressions2 = argumentList.getExpressions();
        Object qualifier = callExpression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)callExpression).getMethodExpression().getQualifierExpression() : (callExpression instanceof PsiNewExpression ? ((PsiNewExpression)callExpression).getQualifier() : null);
        if (expressions2.length == 0 && parameters2.length == 0) {
            return !(callExpression instanceof PsiNewExpression) || qualifier == null;
        }
        int offset = parameters2.length - calledParametersCount;
        if (expressions2.length > calledParametersCount || offset < 0) {
            return false;
        }
        for (int i = 0; i < expressions2.length; ++i) {
            if (ExpressionUtils.isReferenceTo(expressions2[i], parameters2[i + offset])) continue;
            return false;
        }
        if (offset == 0) {
            if (qualifier != null) {
                final boolean[] parameterUsed = new boolean[]{false};
                qualifier.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitElement(PsiElement element) {
                        if (parameterUsed[0]) {
                            return;
                        }
                        super.visitElement(element);
                    }

                    public void visitReferenceExpression(PsiReferenceExpression expression2) {
                        super.visitReferenceExpression(expression2);
                        parameterUsed[0] = parameterUsed[0] | ArrayUtil.find((Object[])parameters2, (Object)expression2.resolve()) >= 0;
                    }
                });
                return !parameterUsed[0];
            }
            return true;
        }
        return ExpressionUtils.isReferenceTo(qualifier, parameters2[0]);
    }

    @Nullable
    static MethodReferenceCandidate extractMethodReferenceCandidateExpression(PsiElement body2) {
        PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2));
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression2;
            if (newExpression.getQualifier() != null || newExpression.getAnonymousClass() != null || newExpression.getArrayInitializer() != null) {
                return null;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList != null) {
                for (PsiExpression arg : argumentList.getExpressions()) {
                    if (LambdaCanBeMethodReferenceInspection.isMethodReferenceArgCandidate(arg)) continue;
                    return null;
                }
            }
            return new MethodReferenceCandidate(expression2, true, true);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            for (PsiExpression arg : ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions()) {
                if (LambdaCanBeMethodReferenceInspection.isMethodReferenceArgCandidate(arg)) continue;
                return null;
            }
            return new MethodReferenceCandidate(expression2, LambdaCanBeMethodReferenceInspection.checkQualifier(((PsiMethodCallExpression)expression2).getMethodExpression().getQualifier()), true);
        }
        JavaCodeStyleSettings javaSettings = JavaCodeStyleSettings.getInstance(expression2.getContainingFile());
        if (expression2 instanceof PsiInstanceOfExpression) {
            if (!LambdaCanBeMethodReferenceInspection.isMethodReferenceArgCandidate(((PsiInstanceOfExpression)expression2).getOperand())) {
                return null;
            }
            return new MethodReferenceCandidate(expression2, true, javaSettings.REPLACE_INSTANCEOF);
        }
        if (expression2 instanceof PsiBinaryExpression) {
            PsiExpression comparedWithNull = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)expression2));
            if (LambdaCanBeMethodReferenceInspection.isMethodReferenceArgCandidate(comparedWithNull)) {
                return new MethodReferenceCandidate(expression2, true, javaSettings.REPLACE_NULL_CHECK);
            }
        } else if (expression2 instanceof PsiTypeCastExpression) {
            if (!LambdaCanBeMethodReferenceInspection.isMethodReferenceArgCandidate(((PsiTypeCastExpression)expression2).getOperand())) {
                return null;
            }
            PsiTypeElement typeElement = ((PsiTypeCastExpression)expression2).getCastType();
            if (typeElement != null) {
                PsiJavaCodeReferenceElement refs = typeElement.getInnermostComponentReferenceElement();
                if (refs != null && refs.getParameterList() != null && refs.getParameterList().getTypeParameterElements().length != 0) {
                    return null;
                }
                PsiType type2 = typeElement.getType();
                if (type2 instanceof PsiPrimitiveType || PsiUtil.resolveClassInType((PsiType)type2) instanceof PsiTypeParameter) {
                    return null;
                }
                return new MethodReferenceCandidate(expression2, true, javaSettings.REPLACE_CAST);
            }
        }
        return null;
    }

    private static boolean isMethodReferenceArgCandidate(PsiExpression arg) {
        return (arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)arg)) instanceof PsiReferenceExpression && ((PsiReferenceExpression)arg).getQualifier() == null;
    }

    public static void replaceAllLambdasWithMethodReferences(PsiElement root) {
        Collection lambdas = PsiTreeUtil.findChildrenOfType((PsiElement)root, PsiLambdaExpression.class);
        if (!lambdas.isEmpty()) {
            for (PsiLambdaExpression lambda2 : lambdas) {
                LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference(lambda2);
            }
        }
    }

    @NotNull
    public static PsiExpression replaceLambdaWithMethodReference(@NotNull PsiLambdaExpression lambda2) {
        MethodReferenceCandidate methodRefCandidate;
        if (lambda2 == null) {
            LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(5);
        }
        if ((methodRefCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression(lambda2.getBody())) == null || !methodRefCandidate.mySafeQualifier || !methodRefCandidate.myConformsCodeStyle) {
            PsiLambdaExpression psiLambdaExpression = lambda2;
            if (psiLambdaExpression == null) {
                LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(6);
            }
            return psiLambdaExpression;
        }
        PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiVariable[])lambda2.getParameterList().getParameters(), lambda2.getFunctionalInterfaceType(), (PsiElement)lambda2, methodRefCandidate.myExpression);
        PsiExpression psiExpression = LambdaCanBeMethodReferenceInspection.tryConvertToMethodReference(lambda2, (PsiElement)candidate);
        if (psiExpression == null) {
            LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(7);
        }
        return psiExpression;
    }

    public static boolean checkQualifier(@Nullable PsiElement qualifier) {
        if (qualifier == null) {
            return true;
        }
        Condition callExpressionCondition = Conditions.instanceOf((Class[])new Class[]{PsiCallExpression.class, PsiArrayAccessExpression.class});
        Condition nonFinalFieldRefCondition = expression2 -> {
            PsiElement element;
            return expression2 instanceof PsiReferenceExpression && !(expression2.getParent() instanceof PsiCallExpression) && (element = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiField && !((PsiField)element).hasModifierProperty("final");
        };
        return ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)qualifier)).filter(Conditions.or((Condition)callExpressionCondition, (Condition)nonFinalFieldRefCondition))).toList().isEmpty();
    }

    @Nullable
    private static PsiMethod getNonAmbiguousReceiver(PsiVariable[] parameters2, @NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(8);
        }
        String methodName = psiMethod.getName();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiMethod[] psiMethods = containingClass.findMethodsByName(methodName, false);
        if (psiMethods.length == 1) {
            return psiMethod;
        }
        PsiType receiverType2 = parameters2[0].getType();
        for (PsiMethod method : psiMethods) {
            if (!LambdaCanBeMethodReferenceInspection.isPairedNoReceiver(parameters2, receiverType2, method)) continue;
            PsiMethod[] deepestSuperMethods = psiMethod.findDeepestSuperMethods();
            if (deepestSuperMethods.length > 0) {
                for (PsiMethod superMethod : deepestSuperMethods) {
                    PsiMethod validSuperMethod = LambdaCanBeMethodReferenceInspection.getNonAmbiguousReceiver(parameters2, superMethod);
                    if (validSuperMethod == null) continue;
                    return validSuperMethod;
                }
            }
            return null;
        }
        return psiMethod;
    }

    private static boolean isPairedNoReceiver(PsiVariable[] parameters2, PsiType receiverType2, PsiMethod method) {
        PsiParameter[] nonReceiverCandidateParams = method.getParameterList().getParameters();
        return nonReceiverCandidateParams.length == parameters2.length && method.hasModifierProperty("static") && TypeConversionUtil.areTypesConvertible((PsiType)nonReceiverCandidateParams[0].getType(), (PsiType)receiverType2);
    }

    private static boolean isSoleParameter(@NotNull PsiVariable[] parameters2, @Nullable PsiExpression expression2) {
        if (parameters2 == null) {
            LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(9);
        }
        expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        return parameters2.length == 1 && expression2 instanceof PsiReferenceExpression && parameters2[0] == ((PsiReferenceExpression)expression2).resolve();
    }

    @Nullable
    static String createMethodReferenceText(PsiElement element, PsiType functionalInterfaceType, PsiVariable[] parameters2) {
        PsiTypeElement type2;
        PsiTypeCastExpression castExpression;
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
            JavaResolveResult result = methodCall.resolveMethodGenerics();
            PsiMethod psiMethod = (PsiMethod)result.getElement();
            if (psiMethod == null) {
                return null;
            }
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            String qualifierByMethodCall = LambdaCanBeMethodReferenceInspection.getQualifierTextByMethodCall(methodCall, functionalInterfaceType, parameters2, psiMethod, result.getSubstitutor());
            if (qualifierByMethodCall != null) {
                return qualifierByMethodCall + "::" + ((PsiMethodCallExpression)element).getTypeArgumentList().getText() + methodExpression.getReferenceName();
            }
        } else if (element instanceof PsiNewExpression) {
            String qualifierByNew = LambdaCanBeMethodReferenceInspection.getQualifierTextByNewExpression((PsiNewExpression)element);
            if (qualifierByNew != null) {
                return qualifierByNew + ((PsiNewExpression)element).getTypeArgumentList().getText() + "::new";
            }
        } else if (element instanceof PsiInstanceOfExpression) {
            PsiTypeElement type3;
            if (LambdaCanBeMethodReferenceInspection.isSoleParameter(parameters2, ((PsiInstanceOfExpression)element).getOperand()) && (type3 = ((PsiInstanceOfExpression)element).getCheckType()) != null) {
                return type3.getText() + ".class::isInstance";
            }
        } else if (element instanceof PsiBinaryExpression) {
            PsiBinaryExpression nullCheck = (PsiBinaryExpression)element;
            PsiExpression operand2 = ExpressionUtils.getValueComparedWithNull(nullCheck);
            if (operand2 != null && LambdaCanBeMethodReferenceInspection.isSoleParameter(parameters2, operand2)) {
                IElementType tokenType = nullCheck.getOperationTokenType();
                if (JavaTokenType.EQEQ.equals(tokenType)) {
                    return "java.util.Objects::isNull";
                }
                if (JavaTokenType.NE.equals(tokenType)) {
                    return "java.util.Objects::nonNull";
                }
            }
        } else if (element instanceof PsiTypeCastExpression && LambdaCanBeMethodReferenceInspection.isSoleParameter(parameters2, (castExpression = (PsiTypeCastExpression)element).getOperand()) && (type2 = castExpression.getCastType()) != null) {
            return type2.getText() + ".class::cast";
        }
        return null;
    }

    private static String getQualifierTextByNewExpression(PsiNewExpression element) {
        PsiType deepComponentType;
        JavaResolveResult resolve;
        PsiElement resolveElement;
        PsiType newExprType = element.getType();
        if (newExprType == null) {
            return null;
        }
        PsiClass containingClass = null;
        PsiJavaCodeReferenceElement classReference2 = element.getClassOrAnonymousClassReference();
        if (classReference2 != null && (resolveElement = (resolve = classReference2.advancedResolve(false)).getElement()) instanceof PsiClass) {
            containingClass = (PsiClass)resolveElement;
        }
        String classOrPrimitiveName = null;
        if (containingClass != null) {
            classOrPrimitiveName = LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        } else if (newExprType instanceof PsiArrayType && (deepComponentType = newExprType.getDeepComponentType()) instanceof PsiPrimitiveType) {
            classOrPrimitiveName = deepComponentType.getCanonicalText();
        }
        if (classOrPrimitiveName == null) {
            return null;
        }
        int dim = newExprType.getArrayDimensions();
        while (dim-- > 0) {
            classOrPrimitiveName = classOrPrimitiveName + "[]";
        }
        return classOrPrimitiveName;
    }

    @Nullable
    private static String getQualifierTextByMethodCall(PsiMethodCallExpression methodCall, PsiType functionalInterfaceType, PsiVariable[] parameters2, PsiMethod psiMethod, PsiSubstitutor substitutor) {
        PsiExpression qualifierExpression2 = methodCall.getMethodExpression().getQualifierExpression();
        PsiClass containingClass = psiMethod.getContainingClass();
        LOG.assertTrue(containingClass != null);
        if (qualifierExpression2 != null) {
            boolean isReceiverType = false;
            if (qualifierExpression2 instanceof PsiReferenceExpression && ArrayUtil.find((Object[])parameters2, (Object)((PsiReferenceExpression)qualifierExpression2).resolve()) > -1) {
                isReceiverType = PsiMethodReferenceUtil.isReceiverType((PsiType)PsiMethodReferenceUtil.getFirstParameterType((PsiType)functionalInterfaceType, (PsiElement)qualifierExpression2), (PsiClass)containingClass, (PsiSubstitutor)substitutor);
            }
            return isReceiverType ? LambdaCanBeMethodReferenceInspection.composeReceiverQualifierText(parameters2, psiMethod, containingClass, qualifierExpression2) : qualifierExpression2.getText();
        }
        if (psiMethod.hasModifierProperty("static")) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        }
        PsiClass parentContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiClass.class);
        if (parentContainingClass instanceof PsiAnonymousClass) {
            parentContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parentContainingClass, PsiClass.class, (boolean)true);
        }
        PsiClass treeContainingClass = parentContainingClass;
        while (treeContainingClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)treeContainingClass, (PsiClass)containingClass, (boolean)true)) {
            treeContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)treeContainingClass, PsiClass.class, (boolean)true);
        }
        if (treeContainingClass != null && containingClass != parentContainingClass && treeContainingClass != parentContainingClass) {
            String treeContainingClassName = treeContainingClass.getName();
            if (treeContainingClassName == null) {
                return null;
            }
            return treeContainingClassName + ".this";
        }
        return "this";
    }

    @Nullable
    private static String composeReceiverQualifierText(PsiVariable[] parameters2, PsiMethod psiMethod, PsiClass containingClass, @NotNull PsiExpression qualifierExpression2) {
        if (qualifierExpression2 == null) {
            LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(10);
        }
        if (psiMethod.hasModifierProperty("static")) {
            return null;
        }
        PsiMethod nonAmbiguousMethod = LambdaCanBeMethodReferenceInspection.getNonAmbiguousReceiver(parameters2, psiMethod);
        if (nonAmbiguousMethod == null) {
            return null;
        }
        PsiClass nonAmbiguousContainingClass = nonAmbiguousMethod.getContainingClass();
        if (!containingClass.equals(nonAmbiguousContainingClass)) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(nonAmbiguousContainingClass);
        }
        if (containingClass.isPhysical() && qualifierExpression2 instanceof PsiReferenceExpression && !PsiTypesUtil.isGetClass((PsiMethod)psiMethod) && ArrayUtil.find((Object[])parameters2, (Object)((PsiReferenceExpression)qualifierExpression2).resolve()) > -1) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        }
        PsiType qualifierExpressionType = qualifierExpression2.getType();
        if (qualifierExpressionType != null && !FunctionalInterfaceParameterizationUtil.isWildcardParameterized(qualifierExpressionType)) {
            try {
                String canonicalText = qualifierExpressionType.getCanonicalText();
                JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createExpressionFromText(canonicalText + "::foo", (PsiElement)qualifierExpression2);
                return canonicalText;
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
    }

    private static String getClassReferenceName(PsiClass containingClass) {
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName != null) {
            return qualifiedName;
        }
        return containingClass.getName();
    }

    @NotNull
    static PsiExpression tryConvertToMethodReference(@NotNull PsiLambdaExpression lambda2, PsiElement body2) {
        if (lambda2 == null) {
            LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(11);
        }
        Project project = lambda2.getProject();
        PsiType functionalInterfaceType = lambda2.getFunctionalInterfaceType();
        if (functionalInterfaceType == null || !functionalInterfaceType.isValid()) {
            PsiLambdaExpression psiLambdaExpression = lambda2;
            if (psiLambdaExpression == null) {
                LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(12);
            }
            return psiLambdaExpression;
        }
        PsiType denotableFunctionalInterfaceType = RefactoringChangeUtil.getTypeByExpression((PsiExpression)lambda2);
        if (denotableFunctionalInterfaceType == null) {
            PsiLambdaExpression psiLambdaExpression = lambda2;
            if (psiLambdaExpression == null) {
                LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(13);
            }
            return psiLambdaExpression;
        }
        List comments = ContainerUtil.map((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)lambda2, PsiComment.class), comment -> (PsiComment)comment.copy());
        String methodRefText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText(body2, functionalInterfaceType, (PsiVariable[])lambda2.getParameterList().getParameters());
        if (methodRefText != null) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression psiExpression = factory.createExpressionFromText(methodRefText, (PsiElement)lambda2);
            SmartTypePointer typePointer = SmartTypePointerManager.getInstance((Project)project).createSmartTypePointer(denotableFunctionalInterfaceType);
            PsiExpression replace = (PsiExpression)lambda2.replace((PsiElement)psiExpression);
            PsiType functionalTypeAfterReplacement = GenericsUtil.getVariableTypeByExpressionType((PsiType)((PsiMethodReferenceExpression)replace).getFunctionalInterfaceType());
            functionalInterfaceType = typePointer.getType();
            if (!(functionalInterfaceType == null || functionalTypeAfterReplacement != null && functionalTypeAfterReplacement.equals(functionalInterfaceType))) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)factory.createExpressionFromText("(A)a", (PsiElement)replace);
                PsiTypeElement castType = cast.getCastType();
                LOG.assertTrue(castType != null);
                castType.replace((PsiElement)factory.createTypeElement(functionalInterfaceType));
                PsiExpression castOperand = cast.getOperand();
                LOG.assertTrue(castOperand != null);
                castOperand.replace((PsiElement)replace);
                replace = (PsiExpression)replace.replace((PsiElement)cast);
            }
            AnonymousCanBeLambdaInspection.restoreComments(comments, (PsiElement)replace);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replace);
            PsiExpression psiExpression2 = replace;
            if (psiExpression2 == null) {
                LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(14);
            }
            return psiExpression2;
        }
        PsiLambdaExpression psiLambdaExpression = lambda2;
        if (psiLambdaExpression == null) {
            LambdaCanBeMethodReferenceInspection.$$$reportNull$$$0(15);
        }
        return psiLambdaExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceLambdaWithMethodReference";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "tryConvertToMethodReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceLambdaWithMethodReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNonAmbiguousReceiver";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSoleParameter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "composeReceiverQualifierText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryConvertToMethodReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MethodReferenceCandidate {
        final PsiExpression myExpression;
        final boolean mySafeQualifier;
        final boolean myConformsCodeStyle;

        MethodReferenceCandidate(PsiExpression expression2, boolean safeQualifier, boolean conformsCodeStyle) {
            this.myExpression = expression2;
            this.mySafeQualifier = safeQualifier;
            this.myConformsCodeStyle = conformsCodeStyle;
        }
    }

    private static class ReplaceWithMethodRefFix
    implements LocalQuickFix {
        private final String mySuffix;

        ReplaceWithMethodRefFix(String suffix) {
            this.mySuffix = suffix;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName() + this.mySuffix;
            if (string == null) {
                ReplaceWithMethodRefFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace lambda with method reference" == null) {
                ReplaceWithMethodRefFix.$$$reportNull$$$0(1);
            }
            return "Replace lambda with method reference";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiLambdaExpression lambdaExpression;
            PsiElement element;
            if (project == null) {
                ReplaceWithMethodRefFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ReplaceWithMethodRefFix.$$$reportNull$$$0(3);
            }
            if ((element = descriptor.getPsiElement()) instanceof PsiLambdaExpression) {
                element = LambdaUtil.extractSingleExpressionFromBody((PsiElement)((PsiLambdaExpression)element).getBody());
            }
            if ((lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class)) == null) {
                return;
            }
            LambdaCanBeMethodReferenceInspection.tryConvertToMethodReference(lambdaExpression, element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

