/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObviousNullCheckInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ObviousNullCheckInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                Object[] args = call.getArgumentList().getExpressions();
                if (!ContainerUtil.exists((Object[])args, arg -> ObviousNullCheckInspection.getObviouslyNonNullExplanation(PsiUtil.skipParenthesizedExprDown((PsiExpression)arg)) != null)) {
                    return;
                }
                NullCheckParameter nullCheckParameter = NullCheckParameter.fromCall(call);
                if (nullCheckParameter == null) {
                    return;
                }
                if (!ExpressionUtils.isVoidContext((PsiExpression)call) && !nullCheckParameter.myReturnsParameter) {
                    return;
                }
                if (args.length <= nullCheckParameter.myIndex) {
                    return;
                }
                PsiExpression nullArg = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[nullCheckParameter.myIndex]);
                String explanation = ObviousNullCheckInspection.getObviouslyNonNullExplanation(nullArg);
                if (explanation == null) {
                    return;
                }
                if (nullCheckParameter.myNull) {
                    holder.registerProblem((PsiElement)nullArg, InspectionsBundle.message((String)"inspection.redundant.null.check.always.fail.message", (Object[])new Object[]{explanation}), new LocalQuickFix[0]);
                } else {
                    PsiReferenceExpression comparedToNull = ExpressionUtils.getReferenceExpressionFromNullComparison(nullArg, false);
                    Object fix2 = comparedToNull == null ? new RemoveNullCheckFix() : new RemoveExcessiveNullComparisonFix();
                    holder.registerProblem((PsiElement)nullArg, InspectionsBundle.message((String)"inspection.redundant.null.check.message", (Object[])new Object[]{explanation}), new LocalQuickFix[]{fix2});
                }
            }
        };
        if (javaElementVisitor == null) {
            ObviousNullCheckInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @Nullable
    private static String getObviouslyNonNullExplanation(PsiExpression arg) {
        if (arg == null || ExpressionUtils.isNullLiteral(arg)) {
            return null;
        }
        if (arg instanceof PsiNewExpression) {
            return "newly created object";
        }
        if (arg instanceof PsiLiteralExpression) {
            return "literal";
        }
        if (arg.getType() instanceof PsiPrimitiveType) {
            return "a value of primitive type '" + arg.getType().getCanonicalText() + "'";
        }
        if (arg instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)arg).getOperationTokenType() == JavaTokenType.PLUS) {
            return "concatenation";
        }
        if (arg instanceof PsiThisExpression) {
            return "'this' object";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ObviousNullCheckInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ObviousNullCheckInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RemoveNullCheckFix
    implements LocalQuickFix {
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.null.check.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveNullCheckFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement startElement;
            PsiMethodCallExpression call;
            if (project == null) {
                RemoveNullCheckFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveNullCheckFix.$$$reportNull$$$0(2);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)(startElement = descriptor.getStartElement()), PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiElement parent = call.getParent();
            CommentTracker ct = new CommentTracker();
            if (parent instanceof PsiExpressionStatement) {
                List expressions2 = ((StreamEx)StreamEx.of((Object[])call.getArgumentList().getExpressions()).flatCollection(SideEffectChecker::extractSideEffectExpressions).peek(ct::markUnchanged)).toList();
                PsiStatement[] sideEffectStatements = StatementExtractor.generateStatements(expressions2, (PsiExpression)call);
                if (sideEffectStatements.length > 0) {
                    BlockUtils.addBefore((PsiStatement)parent, sideEffectStatements);
                }
                ct.deleteAndRestoreComments(parent);
            } else {
                ct.replaceAndRestoreComments((PsiElement)call, startElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ObviousNullCheckInspection$RemoveNullCheckFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ObviousNullCheckInspection$RemoveNullCheckFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RemoveExcessiveNullComparisonFix
    implements LocalQuickFix {
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.null.check.fix.notnull.family.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveExcessiveNullComparisonFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression arg;
            if (project == null) {
                RemoveExcessiveNullComparisonFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveExcessiveNullComparisonFix.$$$reportNull$$$0(2);
            }
            if ((arg = (PsiExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiExpression.class)) == null) {
                return;
            }
            PsiReferenceExpression comparedToNull = ExpressionUtils.getReferenceExpressionFromNullComparison(arg, false);
            if (comparedToNull == null) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)arg, (PsiElement)comparedToNull);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ObviousNullCheckInspection$RemoveExcessiveNullComparisonFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ObviousNullCheckInspection$RemoveExcessiveNullComparisonFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class NullCheckParameter {
        int myIndex;
        boolean myNull;
        boolean myReturnsParameter;

        NullCheckParameter(int index, boolean aNull, boolean returnsParameter) {
            this.myIndex = index;
            this.myNull = aNull;
            this.myReturnsParameter = returnsParameter;
        }

        @Nullable
        static NullCheckParameter fromCall(PsiMethodCallExpression call) {
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return null;
            }
            if (!JavaMethodContractUtil.isPure(method)) {
                return null;
            }
            List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(method, (PsiCallExpression)call);
            if (contracts2.isEmpty() || contracts2.size() > 2) {
                return null;
            }
            MethodContract contract = contracts2.get(0);
            if (contract == null || !contract.getReturnValue().isFail()) {
                return null;
            }
            ContractValue condition2 = (ContractValue)ContainerUtil.getOnlyItem(contract.getConditions());
            if (condition2 == null) {
                return null;
            }
            boolean isNull = false;
            int nullIndex = condition2.getNullCheckedArgument(true).orElse(-1);
            if (nullIndex == -1) {
                isNull = true;
                nullIndex = condition2.getNullCheckedArgument(false).orElse(-1);
                if (nullIndex == -1) {
                    return null;
                }
            }
            boolean returnsParameter = false;
            if (contracts2.size() == 2) {
                ContractReturnValue returnValue = JavaMethodContractUtil.getNonFailingReturnValue(contracts2);
                if (returnValue instanceof ContractReturnValue.ParameterReturnValue && ((ContractReturnValue.ParameterReturnValue)returnValue).getParameterNumber() == nullIndex) {
                    returnsParameter = true;
                } else {
                    return null;
                }
            }
            return new NullCheckParameter(nullIndex, isNull, returnsParameter);
        }
    }
}

