/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.Iterator;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantExplicitCloseInspection
extends AbstractBaseJavaLocalInspectionTool {
    CallMatcher CLOSE = CallMatcher.instanceCall("java.lang.AutoCloseable", "close").parameterCount(0);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantExplicitCloseInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitTryStatement(PsiTryStatement statement) {
                PsiResourceList resourceList = statement.getResourceList();
                if (resourceList == null) {
                    return;
                }
                PsiCodeBlock tryBlock = statement.getTryBlock();
                if (tryBlock == null) {
                    return;
                }
                PsiStatement last = (PsiStatement)ArrayUtil.getLastElement((Object[])tryBlock.getStatements());
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)last, PsiExpressionStatement.class);
                if (expressionStatement == null) {
                    return;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiMethodCallExpression.class);
                if (!RedundantExplicitCloseInspection.this.CLOSE.test(call)) {
                    return;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                PsiReferenceExpression reference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier), PsiReferenceExpression.class);
                if (reference == null) {
                    return;
                }
                PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiVariable.class);
                if (variable == null) {
                    return;
                }
                boolean isReferenceToResourceVariable = StreamEx.of((Iterator)resourceList.iterator()).anyMatch(element -> variable == element || element instanceof PsiResourceExpression && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)reference, ((PsiResourceExpression)element).getExpression()));
                if (!isReferenceToResourceVariable) {
                    return;
                }
                holder.registerProblem((PsiElement)last, InspectionsBundle.message((String)"inspection.redundant.explicit.close", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new DeleteRedundantCloseFix()});
            }
        };
        if (javaElementVisitor == null) {
            RedundantExplicitCloseInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantExplicitCloseInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantExplicitCloseInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DeleteRedundantCloseFix
    implements LocalQuickFix {
        private DeleteRedundantCloseFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.remove.redundant", (Object[])new Object[]{"close()"});
            if (string == null) {
                DeleteRedundantCloseFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                DeleteRedundantCloseFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                DeleteRedundantCloseFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getStartElement();
            new CommentTracker().deleteAndRestoreComments(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantExplicitCloseInspection$DeleteRedundantCloseFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantExplicitCloseInspection$DeleteRedundantCloseFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

