/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.FunctionalExpressionUtils;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyCollectorInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SimplifyCollectorInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SimplifyCollectorInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                super.visitMethodCallExpression(call);
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (nameElement == null || !SimplifyCollectorInspection.isCollectorMethod(call, new String[]{"groupingBy", "groupingByConcurrent"})) {
                    return;
                }
                Object[] args = call.getArgumentList().getExpressions();
                if (args.length != 2 && args.length != 3) {
                    return;
                }
                CombinedCollector combinedCollector = new CombinedCollector((PsiExpression)ArrayUtil.getLastElement((Object[])args), null, null);
                combinedCollector = combinedCollector.tryUnwrap().tryUnwrap();
                PsiMethodCallExpression downstream = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)combinedCollector.myDownstream, PsiMethodCallExpression.class);
                if (downstream == null || !FunctionalExpressionUtils.isFunctionalReferenceTo(combinedCollector.myFinisher, "java.util.Optional", null, "get", new PsiType[0])) {
                    return;
                }
                if (SimplifyCollectorInspection.isCollectorMethod(downstream, new String[]{"maxBy", "minBy", "reducing"}) && downstream.getArgumentList().getExpressionCount() == 1) {
                    String replacement = nameElement.getText().equals("groupingBy") ? "toMap" : "toConcurrentMap";
                    holder.registerProblem(nameElement, InspectionsBundle.message((String)"inspection.simplify.collector.message", (Object[])new Object[]{replacement}), new LocalQuickFix[]{new SimplifyCollectorFix(replacement)});
                }
            }
        };
        if (javaElementVisitor == null) {
            SimplifyCollectorInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    @Contract(value="null, _ -> false")
    private static boolean isCollectorMethod(PsiMethodCallExpression call, String ... methodNames) {
        PsiMethod method;
        if (call == null) {
            return false;
        }
        String name = call.getMethodExpression().getReferenceName();
        if (ArrayUtil.contains((String)name, (String[])methodNames) && (method = call.resolveMethod()) != null && method.hasModifierProperty("static")) {
            PsiClass aClass = method.getContainingClass();
            return aClass != null && "java.util.stream.Collectors".equals(aClass.getQualifiedName()) && method.getParameterList().getParametersCount() == call.getArgumentList().getExpressionCount();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SimplifyCollectorInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SimplifyCollectorInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SimplifyCollectorFix
    implements LocalQuickFix {
        private final String myMethodName;

        SimplifyCollectorFix(String methodName) {
            this.myMethodName = methodName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.simplify.collector.fix.name", (Object[])new Object[]{this.myMethodName});
            if (string == null) {
                SimplifyCollectorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.simplify.collector.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                SimplifyCollectorFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String merger;
            PsiMethodCallExpression call;
            if (project == null) {
                SimplifyCollectorFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                SimplifyCollectorFix.$$$reportNull$$$0(3);
            }
            if (!SimplifyCollectorInspection.isCollectorMethod(call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class), new String[]{"groupingBy", "groupingByConcurrent"})) {
                return;
            }
            Object[] args = call.getArgumentList().getExpressions();
            if (args.length != 2 && args.length != 3) {
                return;
            }
            CombinedCollector combinedCollector = new CombinedCollector((PsiExpression)ArrayUtil.getLastElement((Object[])args), null, null);
            combinedCollector = combinedCollector.tryUnwrap().tryUnwrap();
            PsiMethodCallExpression downstream = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)combinedCollector.myDownstream, PsiMethodCallExpression.class);
            if (downstream == null || !FunctionalExpressionUtils.isFunctionalReferenceTo(combinedCollector.myFinisher, "java.util.Optional", null, "get", new PsiType[0])) {
                return;
            }
            PsiExpression[] downstreamArgs = downstream.getArgumentList().getExpressions();
            if (downstreamArgs.length != 1) {
                return;
            }
            PsiExpression downstreamArg = downstreamArgs[0];
            String downstreamName = downstream.getMethodExpression().getReferenceName();
            if (downstreamName == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiType collectorType = call.getType();
            PsiType mapType = PsiUtil.substituteTypeParameter((PsiType)collectorType, (String)"java.util.stream.Collector", (int)2, (boolean)false);
            PsiType valueType = PsiUtil.substituteTypeParameter((PsiType)mapType, (String)"java.util.Map", (int)1, (boolean)false);
            String valueTypeArg = valueType == null ? "" : "<" + valueType.getCanonicalText() + ">";
            switch (downstreamName) {
                case "minBy": 
                case "maxBy": {
                    merger = "java.util.function.BinaryOperator." + valueTypeArg + downstreamName + "(" + ct.text((PsiElement)downstreamArg) + ")";
                    break;
                }
                case "reducing": {
                    merger = ct.text((PsiElement)downstreamArg);
                    break;
                }
                default: {
                    return;
                }
            }
            String keyMapper = ct.text((PsiElement)args[0]);
            String mapSupplier = args.length == 3 ? ct.text((PsiElement)args[1]) : null;
            String valueMapper = combinedCollector.myMapper == null ? "java.util.function.Function." + valueTypeArg + "identity()" : ct.text((PsiElement)combinedCollector.myMapper);
            String replacement = StreamEx.of((Object[])new String[]{keyMapper, valueMapper, merger, mapSupplier}).nonNull().joining((CharSequence)",", (CharSequence)("java.util.stream.Collectors." + this.myMethodName + "("), (CharSequence)")");
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)call, replacement);
            PsiDiamondTypeUtil.removeRedundantTypeArguments(result);
            result = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SimplifyCollectorInspection$SimplifyCollectorFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SimplifyCollectorInspection$SimplifyCollectorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CombinedCollector {
        final PsiExpression myDownstream;
        @Nullable
        final PsiExpression myFinisher;
        @Nullable
        final PsiExpression myMapper;

        CombinedCollector(PsiExpression downstream, @Nullable PsiExpression finisher, @Nullable PsiExpression mapper) {
            this.myDownstream = PsiUtil.skipParenthesizedExprDown((PsiExpression)downstream);
            this.myFinisher = PsiUtil.skipParenthesizedExprDown((PsiExpression)finisher);
            this.myMapper = PsiUtil.skipParenthesizedExprDown((PsiExpression)mapper);
        }

        CombinedCollector tryUnwrap() {
            if (this.myDownstream instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)this.myDownstream;
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (this.myFinisher == null && SimplifyCollectorInspection.isCollectorMethod(call, new String[]{"collectingAndThen"})) {
                    return new CombinedCollector(args[0], args[1], this.myMapper);
                }
                if (this.myMapper == null && SimplifyCollectorInspection.isCollectorMethod(call, new String[]{"mapping"})) {
                    return new CombinedCollector(args[1], this.myFinisher, args[0]);
                }
            }
            return this;
        }
    }
}

