/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.blockingCallsDetection;

import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ThrowsTypeBlockingMethodChecker
implements BlockingMethodChecker {
    private static final Set<String> BLOCKING_EXCEPTION_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"java.lang.InterruptedException", "java.io.IOException"});

    public boolean isApplicable(@NotNull PsiFile file) {
        if (file == null) {
            ThrowsTypeBlockingMethodChecker.$$$reportNull$$$0(0);
        }
        return true;
    }

    public boolean isMethodBlocking(@NotNull PsiMethod method) {
        if (method == null) {
            ThrowsTypeBlockingMethodChecker.$$$reportNull$$$0(1);
        }
        return Arrays.stream(method.getThrowsList().getReferenceElements()).anyMatch(thrownException -> BLOCKING_EXCEPTION_TYPES.contains(thrownException.getQualifiedName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/blockingCallsDetection/ThrowsTypeBlockingMethodChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodBlocking";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

