/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaFactMap {
    public static final DfaFactMap EMPTY = new DfaFactMap(KeyFMap.EMPTY_MAP);
    @NotNull
    private final KeyFMap myMap;

    private DfaFactMap(@NotNull KeyFMap map2) {
        if (map2 == null) {
            DfaFactMap.$$$reportNull$$$0(0);
        }
        this.myMap = map2;
    }

    @Nullable
    public <T> T get(@NotNull DfaFactType<T> type2) {
        if (type2 == null) {
            DfaFactMap.$$$reportNull$$$0(1);
        }
        return (T)this.myMap.get(type2);
    }

    @NotNull
    public <T> DfaFactMap with(@NotNull DfaFactType<T> type2, @Nullable T value2) {
        if (type2 == null) {
            DfaFactMap.$$$reportNull$$$0(2);
        }
        KeyFMap newMap = value2 == null || type2.isUnknown(value2) ? this.myMap.minus(type2) : this.myMap.plus(type2, value2);
        DfaFactMap dfaFactMap = newMap == this.myMap ? this : new DfaFactMap(newMap);
        if (dfaFactMap == null) {
            DfaFactMap.$$$reportNull$$$0(3);
        }
        return dfaFactMap;
    }

    public boolean isSuperStateOf(DfaFactMap subMap) {
        for (DfaFactType<?> key2 : DfaFactType.getTypes()) {
            Object other;
            Object thisValue;
            DfaFactType<?> type2 = key2;
            if (type2.isSuper(thisValue = this.myMap.get(type2), other = subMap.get(type2))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public <T> DfaFactMap intersect(@NotNull DfaFactType<T> type2, @Nullable T value2) {
        if (type2 == null) {
            DfaFactMap.$$$reportNull$$$0(4);
        }
        if (value2 == null || type2.isUnknown(value2)) {
            return this;
        }
        T curFact = this.get(type2);
        if (curFact == null) {
            return this.with(type2, value2);
        }
        T newFact = type2.intersectFacts(curFact, value2);
        return newFact == null ? null : this.with(type2, newFact);
    }

    private <TT> DfaFactMap intersect(@NotNull DfaFactMap otherMap, @NotNull DfaFactType<TT> type2) {
        if (otherMap == null) {
            DfaFactMap.$$$reportNull$$$0(5);
        }
        if (type2 == null) {
            DfaFactMap.$$$reportNull$$$0(6);
        }
        return this.intersect(type2, otherMap.get(type2));
    }

    @Nullable
    public DfaFactMap intersect(@NotNull DfaFactMap other) {
        if (other == null) {
            DfaFactMap.$$$reportNull$$$0(7);
        }
        DfaFactMap result = this;
        List<DfaFactType<?>> types = DfaFactType.getTypes();
        for (DfaFactType<?> type2 : types) {
            if ((result = result.intersect(other, type2)) != null) continue;
            return null;
        }
        return result;
    }

    @NotNull
    public <T> DfaFactMap unite(@NotNull DfaFactType<T> type2, @Nullable T value2) {
        if (type2 == null) {
            DfaFactMap.$$$reportNull$$$0(8);
        }
        if (value2 == null) {
            DfaFactMap dfaFactMap = this.with(type2, null);
            if (dfaFactMap == null) {
                DfaFactMap.$$$reportNull$$$0(9);
            }
            return dfaFactMap;
        }
        T curFact = this.get(type2);
        if (curFact == null) {
            DfaFactMap dfaFactMap = this;
            if (dfaFactMap == null) {
                DfaFactMap.$$$reportNull$$$0(10);
            }
            return dfaFactMap;
        }
        T newFact = type2.uniteFacts(curFact, value2);
        DfaFactMap dfaFactMap = this.with(type2, newFact);
        if (dfaFactMap == null) {
            DfaFactMap.$$$reportNull$$$0(11);
        }
        return dfaFactMap;
    }

    @NotNull
    private <TT> DfaFactMap unite(DfaFactMap otherMap, @NotNull DfaFactType<TT> type2) {
        if (type2 == null) {
            DfaFactMap.$$$reportNull$$$0(12);
        }
        DfaFactMap dfaFactMap = this.unite(type2, otherMap.get(type2));
        if (dfaFactMap == null) {
            DfaFactMap.$$$reportNull$$$0(13);
        }
        return dfaFactMap;
    }

    @NotNull
    public DfaFactMap unite(@NotNull DfaFactMap other) {
        if (other == null) {
            DfaFactMap.$$$reportNull$$$0(14);
        }
        DfaFactMap dfaFactMap = (DfaFactMap)StreamEx.of(DfaFactType.getTypes()).foldLeft((Object)this, (map2, type2) -> {
            if (other == null) {
                DfaFactMap.$$$reportNull$$$0(19);
            }
            return map2.unite(other, (DfaFactType)((Object)type2));
        });
        if (dfaFactMap == null) {
            DfaFactMap.$$$reportNull$$$0(15);
        }
        return dfaFactMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof DfaFactMap && this.myMap.equals(((DfaFactMap)o).myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    public String toString() {
        return this.facts(DfaFactType::toString).joining((CharSequence)", ");
    }

    public <R> StreamEx<R> facts(FactMapper<? extends R> mapper) {
        return StreamEx.of((Object[])this.myMap.getKeys()).map(f -> {
            DfaFactType key2 = (DfaFactType)((Object)f);
            Object value2 = this.myMap.get(f);
            return mapper.apply(key2, value2);
        });
    }

    public static DfaFactMap calcFromVariable(@NotNull DfaVariableValue value2) {
        if (value2 == null) {
            DfaFactMap.$$$reportNull$$$0(16);
        }
        return (DfaFactMap)StreamEx.of(DfaFactType.getTypes()).foldLeft((Object)EMPTY, (factMap, type2) -> {
            if (value2 == null) {
                DfaFactMap.$$$reportNull$$$0(18);
            }
            return DfaFactMap.updateMap(factMap, type2, value2);
        });
    }

    private static <T> DfaFactMap updateMap(DfaFactMap map2, DfaFactType<T> factType, DfaVariableValue value2) {
        return map2.with(factType, factType.calcFromVariable(value2));
    }

    @NotNull
    public static DfaFactMap fromDfaValue(DfaValue value2) {
        DfaFactMap dfaFactMap = (DfaFactMap)StreamEx.of(DfaFactType.getTypes()).foldLeft((Object)EMPTY, (map2, type2) -> DfaFactMap.updateMap(map2, type2, value2));
        if (dfaFactMap == null) {
            DfaFactMap.$$$reportNull$$$0(17);
        }
        return dfaFactMap;
    }

    private static <T> DfaFactMap updateMap(DfaFactMap map2, DfaFactType<T> factType, DfaValue value2) {
        return map2.with(factType, factType.fromDfaValue(value2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaFactMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherMap";
                break;
            }
            case 7: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaFactMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "with";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unite";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDfaValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "with";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 8: 
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unite";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calcFromVariable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calcFromVariable$2";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$unite$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface FactMapper<R> {
        public <T> R apply(DfaFactType<T> var1, T var2);
    }
}

