/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaBoxedValue
extends DfaValue {
    private final DfaValue myWrappedValue;
    @Nullable
    private final PsiType myType;

    private DfaBoxedValue(DfaValue valueToWrap, DfaValueFactory factory, @Nullable PsiType type2) {
        super(factory);
        this.myWrappedValue = valueToWrap;
        this.myType = type2;
    }

    @NonNls
    public String toString() {
        return "Boxed " + this.myWrappedValue.toString();
    }

    public DfaValue getWrappedValue() {
        return this.myWrappedValue;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.myType;
    }

    public static class Factory {
        private final Map<Object, DfaBoxedValue> cachedValues = new HashMap<Object, DfaBoxedValue>();
        private final DfaValueFactory myFactory;

        public Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        public DfaValue getBoxedIfExists(DfaVariableValue variable) {
            return this.cachedValues.get(variable);
        }

        @Nullable
        public DfaValue createBoxed(DfaValue valueToWrap, @Nullable PsiType type2) {
            Object o;
            if (valueToWrap instanceof DfaVariableValue && ((DfaVariableValue)valueToWrap).getSource() == SpecialField.UNBOX) {
                return ((DfaVariableValue)valueToWrap).getQualifier();
            }
            Object object = valueToWrap instanceof DfaConstValue ? ((DfaConstValue)valueToWrap).getValue() : (o = valueToWrap instanceof DfaVariableValue ? valueToWrap : null);
            if (o == null) {
                return null;
            }
            DfaBoxedValue boxedValue = this.cachedValues.get(o);
            if (boxedValue == null) {
                boxedValue = new DfaBoxedValue(valueToWrap, this.myFactory, type2);
                this.cachedValues.put(o, boxedValue);
            }
            return boxedValue;
        }

        @NotNull
        public DfaValue createUnboxed(DfaValue value2, PsiPrimitiveType targetType) {
            if (value2 instanceof DfaBoxedValue) {
                DfaValue dfaValue = ((DfaBoxedValue)value2).getWrappedValue();
                if (dfaValue == null) {
                    Factory.$$$reportNull$$$0(0);
                }
                return dfaValue;
            }
            if (value2 instanceof DfaConstValue) {
                DfaValue dfaValue = TypeConversionUtil.isPrimitiveAndNotNull((PsiType)((DfaConstValue)value2).getType()) ? value2 : DfaUnknownValue.getInstance();
                if (dfaValue == null) {
                    Factory.$$$reportNull$$$0(1);
                }
                return dfaValue;
            }
            if (value2 instanceof DfaVariableValue) {
                DfaValue dfaValue = SpecialField.UNBOX.createValue(this.myFactory, value2, (PsiType)targetType);
                if (dfaValue == null) {
                    Factory.$$$reportNull$$$0(2);
                }
                return dfaValue;
            }
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return dfaUnknownValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaBoxedValue$Factory", "createUnboxed"));
        }
    }
}

