/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiReferenceProcessor;
import com.intellij.psi.search.PsiReferenceProcessorAdapter;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

public class GlobalJavaInspectionContextImpl
extends GlobalJavaInspectionContext {
    private static final Logger LOG = Logger.getInstance(GlobalJavaInspectionContextImpl.class);
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.DerivedMethodsProcessor>> myDerivedMethodsRequests;
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.DerivedClassesProcessor>> myDerivedClassesRequests;
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.UsagesProcessor>> myMethodUsagesRequests;
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.UsagesProcessor>> myFieldUsagesRequests;
    private Map<SmartPsiElementPointer, List<GlobalJavaInspectionContext.UsagesProcessor>> myClassUsagesRequests;
    private Map<SmartPsiElementPointer, List<Runnable>> myQNameUsagesRequests;

    public void enqueueClassUsagesProcessor(RefClass refClass, GlobalJavaInspectionContext.UsagesProcessor p) {
        if (this.myClassUsagesRequests == null) {
            this.myClassUsagesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refClass, this.myClassUsagesRequests, p);
    }

    public void enqueueDerivedClassesProcessor(RefClass refClass, GlobalJavaInspectionContext.DerivedClassesProcessor p) {
        if (this.myDerivedClassesRequests == null) {
            this.myDerivedClassesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refClass, this.myDerivedClassesRequests, p);
    }

    public void enqueueDerivedMethodsProcessor(RefMethod refMethod, GlobalJavaInspectionContext.DerivedMethodsProcessor p) {
        if (refMethod.isConstructor() || refMethod.isStatic()) {
            return;
        }
        if (this.myDerivedMethodsRequests == null) {
            this.myDerivedMethodsRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refMethod, this.myDerivedMethodsRequests, p);
    }

    public void enqueueFieldUsagesProcessor(RefField refField, GlobalJavaInspectionContext.UsagesProcessor p) {
        if (this.myFieldUsagesRequests == null) {
            this.myFieldUsagesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refField, this.myFieldUsagesRequests, p);
    }

    public void enqueueMethodUsagesProcessor(RefMethod refMethod, GlobalJavaInspectionContext.UsagesProcessor p) {
        if (this.myMethodUsagesRequests == null) {
            this.myMethodUsagesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refMethod, this.myMethodUsagesRequests, p);
    }

    public void enqueueQualifiedNameOccurrencesProcessor(RefClass refClass, Runnable c) {
        if (this.myQNameUsagesRequests == null) {
            this.myQNameUsagesRequests = new THashMap();
        }
        GlobalJavaInspectionContextImpl.enqueueRequestImpl((RefElement)refClass, this.myQNameUsagesRequests, c);
    }

    public EntryPointsManager getEntryPointsManager(RefManager manager) {
        return ((RefJavaManager)manager.getExtension(RefJavaManager.MANAGER)).getEntryPointsManager();
    }

    public static boolean isInspectionsEnabled(boolean online, @NotNull Project project) {
        if (project == null) {
            GlobalJavaInspectionContextImpl.$$$reportNull$$$0(0);
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (online) {
            if (modules.length == 0) {
                Messages.showMessageDialog((Project)project, (String)InspectionsBundle.message((String)"inspection.no.modules.error.message", (Object[])new Object[0]), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return false;
            }
            while (GlobalJavaInspectionContextImpl.isBadSdk(project, modules)) {
                Messages.showMessageDialog((Project)project, (String)InspectionsBundle.message((String)"inspection.no.jdk.error.message", (Object[])new Object[0]), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                Sdk projectJdk = ProjectSettingsService.getInstance((Project)project).chooseAndSetSdk();
                if (projectJdk == null) {
                    return false;
                }
                DumbService.getInstance((Project)project).completeJustSubmittedTasks();
            }
        } else {
            if (modules.length == 0) {
                System.err.println(InspectionsBundle.message((String)"inspection.no.modules.error.message", (Object[])new Object[0]));
                return false;
            }
            if (GlobalJavaInspectionContextImpl.isBadSdk(project, modules)) {
                System.err.println(InspectionsBundle.message((String)"inspection.no.jdk.error.message", (Object[])new Object[0]));
                System.err.println(InspectionsBundle.message((String)"offline.inspections.jdk.not.found", (Object[])new Object[]{ProjectRootManager.getInstance((Project)project).getProjectSdkName()}));
                return false;
            }
            for (Module module : modules) {
                OrderEntry[] entries;
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                for (OrderEntry entry : entries = rootManager.getOrderEntries()) {
                    LibraryOrderEntry libraryOrderEntry;
                    Library library;
                    if (entry instanceof JdkOrderEntry) {
                        if (ModuleType.get((Module)module).isValidSdk(module, null)) continue;
                        System.err.println(InspectionsBundle.message((String)"offline.inspections.module.jdk.not.found", (Object[])new Object[]{((JdkOrderEntry)entry).getJdkName(), module.getName()}));
                        return false;
                    }
                    if (!(entry instanceof LibraryOrderEntry) || (library = (libraryOrderEntry = (LibraryOrderEntry)entry).getLibrary()) != null && library.getFiles(OrderRootType.CLASSES).length >= library.getUrls(OrderRootType.CLASSES).length) continue;
                    System.err.println(InspectionsBundle.message((String)"offline.inspections.library.was.not.resolved", (Object[])new Object[]{libraryOrderEntry.getPresentableName(), module.getName()}));
                }
            }
        }
        return true;
    }

    private static boolean isBadSdk(Project project, Module[] modules) {
        boolean anyModuleAcceptsSdk = false;
        boolean anyModuleUsesProjectSdk = false;
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        for (Module module : modules) {
            if (!ModuleRootManager.getInstance((Module)module).isSdkInherited()) continue;
            anyModuleUsesProjectSdk = true;
            if (!ModuleType.get((Module)module).isValidSdk(module, projectSdk)) continue;
            anyModuleAcceptsSdk = true;
        }
        return anyModuleUsesProjectSdk && !anyModuleAcceptsSdk;
    }

    private static <T> void enqueueRequestImpl(RefElement refElement, Map<SmartPsiElementPointer, List<T>> requestMap, T processor) {
        List requests = requestMap.computeIfAbsent(refElement.getPointer(), __ -> new ArrayList());
        requests.add(processor);
    }

    public void cleanup() {
        this.myDerivedMethodsRequests = null;
        this.myDerivedClassesRequests = null;
        this.myMethodUsagesRequests = null;
        this.myFieldUsagesRequests = null;
        this.myClassUsagesRequests = null;
    }

    private void processSearchRequests(GlobalInspectionContext context) {
        UClass uClass;
        UMethod uMethod;
        List<GlobalJavaInspectionContext.UsagesProcessor> processors;
        List<SmartPsiElementPointer> sortedIDs;
        final RefManager refManager = context.getRefManager();
        final AnalysisScope scope = refManager.getScope();
        GlobalSearchScope searchScope = new GlobalSearchScope(refManager.getProject()){
            private final boolean processedReferences;
            {
                super(arg0);
                this.processedReferences = Registry.is((String)"batch.inspections.process.external.elements");
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (scope != null && !scope.contains(file)) {
                    return true;
                }
                boolean inGraph = this.processedReferences ? refManager.isInGraph(file) : file.getFileType() == StdFileTypes.JAVA;
                return !inGraph;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (this.myDerivedClassesRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myDerivedClassesRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                UClass uClass2 = (UClass)ReadAction.compute(() -> (UClass)UastContextKt.toUElement((PsiElement)GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID), UClass.class));
                if (uClass2 == null) continue;
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, GlobalJavaInspectionContextImpl.getClassPresentableName(uClass2));
                processors = this.myDerivedClassesRequests.get(sortedID);
                LOG.assertTrue(processors != null, (Object)uClass2.getClass().getName());
                ClassInheritorsSearch.search((PsiClass)uClass2.getJavaPsi(), (SearchScope)searchScope, (boolean)false).forEach(GlobalJavaInspectionContextImpl.createMembersProcessor(processors, scope));
            }
            this.myDerivedClassesRequests = null;
        }
        if (this.myDerivedMethodsRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myDerivedMethodsRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                uMethod = (UMethod)ReadAction.compute(() -> (UMethod)UastContextKt.toUElement((PsiElement)GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID), UMethod.class));
                if (uMethod == null) continue;
                RefMethod refMethod = (RefMethod)refManager.getReference(uMethod.getSourcePsi());
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, refManager.getQualifiedName((RefEntity)refMethod));
                List<GlobalJavaInspectionContext.DerivedMethodsProcessor> processors2 = this.myDerivedMethodsRequests.get(sortedID);
                LOG.assertTrue(processors2 != null, (Object)uMethod.getClass().getName());
                OverridingMethodsSearch.search((PsiMethod)uMethod.getJavaPsi(), (SearchScope)searchScope, (boolean)true).forEach(GlobalJavaInspectionContextImpl.createMembersProcessor(processors2, scope));
            }
            this.myDerivedMethodsRequests = null;
        }
        if (this.myFieldUsagesRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myFieldUsagesRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                PsiElement field = GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID);
                if (field == null) continue;
                processors = this.myFieldUsagesRequests.get(sortedID);
                LOG.assertTrue(processors != null, (Object)field.getClass().getName());
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, refManager.getQualifiedName((RefEntity)refManager.getReference(field)));
                ReferencesSearch.search((PsiElement)field, (SearchScope)searchScope, (boolean)false).forEach((Processor)new PsiReferenceProcessorAdapter(GlobalJavaInspectionContextImpl.createReferenceProcessor(processors, context)));
            }
            this.myFieldUsagesRequests = null;
        }
        if (this.myClassUsagesRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myClassUsagesRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                PsiElement classDeclaration = GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID);
                if (classDeclaration == null) continue;
                processors = this.myClassUsagesRequests.get(sortedID);
                LOG.assertTrue(processors != null, (Object)classDeclaration.getClass().getName());
                uClass = (UClass)ReadAction.compute(() -> (UClass)UastContextKt.toUElement((PsiElement)classDeclaration, UClass.class));
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, GlobalJavaInspectionContextImpl.getClassPresentableName(uClass));
                ReferencesSearch.search((PsiElement)classDeclaration, (SearchScope)searchScope, (boolean)false).forEach((Processor)new PsiReferenceProcessorAdapter(GlobalJavaInspectionContextImpl.createReferenceProcessor(processors, context)));
            }
            this.myClassUsagesRequests = null;
        }
        if (this.myMethodUsagesRequests != null) {
            sortedIDs = GlobalJavaInspectionContextImpl.getSortedIDs(this.myMethodUsagesRequests);
            for (SmartPsiElementPointer sortedID : sortedIDs) {
                uMethod = (UMethod)ReadAction.compute(() -> (UMethod)UastContextKt.toUElement((PsiElement)GlobalJavaInspectionContextImpl.dereferenceInReadAction(sortedID), UMethod.class));
                if (uMethod == null) continue;
                processors = this.myMethodUsagesRequests.get(sortedID);
                LOG.assertTrue(processors != null, (Object)uMethod.getClass().getName());
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, (String)ReadAction.compute(() -> uMethod.getName()));
                PsiMethod javaMethod = (PsiMethod)ReadAction.compute(() -> uMethod.getJavaPsi());
                if (javaMethod == null) continue;
                MethodReferencesSearch.search((PsiMethod)javaMethod, (SearchScope)searchScope, (boolean)true).forEach((Processor)new PsiReferenceProcessorAdapter(GlobalJavaInspectionContextImpl.createReferenceProcessor(processors, context)));
            }
            this.myMethodUsagesRequests = null;
        }
        if (this.myQNameUsagesRequests != null) {
            PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)refManager.getProject());
            final RefJavaManager javaManager = (RefJavaManager)refManager.getExtension(RefJavaManager.MANAGER);
            List<SmartPsiElementPointer> sortedIDs2 = GlobalJavaInspectionContextImpl.getSortedIDs(this.myQNameUsagesRequests);
            for (SmartPsiElementPointer id : sortedIDs2) {
                uClass = (UClass)ReadAction.compute(() -> (UClass)UastContextKt.toUElement((PsiElement)GlobalJavaInspectionContextImpl.dereferenceInReadAction(id), UClass.class));
                String qualifiedName = uClass != null ? (String)ReadAction.compute(() -> uClass.getQualifiedName()) : null;
                if (qualifiedName == null) continue;
                List<Runnable> callbacks = this.myQNameUsagesRequests.get(id);
                GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)context.getProject());
                PsiNonJavaFileReferenceProcessor processor = (file, startOffset, endOffset) -> {
                    for (Runnable callback : callbacks) {
                        callback.run();
                    }
                    return false;
                };
                DelegatingGlobalSearchScope globalSearchScope = new DelegatingGlobalSearchScope(projectScope){
                    Set<FileType> fileTypes;
                    {
                        super(arg0);
                        this.fileTypes = javaManager.getLanguages().stream().map(l -> l.getAssociatedFileType()).collect(Collectors.toSet());
                    }

                    public boolean contains(@NotNull VirtualFile file) {
                        if (file == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return !this.fileTypes.contains(file.getFileType()) && super.contains(file);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl$2", "contains"));
                    }
                };
                helper.processUsagesInNonJavaFiles(qualifiedName, processor, (GlobalSearchScope)globalSearchScope);
            }
            this.myQNameUsagesRequests = null;
        }
    }

    private static String getClassPresentableName(@NotNull UClass uClass) {
        if (uClass == null) {
            GlobalJavaInspectionContextImpl.$$$reportNull$$$0(1);
        }
        return (String)ReadAction.compute(() -> {
            String qualifiedName;
            if (uClass == null) {
                GlobalJavaInspectionContextImpl.$$$reportNull$$$0(9);
            }
            return (qualifiedName = uClass.getQualifiedName()) != null ? qualifiedName : uClass.getName();
        });
    }

    private static PsiElement dereferenceInReadAction(SmartPsiElementPointer sortedID) {
        return (PsiElement)ReadAction.compute(() -> sortedID.getElement());
    }

    private static <Member extends PsiMember, P extends Processor<Member>> PsiElementProcessorAdapter<Member> createMembersProcessor(List<P> processors, AnalysisScope scope) {
        return new PsiElementProcessorAdapter(member -> {
            if (scope.contains(member)) {
                return true;
            }
            ArrayList processorsArrayed = new ArrayList(processors);
            for (Processor processor : processorsArrayed) {
                if (processor.process((Object)member)) continue;
                processors.remove(processor);
            }
            return !processors.isEmpty();
        });
    }

    private int getRequestCount() {
        int sum = 0;
        sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myClassUsagesRequests);
        sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myDerivedClassesRequests);
        sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myDerivedMethodsRequests);
        sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myFieldUsagesRequests);
        return sum += GlobalJavaInspectionContextImpl.getRequestListSize(this.myMethodUsagesRequests);
    }

    private static int getRequestListSize(Map<?, ?> list) {
        return list == null ? 0 : list.size();
    }

    private static List<SmartPsiElementPointer> getSortedIDs(Map<SmartPsiElementPointer, ?> requests) {
        ArrayList<SmartPsiElementPointer> result = new ArrayList<SmartPsiElementPointer>();
        ApplicationManager.getApplication().runReadAction(() -> {
            for (SmartPsiElementPointer id : requests.keySet()) {
                if (id == null || id.getContainingFile() == null) continue;
                result.add(id);
            }
            Collections.sort(result, (o1, o2) -> {
                PsiFile psiFile1 = o1.getContainingFile();
                LOG.assertTrue(psiFile1 != null);
                PsiFile psiFile2 = o2.getContainingFile();
                LOG.assertTrue(psiFile2 != null);
                return psiFile1.getName().compareTo(psiFile2.getName());
            });
        });
        return result;
    }

    private static PsiReferenceProcessor createReferenceProcessor(@NotNull List<GlobalJavaInspectionContext.UsagesProcessor> processors, GlobalInspectionContext context) {
        if (processors == null) {
            GlobalJavaInspectionContextImpl.$$$reportNull$$$0(2);
        }
        return reference -> {
            AnalysisScope scope;
            if (processors == null) {
                GlobalJavaInspectionContextImpl.$$$reportNull$$$0(8);
            }
            if ((scope = context.getRefManager().getScope()) != null && scope.contains(reference.getElement()) && reference.getElement().getLanguage() == JavaLanguage.INSTANCE || PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiDocComment.class) != null) {
                return true;
            }
            List list = processors;
            synchronized (list) {
                GlobalJavaInspectionContext.UsagesProcessor[] processorsArrayed;
                for (GlobalJavaInspectionContext.UsagesProcessor processor : processorsArrayed = processors.toArray(new GlobalJavaInspectionContext.UsagesProcessor[0])) {
                    if (processor.process((Object)reference)) continue;
                    processors.remove(processor);
                }
            }
            return !processors.isEmpty();
        };
    }

    public void performPreRunActivities(@NotNull List<Tools> globalTools, @NotNull List<Tools> localTools, @NotNull GlobalInspectionContext context) {
        if (globalTools == null) {
            GlobalJavaInspectionContextImpl.$$$reportNull$$$0(3);
        }
        if (localTools == null) {
            GlobalJavaInspectionContextImpl.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GlobalJavaInspectionContextImpl.$$$reportNull$$$0(5);
        }
        this.getEntryPointsManager(context.getRefManager()).resolveEntryPoints(context.getRefManager());
        for (int i = 0; i < globalTools.size(); ++i) {
            InspectionToolWrapper toolWrapper = globalTools.get(i).getTool();
            if (!"unused".equals(toolWrapper.getShortName())) continue;
            Collections.swap(globalTools, i, 0);
            break;
        }
    }

    public void performPostRunActivities(@NotNull List<InspectionToolWrapper> needRepeatSearchRequest, @NotNull GlobalInspectionContext context) {
        if (needRepeatSearchRequest == null) {
            GlobalJavaInspectionContextImpl.$$$reportNull$$$0(6);
        }
        if (context == null) {
            GlobalJavaInspectionContextImpl.$$$reportNull$$$0(7);
        }
        JobDescriptor progress = context.getStdJobDescriptors().FIND_EXTERNAL_USAGES;
        progress.setTotalAmount(this.getRequestCount());
        do {
            this.processSearchRequests(context);
            InspectionToolWrapper[] requestors = needRepeatSearchRequest.toArray(InspectionToolWrapper.EMPTY_ARRAY);
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)context.getProject());
            for (InspectionToolWrapper toolWrapper : requestors) {
                boolean result = false;
                if (toolWrapper instanceof GlobalInspectionToolWrapper) {
                    InspectionToolPresentation presentation = ((GlobalInspectionContextImpl)context).getPresentation(toolWrapper);
                    result = ((GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool()).queryExternalUsagesRequests(inspectionManager, context, (ProblemDescriptionsProcessor)presentation);
                }
                if (result) continue;
                needRepeatSearchRequest.remove(toolWrapper);
            }
            int oldSearchRequestCount = progress.getTotalAmount();
            int oldDoneAmount = progress.getDoneAmount();
            int totalAmount = oldSearchRequestCount + this.getRequestCount();
            progress.setTotalAmount(totalAmount);
            progress.setDoneAmount(oldDoneAmount);
        } while (!needRepeatSearchRequest.isEmpty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalTools";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTools";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "needRepeatSearchRequest";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ex/GlobalJavaInspectionContextImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInspectionsEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferenceProcessor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "performPreRunActivities";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "performPostRunActivities";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createReferenceProcessor$15";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getClassPresentableName$10";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

