/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Locale;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class OperationReductionMigration
extends BaseStreamApiMigration {
    private final ReductionOperation myReductionOperation;
    static final ReductionOperation SUM_OPERATION = new ReductionOperation(JavaTokenType.PLUSEQ, ExpressionUtils::isZero, OperationReductionMigration::arithmeticTypeRestriction, "0", "+");
    static final ReductionOperation[] OPERATIONS = new ReductionOperation[]{new ReductionOperation(JavaTokenType.ASTERISKEQ, ExpressionUtils::isOne, OperationReductionMigration::arithmeticTypeRestriction, "1", "*"), new ReductionOperation(JavaTokenType.ANDEQ, expression2 -> Boolean.TRUE.equals(ExpressionUtils.computeConstantExpression(expression2)), OperationReductionMigration::booleanTypeRestriction, "true", "&&"), new ReductionOperation(JavaTokenType.OREQ, expression2 -> Boolean.FALSE.equals(ExpressionUtils.computeConstantExpression(expression2)), OperationReductionMigration::booleanTypeRestriction, "false", "||"), new ReductionOperation(JavaTokenType.OREQ, ExpressionUtils::isZero, OperationReductionMigration::arithmeticTypeRestriction, "0", "|"), new ReductionOperation(JavaTokenType.ANDEQ, OperationReductionMigration::isMinusOne, OperationReductionMigration::bitwiseTypeRestriction, "-1", "&"), new ReductionOperation(JavaTokenType.XOREQ, ExpressionUtils::isZero, OperationReductionMigration::bitwiseTypeRestriction, "0", "^")};

    protected OperationReductionMigration(boolean shouldWarn, ReductionOperation context) {
        super(shouldWarn, "reduce()");
        this.myReductionOperation = context;
    }

    @Override
    PsiElement migrate(@NotNull Project project, @NotNull PsiElement body2, @NotNull TerminalBlock tb) {
        PsiExpression initializer;
        PsiAssignmentExpression assignment;
        if (project == null) {
            OperationReductionMigration.$$$reportNull$$$0(0);
        }
        if (body2 == null) {
            OperationReductionMigration.$$$reportNull$$$0(1);
        }
        if (tb == null) {
            OperationReductionMigration.$$$reportNull$$$0(2);
        }
        if ((assignment = tb.getSingleExpression(PsiAssignmentExpression.class)) == null) {
            return null;
        }
        PsiVariable var = StreamApiMigrationInspection.extractAccumulator(assignment, this.myReductionOperation.getCompoundAssignmentOp());
        if (var == null) {
            return null;
        }
        CommentTracker ct = new CommentTracker();
        PsiExpression operand2 = StreamApiMigrationInspection.extractOperand(assignment, this.myReductionOperation.getCompoundAssignmentOp());
        if (operand2 == null) {
            return null;
        }
        PsiType type2 = var.getType();
        PsiType operandType = operand2.getType();
        if (operandType != null && !TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)operandType)) {
            operand2 = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("(" + type2.getCanonicalText() + ")" + ct.text(operand2, 4), (PsiElement)operand2);
        }
        JavaCodeStyleManager javaStyle = JavaCodeStyleManager.getInstance((Project)project);
        String leftOperand2 = javaStyle.suggestUniqueVariableName("a", body2, true);
        String rightOperand2 = javaStyle.suggestUniqueVariableName("b", body2, true);
        if (type2.equals(PsiType.BOOLEAN)) {
            type2 = PsiType.BOOLEAN.getBoxedType(body2);
        }
        String identity = (initializer = var.getInitializer()) != null && this.myReductionOperation.getInitializerExpressionRestriction().test(initializer) ? ct.text((PsiElement)initializer) : this.myReductionOperation.getIdentity();
        String stream = tb.add(new StreamApiMigrationInspection.MapOp(operand2, tb.getVariable(), type2)).generate(ct) + String.format(Locale.ENGLISH, ".reduce(%s, (%s, %s) -> %s %s %s)", identity, leftOperand2, rightOperand2, leftOperand2, this.myReductionOperation.getOperation(), rightOperand2);
        return OperationReductionMigration.replaceWithOperation(tb.getStreamSourceStatement(), var, stream, type2, this.myReductionOperation, ct);
    }

    private static boolean isMinusOne(PsiExpression expression2) {
        Object constant = ExpressionUtils.computeConstantExpression(expression2);
        if (constant == null) {
            return false;
        }
        return (constant instanceof Integer || constant instanceof Long) && ((Number)constant).longValue() == -1L;
    }

    static boolean bitwiseTypeRestriction(@NotNull PsiVariable variable) {
        if (variable == null) {
            OperationReductionMigration.$$$reportNull$$$0(3);
        }
        return variable.getType() instanceof PsiPrimitiveType && (variable.getType().equals(PsiType.INT) || variable.getType().equals(PsiType.LONG));
    }

    static boolean arithmeticTypeRestriction(@NotNull PsiVariable variable) {
        if (variable == null) {
            OperationReductionMigration.$$$reportNull$$$0(4);
        }
        return variable.getType() instanceof PsiPrimitiveType && !variable.getType().equals(PsiType.FLOAT);
    }

    private static boolean booleanTypeRestriction(@NotNull PsiVariable variable) {
        if (variable == null) {
            OperationReductionMigration.$$$reportNull$$$0(5);
        }
        return variable.getType().equalsToText("boolean") || variable.getType().equalsToText("java.lang.Boolean");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tb";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/streamMigration/OperationReductionMigration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "migrate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "bitwiseTypeRestriction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "arithmeticTypeRestriction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "booleanTypeRestriction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ReductionOperation {
        private final IElementType myCompoundAssignmentOp;
        private final Predicate<PsiExpression> myInitializerReplaceCondition;
        private final Predicate<PsiVariable> myAccumulatorRestriction;
        private final String myIdentity;
        private final String myOperation;

        ReductionOperation(IElementType compoundAssignmentOp, Predicate<PsiExpression> initializerReplaceCondition, Predicate<PsiVariable> accumulatorRestriction, String identity, String operation) {
            this.myCompoundAssignmentOp = compoundAssignmentOp;
            this.myInitializerReplaceCondition = initializerReplaceCondition;
            this.myAccumulatorRestriction = accumulatorRestriction;
            this.myIdentity = identity;
            this.myOperation = operation;
        }

        public IElementType getCompoundAssignmentOp() {
            return this.myCompoundAssignmentOp;
        }

        public Predicate<PsiExpression> getInitializerExpressionRestriction() {
            return this.myInitializerReplaceCondition;
        }

        public String getIdentity() {
            return this.myIdentity;
        }

        public String getOperation() {
            return this.myOperation;
        }

        public Predicate<PsiVariable> getAccumulatorRestriction() {
            return this.myAccumulatorRestriction;
        }
    }
}

