/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.OperationReductionMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

class SumMigration
extends BaseStreamApiMigration {
    SumMigration(boolean shouldWarn) {
        super(shouldWarn, "sum()");
    }

    @Override
    PsiElement migrate(@NotNull Project project, @NotNull PsiElement body2, @NotNull TerminalBlock tb) {
        PsiAssignmentExpression assignment;
        if (project == null) {
            SumMigration.$$$reportNull$$$0(0);
        }
        if (body2 == null) {
            SumMigration.$$$reportNull$$$0(1);
        }
        if (tb == null) {
            SumMigration.$$$reportNull$$$0(2);
        }
        if ((assignment = tb.getSingleExpression(PsiAssignmentExpression.class)) == null) {
            return null;
        }
        PsiVariable var = StreamApiMigrationInspection.extractSumAccumulator(assignment);
        if (var == null) {
            return null;
        }
        PsiExpression addend = StreamApiMigrationInspection.extractAddend(assignment);
        if (addend == null) {
            return null;
        }
        PsiType type2 = var.getType();
        if (!(type2 instanceof PsiPrimitiveType) || type2.equals(PsiType.FLOAT)) {
            return null;
        }
        if (!type2.equals(PsiType.DOUBLE) && !type2.equals(PsiType.LONG)) {
            type2 = PsiType.INT;
        }
        PsiType addendType = addend.getType();
        CommentTracker ct = new CommentTracker();
        if (addendType != null && !TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)addendType)) {
            addend = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("(" + type2.getCanonicalText() + ")" + ct.text(addend, 4), (PsiElement)addend);
        }
        String stream = tb.add(new StreamApiMigrationInspection.MapOp(addend, tb.getVariable(), type2)).generate(ct) + ".sum()";
        return SumMigration.replaceWithOperation(tb.getStreamSourceStatement(), var, stream, type2, OperationReductionMigration.SUM_OPERATION, ct);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "body";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "tb";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/streamMigration/SumMigration";
        objectArray[2] = "migrate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

