/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.util.AbstractTreeClassChooserDialog;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeChooser;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeJavaClassChooserDialog
extends AbstractTreeClassChooserDialog<PsiClass>
implements TreeClassChooser {
    public TreeJavaClassChooserDialog(String title, Project project) {
        super(title, project, PsiClass.class);
    }

    public TreeJavaClassChooserDialog(String title, Project project, @Nullable PsiClass initialClass) {
        super(title, project, PsiClass.class, (PsiNamedElement)initialClass);
    }

    public TreeJavaClassChooserDialog(String title, @NotNull Project project, GlobalSearchScope scope, ClassFilter classFilter, @Nullable PsiClass initialClass) {
        if (project == null) {
            TreeJavaClassChooserDialog.$$$reportNull$$$0(0);
        }
        super(title, project, scope, PsiClass.class, TreeJavaClassChooserDialog.createFilter(classFilter), (PsiNamedElement)initialClass);
    }

    public TreeJavaClassChooserDialog(String title, @NotNull Project project, GlobalSearchScope scope, @Nullable ClassFilter classFilter, PsiClass baseClass, @Nullable PsiClass initialClass, boolean isShowMembers) {
        if (project == null) {
            TreeJavaClassChooserDialog.$$$reportNull$$$0(1);
        }
        super(title, project, scope, PsiClass.class, TreeJavaClassChooserDialog.createFilter(classFilter), (PsiNamedElement)baseClass, (PsiNamedElement)initialClass, isShowMembers, true);
    }

    public static TreeJavaClassChooserDialog withInnerClasses(String title, @NotNull Project project, GlobalSearchScope scope, ClassFilter classFilter, @Nullable PsiClass initialClass) {
        if (project == null) {
            TreeJavaClassChooserDialog.$$$reportNull$$$0(2);
        }
        return new TreeJavaClassChooserDialog(title, project, scope, classFilter, null, initialClass, true);
    }

    @Nullable
    private static TreeChooser.Filter<PsiClass> createFilter(final @Nullable ClassFilter classFilter) {
        if (classFilter == null) {
            return null;
        }
        return new TreeChooser.Filter<PsiClass>(){

            public boolean isAccepted(PsiClass element) {
                return (Boolean)ReadAction.compute(() -> classFilter.isAccepted(element));
            }
        };
    }

    @Nullable
    protected PsiClass getSelectedFromTreeUserObject(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (!(userObject instanceof ClassTreeNode)) {
            return null;
        }
        ClassTreeNode descriptor = (ClassTreeNode)((Object)userObject);
        return descriptor.getPsiClass();
    }

    @NotNull
    protected List<PsiClass> getClassesByName(String name, boolean checkBoxState, String pattern, GlobalSearchScope searchScope) {
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)this.getProject());
        Object[] classes2 = cache.getClassesByName(name, checkBoxState ? searchScope : GlobalSearchScope.projectScope((Project)this.getProject()).intersectWith(searchScope));
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])classes2);
        if (arrayList == null) {
            TreeJavaClassChooserDialog.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    protected AbstractTreeClassChooserDialog.BaseClassInheritorsProvider<PsiClass> getInheritorsProvider(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            TreeJavaClassChooserDialog.$$$reportNull$$$0(4);
        }
        JavaInheritorsProvider javaInheritorsProvider = new JavaInheritorsProvider(this.getProject(), baseClass, this.getScope());
        if (javaInheritorsProvider == null) {
            TreeJavaClassChooserDialog.$$$reportNull$$$0(5);
        }
        return javaInheritorsProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/TreeJavaClassChooserDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/TreeJavaClassChooserDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritorsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withInnerClasses";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInheritorsProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InheritanceJavaClassFilterImpl
    implements ClassFilter {
        private final PsiClass myBase;
        private final boolean myAcceptsSelf;
        private final boolean myAcceptsInner;
        @NotNull
        private final Condition<? super PsiClass> myAdditionalCondition;

        public InheritanceJavaClassFilterImpl(PsiClass base, boolean acceptsSelf, boolean acceptInner, @Nullable Condition<? super PsiClass> additionalCondition) {
            this.myAcceptsSelf = acceptsSelf;
            this.myAcceptsInner = acceptInner;
            if (additionalCondition == null) {
                additionalCondition = Conditions.alwaysTrue();
            }
            this.myAdditionalCondition = additionalCondition;
            this.myBase = base;
        }

        public boolean isAccepted(PsiClass aClass) {
            if (!this.myAcceptsInner && !(aClass.getParent() instanceof PsiJavaFile)) {
                return false;
            }
            if (!this.myAdditionalCondition.value((Object)aClass)) {
                return false;
            }
            return this.myAcceptsSelf || !aClass.getManager().areElementsEquivalent((PsiElement)aClass, (PsiElement)this.myBase);
        }
    }

    private static class JavaInheritorsProvider
    extends AbstractTreeClassChooserDialog.BaseClassInheritorsProvider<PsiClass> {
        private final Project myProject;

        JavaInheritorsProvider(Project project, PsiClass baseClass, GlobalSearchScope scope) {
            super((Object)baseClass, scope);
            this.myProject = project;
        }

        @NotNull
        protected Query<PsiClass> searchForInheritors(PsiClass baseClass, GlobalSearchScope searchScope, boolean checkDeep) {
            Query query = ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)searchScope, (boolean)checkDeep);
            if (query == null) {
                JavaInheritorsProvider.$$$reportNull$$$0(0);
            }
            return query;
        }

        protected boolean isInheritor(PsiClass clazz, PsiClass baseClass, boolean checkDeep) {
            return clazz.isInheritor(baseClass, checkDeep);
        }

        protected String[] getNames() {
            return PsiShortNamesCache.getInstance((Project)this.myProject).getAllClassNames();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeJavaClassChooserDialog$JavaInheritorsProvider", "searchForInheritors"));
        }
    }
}

