/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.javadoc.JavadocHelper;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EnterInJavadocParamDescriptionHandler
extends EnterHandlerDelegateAdapter {
    private final JavadocHelper myHelper = JavadocHelper.getInstance();

    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (file == null) {
            EnterInJavadocParamDescriptionHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EnterInJavadocParamDescriptionHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            EnterInJavadocParamDescriptionHandler.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PsiJavaFile && CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER && ((JavaCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, JavaCodeStyleSettings.class)).JD_ALIGN_PARAM_COMMENTS)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        CaretModel caretModel = editor.getCaretModel();
        int caretOffset = caretModel.getOffset();
        if (!EnterInJavadocParamDescriptionHandler.isInJavaDoc(editor, caretOffset)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Pair<JavadocHelper.JavadocParameterInfo, List<JavadocHelper.JavadocParameterInfo>> pair = this.myHelper.parse(file, editor, caretOffset);
        if (pair.first == null || ((JavadocHelper.JavadocParameterInfo)pair.first).parameterDescriptionStartPosition == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        LogicalPosition caretPosition = caretModel.getLogicalPosition();
        LogicalPosition nameEndPosition = ((JavadocHelper.JavadocParameterInfo)pair.first).parameterNameEndPosition;
        if (nameEndPosition.line == caretPosition.line && caretPosition.column <= nameEndPosition.column) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int descriptionStartColumn = ((JavadocHelper.JavadocParameterInfo)pair.first).parameterDescriptionStartPosition.column;
        LogicalPosition desiredPosition = new LogicalPosition(caretPosition.line, descriptionStartColumn);
        Document document = editor.getDocument();
        CharSequence text2 = document.getCharsSequence();
        int offsetAfterLastWs = CharArrayUtil.shiftForward((CharSequence)text2, (int)caretOffset, (String)" \t");
        if (editor.offsetToLogicalPosition((int)offsetAfterLastWs).column < desiredPosition.column) {
            int lineStartOffset = document.getLineStartOffset(desiredPosition.line);
            String toInsert = StringUtil.repeat((String)" ", (int)(desiredPosition.column - (offsetAfterLastWs - lineStartOffset)));
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (file == null) {
                    EnterInJavadocParamDescriptionHandler.$$$reportNull$$$0(4);
                }
                document.insertString(caretOffset, (CharSequence)toInsert);
                PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            });
        }
        this.myHelper.navigate(desiredPosition, editor, file.getProject());
        return EnterHandlerDelegate.Result.Stop;
    }

    private static boolean isInJavaDoc(@NotNull Editor editor, int offset) {
        Document document;
        CharSequence docChars;
        int i;
        if (editor == null) {
            EnterInJavadocParamDescriptionHandler.$$$reportNull$$$0(3);
        }
        if ((i = CharArrayUtil.lastIndexOf((CharSequence)(docChars = (document = editor.getDocument()).getCharsSequence()), (String)"/**", (int)offset)) >= 0) {
            return (i = CharArrayUtil.indexOf((CharSequence)docChars, (CharSequence)"*/", (int)i)) > offset;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javadoc/EnterInJavadocParamDescriptionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessEnter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInJavaDoc";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$postProcessEnter$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

