/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceParser {
    public static final int EAT_LAST_DOT = 1;
    public static final int ELLIPSIS = 2;
    public static final int WILDCARD = 4;
    public static final int DIAMONDS = 8;
    public static final int DISJUNCTIONS = 16;
    public static final int CONJUNCTIONS = 32;
    public static final int INCOMPLETE_ANNO = 64;
    public static final int VAR_TYPE = 128;
    private static final TokenSet WILDCARD_KEYWORD_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.SUPER_KEYWORD});
    private final JavaParser myParser;

    public ReferenceParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            ReferenceParser.$$$reportNull$$$0(0);
        }
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parseType(PsiBuilder builder, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder, flags);
        return typeInfo != null ? typeInfo.marker : null;
    }

    @Nullable
    public TypeInfo parseTypeInfo(PsiBuilder builder, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder, flags, false);
        if (typeInfo != null) {
            IElementType operator2;
            assert (!BitUtil.isSet((int)flags, (int)16) || !BitUtil.isSet((int)flags, (int)32)) : "don't set both flags simultaneously";
            Object object = BitUtil.isSet((int)flags, (int)16) ? JavaTokenType.OR : (operator2 = BitUtil.isSet((int)flags, (int)32) ? JavaTokenType.AND : null);
            if (operator2 != null && builder.getTokenType() == operator2) {
                typeInfo.marker = typeInfo.marker.precede();
                while (builder.getTokenType() == operator2) {
                    builder.advanceLexer();
                    IElementType tokenType = builder.getTokenType();
                    if (tokenType != JavaTokenType.IDENTIFIER && tokenType != JavaTokenType.AT) {
                        JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                    }
                    this.parseTypeInfo(builder, flags, false);
                }
                typeInfo.marker.done(JavaElementType.TYPE);
            }
        }
        return typeInfo;
    }

    @Nullable
    private TypeInfo parseTypeInfo(PsiBuilder builder, int flags, boolean badWildcard) {
        if (builder.getTokenType() == null) {
            return null;
        }
        TypeInfo typeInfo = new TypeInfo();
        PsiBuilder.Marker type2 = builder.mark();
        PsiBuilder.Marker anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.IDENTIFIER && BitUtil.isSet((int)flags, (int)128) && "var".equals(builder.getTokenText()) && JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_10)) {
            tokenType = JavaTokenType.VAR_KEYWORD;
            builder.remapCurrentToken(tokenType);
        } else if (tokenType == JavaTokenType.VAR_KEYWORD && !BitUtil.isSet((int)flags, (int)128)) {
            tokenType = JavaTokenType.IDENTIFIER;
            builder.remapCurrentToken(tokenType);
        }
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)ElementType.PRIMITIVE_TYPE_BIT_SET)) {
            typeInfo.isPrimitive = true;
        } else {
            if ((BitUtil.isSet((int)flags, (int)4) || badWildcard) && (tokenType == JavaTokenType.QUEST || ReferenceParser.isKeywordAny(builder))) {
                if (tokenType == JavaTokenType.QUEST) {
                    builder.advanceLexer();
                } else {
                    ReferenceParser.dummy(builder);
                }
                this.completeWildcardType(builder, BitUtil.isSet((int)flags, (int)4), type2);
                typeInfo.marker = type2;
                return typeInfo;
            }
            if (tokenType == JavaTokenType.IDENTIFIER) {
                this.parseJavaCodeReference(builder, BitUtil.isSet((int)flags, (int)1), true, false, false, false, BitUtil.isSet((int)flags, (int)8), typeInfo);
            } else {
                if (tokenType == JavaTokenType.VAR_KEYWORD) {
                    builder.advanceLexer();
                    type2.done(JavaElementType.TYPE);
                    typeInfo.marker = type2;
                    return typeInfo;
                }
                if (BitUtil.isSet((int)flags, (int)8) && tokenType == JavaTokenType.GT) {
                    if (anno == null) {
                        JavaParserUtil.emptyElement(builder, JavaElementType.DIAMOND_TYPE);
                    } else {
                        JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                        typeInfo.hasErrors = true;
                    }
                    type2.done(JavaElementType.TYPE);
                    typeInfo.marker = type2;
                    return typeInfo;
                }
                type2.drop();
                if (anno != null && BitUtil.isSet((int)flags, (int)64)) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.type", new Object[0]));
                    typeInfo.marker = anno;
                    typeInfo.hasErrors = true;
                    return typeInfo;
                }
                return null;
            }
        }
        while (true) {
            type2.done(JavaElementType.TYPE);
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            PsiBuilder.Marker bracket = builder.mark();
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LBRACKET)) {
                bracket.drop();
                break;
            }
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RBRACKET)) {
                bracket.rollbackTo();
                break;
            }
            bracket.drop();
            typeInfo.isArray = true;
            type2 = type2.precede();
        }
        if (BitUtil.isSet((int)flags, (int)2) && builder.getTokenType() == JavaTokenType.ELLIPSIS) {
            type2 = type2.precede();
            builder.advanceLexer();
            type2.done(JavaElementType.TYPE);
            typeInfo.isVarArg = true;
        }
        typeInfo.marker = type2;
        return typeInfo;
    }

    private void completeWildcardType(PsiBuilder builder, boolean wildcard, PsiBuilder.Marker type2) {
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)WILDCARD_KEYWORD_SET) && this.parseTypeInfo(builder, 1) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.type", new Object[0]));
        }
        if (wildcard) {
            type2.done(JavaElementType.TYPE);
        } else {
            type2.error(JavaErrorMessages.message("wildcard.not.expected", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList, boolean isNew, boolean diamonds) {
        return this.parseJavaCodeReference(builder, eatLastDot, parameterList, false, false, isNew, diamonds, new TypeInfo());
    }

    public boolean parseImportCodeReference(PsiBuilder builder, boolean isStatic) {
        TypeInfo typeInfo = new TypeInfo();
        this.parseJavaCodeReference(builder, true, false, true, isStatic, false, false, typeInfo);
        return !typeInfo.hasErrors;
    }

    @Nullable
    private PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList, boolean isImport, boolean isStaticImport, boolean isNew, boolean diamonds, TypeInfo typeInfo) {
        PsiBuilder.Marker refElement = builder.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder);
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            refElement.rollbackTo();
            if (isImport) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            }
            typeInfo.hasErrors = true;
            return null;
        }
        if (parameterList) {
            typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
        } else if (!isStaticImport) {
            JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
        }
        while (builder.getTokenType() == JavaTokenType.DOT) {
            refElement.done(JavaElementType.JAVA_CODE_REFERENCE);
            if (isNew && !diamonds && typeInfo.isParameterized) {
                return refElement;
            }
            PsiBuilder.Marker dotPos = builder.mark();
            builder.advanceLexer();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            if (isImport && PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.ASTERISK)) {
                dotPos.drop();
                return refElement;
            }
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
                if (!eatLastDot) {
                    dotPos.rollbackTo();
                    return refElement;
                }
                typeInfo.hasErrors = true;
                if (isImport) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("import.statement.identifier.or.asterisk.expected.", new Object[0]));
                } else {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                }
                dotPos.drop();
                return refElement;
            }
            dotPos.drop();
            refElement = refElement.precede();
            if (parameterList) {
                typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
                continue;
            }
            JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
        }
        refElement.done(isStaticImport ? JavaElementType.IMPORT_STATIC_REFERENCE : JavaElementType.JAVA_CODE_REFERENCE);
        return refElement;
    }

    public boolean parseReferenceParameterList(PsiBuilder builder, boolean wildcard, boolean diamonds) {
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LT)) {
            list.done(JavaElementType.REFERENCE_PARAMETER_LIST);
            return false;
        }
        int flags = BitUtil.set((int)BitUtil.set((int)1, (int)4, (boolean)wildcard), (int)8, (boolean)diamonds);
        boolean isOk = true;
        while (true) {
            if (this.parseTypeInfo(builder, flags, true) == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            } else {
                IElementType tokenType = builder.getTokenType();
                if (WILDCARD_KEYWORD_SET.contains(tokenType)) {
                    this.parseReferenceList(builder, tokenType, null, JavaTokenType.AND);
                }
            }
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.GT)) break;
            if (!JavaParserUtil.expectOrError(builder, JavaTokenType.COMMA, "expected.gt.or.comma")) {
                isOk = false;
                break;
            }
            flags = BitUtil.set((int)flags, (int)8, (boolean)false);
        }
        list.done(JavaElementType.REFERENCE_PARAMETER_LIST);
        return isOk;
    }

    @NotNull
    public PsiBuilder.Marker parseTypeParameters(PsiBuilder builder) {
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LT)) {
            list.done(JavaElementType.TYPE_PARAMETER_LIST);
            PsiBuilder.Marker marker = list;
            if (marker == null) {
                ReferenceParser.$$$reportNull$$$0(1);
            }
            return marker;
        }
        do {
            PsiBuilder.Marker param;
            if ((param = this.parseTypeParameter(builder)) != null) continue;
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.type.parameter", new Object[0]));
        } while (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.COMMA));
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.GT)) {
            if (builder.getTokenType() == JavaTokenType.IDENTIFIER) {
                if (builder.lookAhead(1) == JavaTokenType.GT) {
                    PsiBuilder.Marker errorElement = builder.mark();
                    builder.advanceLexer();
                    errorElement.error(JavaErrorMessages.message("unexpected.identifier", new Object[0]));
                    builder.advanceLexer();
                } else {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.gt", new Object[0]));
                }
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.gt", new Object[0]));
            }
        }
        list.done(JavaElementType.TYPE_PARAMETER_LIST);
        PsiBuilder.Marker marker = list;
        if (marker == null) {
            ReferenceParser.$$$reportNull$$$0(2);
        }
        return marker;
    }

    @Nullable
    public PsiBuilder.Marker parseTypeParameter(PsiBuilder builder) {
        boolean wild;
        PsiBuilder.Marker param = builder.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder);
        if (ReferenceParser.isKeywordAny(builder)) {
            ReferenceParser.dummy(builder);
        }
        if (!(wild = PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.QUEST)) && !PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            param.rollbackTo();
            return null;
        }
        this.parseReferenceList(builder, JavaTokenType.EXTENDS_KEYWORD, JavaElementType.EXTENDS_BOUND_LIST, JavaTokenType.AND);
        if (!wild) {
            param.done(JavaElementType.TYPE_PARAMETER);
        } else {
            param.error(JavaErrorMessages.message("wildcard.not.expected", new Object[0]));
        }
        return param;
    }

    public boolean parseReferenceList(PsiBuilder builder, IElementType start, @Nullable IElementType type2, IElementType delimiter) {
        PsiBuilder.Marker element = builder.mark();
        boolean endsWithError = false;
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)start)) {
            do {
                endsWithError = false;
                PsiBuilder.Marker classReference2 = this.parseJavaCodeReference(builder, false, true, false, false);
                if (classReference2 != null) continue;
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                endsWithError = true;
            } while (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)delimiter));
        }
        if (type2 != null) {
            element.done(type2);
        } else {
            element.error(JavaErrorMessages.message("bound.not.expected", new Object[0]));
        }
        return endsWithError;
    }

    private static boolean isKeywordAny(PsiBuilder builder) {
        return JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_X) && "any".equals(builder.getTokenText());
    }

    private static void dummy(PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        mark.done(JavaElementType.DUMMY_ELEMENT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/ReferenceParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/ReferenceParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TypeInfo {
        public boolean isPrimitive;
        public boolean isParameterized;
        public boolean isArray;
        public boolean isVarArg;
        public boolean hasErrors;
        public PsiBuilder.Marker marker;
    }
}

