/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalLibraryDescriptor {
    private static final Logger LOG = Logger.getInstance(ExternalLibraryDescriptor.class);
    private final String myLibraryGroupId;
    private final String myLibraryArtifactId;
    private final String myMinVersion;
    private final String myMaxVersion;
    private final String myPreferredVersion;

    public ExternalLibraryDescriptor(String libraryGroupId, String libraryArtifactId) {
        this(libraryGroupId, libraryArtifactId, null, null, null);
    }

    public ExternalLibraryDescriptor(@NotNull String libraryGroupId, @NotNull String libraryArtifactId, @Nullable String minVersion, @Nullable String maxVersion) {
        if (libraryGroupId == null) {
            ExternalLibraryDescriptor.$$$reportNull$$$0(0);
        }
        if (libraryArtifactId == null) {
            ExternalLibraryDescriptor.$$$reportNull$$$0(1);
        }
        this(libraryGroupId, libraryArtifactId, minVersion, maxVersion, null);
    }

    public ExternalLibraryDescriptor(@NotNull String libraryGroupId, @NotNull String libraryArtifactId, @Nullable String minVersion, @Nullable String maxVersion, @Nullable String preferredVersion) {
        if (libraryGroupId == null) {
            ExternalLibraryDescriptor.$$$reportNull$$$0(2);
        }
        if (libraryArtifactId == null) {
            ExternalLibraryDescriptor.$$$reportNull$$$0(3);
        }
        this.myLibraryGroupId = libraryGroupId;
        this.myLibraryArtifactId = libraryArtifactId;
        this.myMinVersion = minVersion;
        this.myMaxVersion = maxVersion;
        this.myPreferredVersion = preferredVersion;
        if (preferredVersion != null && maxVersion != null) {
            LOG.assertTrue(VersionComparatorUtil.compare((String)preferredVersion, (String)maxVersion) <= 0, (Object)("Preferred version (" + preferredVersion + ") must not be newer than max version (" + maxVersion + ")"));
        }
        if (preferredVersion != null && minVersion != null) {
            LOG.assertTrue(VersionComparatorUtil.compare((String)minVersion, (String)preferredVersion) <= 0, (Object)("Preferred version (" + preferredVersion + ") must not be older than min version (" + minVersion + ")"));
        }
        if (minVersion != null && maxVersion != null) {
            LOG.assertTrue(VersionComparatorUtil.compare((String)minVersion, (String)maxVersion) <= 0, (Object)("Max version (" + maxVersion + ") must not be older than min version (" + minVersion + ")"));
        }
    }

    @NotNull
    public String getLibraryGroupId() {
        String string = this.myLibraryGroupId;
        if (string == null) {
            ExternalLibraryDescriptor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getLibraryArtifactId() {
        String string = this.myLibraryArtifactId;
        if (string == null) {
            ExternalLibraryDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String getMinVersion() {
        return this.myMinVersion;
    }

    @Nullable
    public String getMaxVersion() {
        return this.myMaxVersion;
    }

    @Nullable
    public String getPreferredVersion() {
        return this.myPreferredVersion;
    }

    public String getPresentableName() {
        return this.myLibraryArtifactId;
    }

    @NotNull
    public List<String> getLibraryClassesRoots() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            ExternalLibraryDescriptor.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryGroupId";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryArtifactId";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ExternalLibraryDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ExternalLibraryDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryGroupId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryArtifactId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryClassesRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

