/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.stubsHierarchy.impl.Import;
import com.intellij.psi.stubsHierarchy.impl.Imports;
import com.intellij.psi.stubsHierarchy.impl.IncompleteHierarchyException;
import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.StubHierarchyConnector;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.impl.Symbols;
import com.intellij.psi.stubsHierarchy.impl.UnitInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubResolver {
    private static final Import[] DEFAULT_JAVA_IMPORTS = new Import[]{StubResolver.importPackage("java.lang")};
    private static final Import[] DEFAULT_GROOVY_IMPORTS = new Import[]{StubResolver.importPackage("java.lang"), StubResolver.importPackage("java.util"), StubResolver.importPackage("java.io"), StubResolver.importPackage("java.net"), StubResolver.importPackage("groovy.lang"), StubResolver.importPackage("groovy.util"), new Import(NameEnvironment.fromString("java.math"), NameEnvironment.hashIdentifier("BigInteger"), false), new Import(NameEnvironment.fromString("java.math"), NameEnvironment.hashIdentifier("BigDecimal"), false)};
    private final Symbols mySymbols;
    private final StubHierarchyConnector myConnector;

    public StubResolver(Symbols symbols, StubHierarchyConnector connector) {
        this.mySymbols = symbols;
        this.myConnector = connector;
    }

    private static Import importPackage(String qname) {
        return new Import(NameEnvironment.fromString(qname), 0, false);
    }

    private static Import[] getDefaultImports(byte type2) {
        if (type2 == 1) {
            return DEFAULT_JAVA_IMPORTS;
        }
        if (type2 == 2) {
            return DEFAULT_GROOVY_IMPORTS;
        }
        return Imports.EMPTY_ARRAY;
    }

    Set<Symbol> resolveBase(Symbol.ClassSymbol sym, int[] qname) throws IncompleteHierarchyException {
        Set<Symbol> result = this.resolveUnqualified(sym, qname[0], qname.length > 1);
        for (int i = 1; i < qname.length; ++i) {
            result = this.processQualifier(result, qname[i], i != qname.length - 1);
        }
        if (result.isEmpty()) {
            throw IncompleteHierarchyException.INSTANCE;
        }
        return result;
    }

    Set<Symbol> resolveUnqualified(Symbol.ClassSymbol sym, int shortName, boolean processPackages) throws IncompleteHierarchyException {
        Set<Symbol> symbols = this.findIdent(sym.myOwner, sym.myUnitInfo, shortName, processPackages);
        if (symbols.isEmpty()) {
            throw IncompleteHierarchyException.INSTANCE;
        }
        return symbols;
    }

    private Set<Symbol> processQualifier(Set<Symbol> contextResults, int shortName, boolean processPackages) throws IncompleteHierarchyException {
        HashSet<Symbol> result = new HashSet<Symbol>();
        for (Symbol symbol : contextResults) {
            this.selectSym(symbol, shortName, processPackages, result);
        }
        return result;
    }

    @NotNull
    private Set<Symbol> findIdent(Symbol startScope, UnitInfo info, int name, boolean processPackages) throws IncompleteHierarchyException {
        HashSet<Symbol> result = new HashSet<Symbol>();
        this.findType(startScope, name, result);
        this.findGlobalType(info, name, result);
        if (processPackages) {
            ContainerUtil.addIfNotNull(result, (Object)this.mySymbols.getPackage(name));
        }
        HashSet<Symbol> hashSet = result;
        if (hashSet == null) {
            StubResolver.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private void findType(Symbol startScope, int name, Set<Symbol> symbols) throws IncompleteHierarchyException {
        Symbol s = startScope;
        while (s != null) {
            this.findMemberType(s, name, symbols);
            s = s.myOwner;
        }
        this.findIdentInPackage(startScope.pkg(), name, false, symbols);
    }

    private void selectSym(Symbol receiver2, int name, boolean processPackages, Set<Symbol> symbols) throws IncompleteHierarchyException {
        if (receiver2.isPackage()) {
            this.findIdentInPackage((Symbol.PackageSymbol)receiver2, name, processPackages, symbols);
        } else {
            this.findMemberType(receiver2, name, symbols);
        }
    }

    private void findIdentInPackage(Symbol.PackageSymbol pck, int name, boolean processPackages, Set<Symbol> symbols) {
        int fullname = NameEnvironment.qualifiedName(pck.myQualifiedName, name);
        if (processPackages) {
            ContainerUtil.addIfNotNull(symbols, (Object)this.mySymbols.getPackage(fullname));
        }
        Collections.addAll(symbols, this.findGlobalType(fullname));
    }

    private void findMemberType(Symbol s, int name, Set<Symbol> symbols) throws IncompleteHierarchyException {
        if (s.isClass()) {
            this.processInheritedMembers((Symbol.ClassSymbol)s, name, symbols, null);
        } else {
            StubResolver.processMembers(s.getMembers(), name, symbols);
        }
    }

    private void processInheritedMembers(Symbol.ClassSymbol s, int name, Set<Symbol> symbols, @Nullable Set<Symbol> processed) throws IncompleteHierarchyException {
        StubResolver.processMembers(s.getMembers(), name, symbols);
        Object supers = s.getSuperClasses(this.myConnector);
        if (supers == null) {
            return;
        }
        if (processed == null) {
            processed = new HashSet<Symbol>();
        }
        if (!processed.add(s)) {
            return;
        }
        if (supers instanceof Symbol.ClassSymbol) {
            this.processInheritedMembers((Symbol.ClassSymbol)supers, name, symbols, processed);
        } else if (supers instanceof Symbol.ClassSymbol[]) {
            for (Symbol.ClassSymbol st : (Symbol.ClassSymbol[])supers) {
                this.processInheritedMembers(st, name, symbols, processed);
            }
        }
    }

    public Symbol.ClassSymbol[] findGlobalType(int nameId) {
        return this.mySymbols.getClassSymbols(nameId);
    }

    private void findGlobalType(UnitInfo info, int name, Set<Symbol> symbols) throws IncompleteHierarchyException {
        for (Import anImport : StubResolver.getDefaultImports(info.type)) {
            this.handleImport(anImport, name, symbols);
        }
        for (Import anImport : info.imports) {
            this.handleImport(anImport, name, symbols);
        }
    }

    public void handleImport(Import anImport, int name, Set<Symbol> symbols) throws IncompleteHierarchyException {
        if (anImport.isOnDemand()) {
            if (anImport.isStatic) {
                for (Symbol.ClassSymbol p : this.findGlobalType(anImport.qualifier)) {
                    this.importNamedStatic(p, name, symbols);
                }
            } else {
                this.importAll(anImport.qualifier, name, symbols);
            }
        } else {
            int importedName;
            int n = importedName = anImport.getAlias() != 0 ? anImport.getAlias() : anImport.importedName;
            if (name != importedName) {
                return;
            }
            if (anImport.isStatic) {
                for (Symbol.ClassSymbol s : this.findGlobalType(anImport.qualifier)) {
                    this.importNamedStatic(s, anImport.importedName, symbols);
                }
            } else {
                Collections.addAll(symbols, this.findGlobalType(NameEnvironment.qualifiedName(anImport.qualifier, anImport.importedName)));
            }
        }
    }

    private void importAll(int prefix, int suffix, Set<Symbol> symbols) {
        Collections.addAll(symbols, this.findGlobalType(NameEnvironment.qualifiedName(prefix, suffix)));
    }

    private void importNamedStatic(Symbol.ClassSymbol tsym, int name, Set<Symbol> symbols) throws IncompleteHierarchyException {
        this.processInheritedMembers(tsym, name, symbols, null);
    }

    private static void processMembers(Symbol.ClassSymbol[] members, int name, Set<Symbol> symbols) {
        int i;
        int index = StubResolver.getIndex(name, members);
        if (index < 0) {
            return;
        }
        symbols.add(members[index]);
        for (i = index - 1; i >= 0 && members[i].myShortName == name; --i) {
            symbols.add(members[i]);
        }
        for (i = index + 1; i < members.length && members[i].myShortName == name; ++i) {
            symbols.add(members[i]);
        }
    }

    private static int getIndex(int key2, Symbol.ClassSymbol[] a) {
        return ObjectUtils.binarySearch((int)0, (int)a.length, mid -> Integer.compare(a[mid].myShortName, key2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/StubResolver", "findIdent"));
    }
}

