/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.chainCall;

import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.refactoring.chainCall.ChainCallExtractor;
import com.siyeh.ig.psiutils.StreamApiUtil;
import org.jetbrains.annotations.NotNull;

public class CollectionChainCallExtractor
implements ChainCallExtractor {
    @Override
    public boolean canExtractChainCall(@NotNull PsiMethodCallExpression call, PsiExpression expression2, PsiType expressionType) {
        if (call == null) {
            CollectionChainCallExtractor.$$$reportNull$$$0(0);
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        if (!(StreamApiUtil.isSupportedStreamElement(expressionType) && "forEach".equals(methodExpression.getReferenceName()) && methodExpression.getQualifierExpression() != null && InheritanceUtil.isInheritor((PsiType)methodExpression.getQualifierExpression().getType(), (String)"java.util.Collection"))) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        return method != null && method.getParameterList().getParametersCount() == 1;
    }

    @Override
    public String getMethodName(PsiVariable variable, PsiExpression expression2, PsiType expressionType) {
        return "stream()." + StreamRefactoringUtil.getMapOperationName(variable.getType(), expressionType);
    }

    @Override
    public String buildChainCall(PsiVariable variable, PsiExpression expression2, PsiType expressionType) {
        return ".stream()" + StreamRefactoringUtil.generateMapOperation(variable, expressionType, (PsiElement)expression2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/refactoring/chainCall/CollectionChainCallExtractor", "canExtractChainCall"));
    }
}

