/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.migration.EditMigrationDialog;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapSet;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class MigrationDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.migration.MigrationDialog");
    private JPanel myPanel;
    private JComboBox<MigrationMap> myMapComboBox;
    private JTextArea myDescriptionTextArea;
    private JButton myEditMapButton;
    private JButton myNewMapButton;
    private JButton myRemoveMapButton;
    private final Project myProject;
    private final MigrationMapSet myMigrationMapSet;
    private JLabel promptLabel;
    private JSeparator mySeparator;
    private JScrollPane myDescriptionScroll;

    public MigrationDialog(Project project, MigrationMapSet migrationMapSet) {
        super(project, true);
        this.myProject = project;
        this.myMigrationMapSet = migrationMapSet;
        this.$$$setupUI$$$();
        this.setTitle(RefactoringBundle.message((String)"migration.dialog.title"));
        this.setHorizontalStretch(1.2f);
        this.setOKButtonText(RefactoringBundle.message((String)"migration.dialog.ok.button.text"));
        this.init();
    }

    protected String getHelpId() {
        return "refactoring.migrate";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMapComboBox;
    }

    protected JComponent createCenterPanel() {
        this.initMapCombobox();
        class MyTextArea
        extends JTextArea {
            MyTextArea(String s, int a, int b) {
                super(s, a, b);
                this.setFocusable(false);
            }
        }
        this.myDescriptionTextArea = new MyTextArea("", 10, 40);
        this.myDescriptionScroll.getViewport().add(this.myDescriptionTextArea);
        this.myDescriptionScroll.setBorder(null);
        this.myDescriptionScroll.setHorizontalScrollBarPolicy(31);
        this.myDescriptionScroll.setVerticalScrollBarPolicy(21);
        this.myDescriptionTextArea.setEditable(false);
        this.myDescriptionTextArea.setFont(this.promptLabel.getFont());
        this.myDescriptionTextArea.setBackground(this.myPanel.getBackground());
        this.myDescriptionTextArea.setLineWrap(true);
        this.updateDescription();
        this.myMapComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MigrationDialog.this.updateDescription();
            }
        });
        this.myEditMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MigrationDialog.this.editMap();
            }
        });
        this.myRemoveMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MigrationDialog.this.removeMap();
            }
        });
        this.myNewMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MigrationDialog.this.addNewMap();
            }
        });
        this.myMapComboBox.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MigrationDialog.this.myMapComboBox.isPopupVisible()) {
                    MigrationDialog.this.myMapComboBox.setPopupVisible(false);
                } else {
                    MigrationDialog.this.clickDefaultButton();
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
        return this.myPanel;
    }

    private void updateDescription() {
        if (this.myDescriptionTextArea == null) {
            return;
        }
        MigrationMap map2 = this.getMigrationMap();
        if (map2 == null) {
            this.myDescriptionTextArea.setText("");
            return;
        }
        this.myDescriptionTextArea.setText(map2.getDescription());
    }

    private void editMap() {
        MigrationMap oldMap = this.getMigrationMap();
        if (oldMap == null) {
            return;
        }
        MigrationMap newMap = oldMap.cloneMap();
        if (this.editMap(newMap)) {
            this.myMigrationMapSet.replaceMap(oldMap, newMap);
            this.initMapCombobox();
            this.myMapComboBox.setSelectedItem(newMap);
            try {
                this.myMigrationMapSet.saveMaps();
            }
            catch (IOException e) {
                LOG.error("Cannot save migration maps", (Throwable)e);
            }
        }
    }

    private boolean editMap(MigrationMap map2) {
        if (map2 == null) {
            return false;
        }
        EditMigrationDialog dialog = new EditMigrationDialog(this.myProject, map2);
        if (!dialog.showAndGet()) {
            return false;
        }
        map2.setName(dialog.getName());
        map2.setDescription(dialog.getDescription());
        return true;
    }

    private void addNewMap() {
        MigrationMap migrationMap = new MigrationMap();
        if (this.editMap(migrationMap)) {
            this.myMigrationMapSet.addMap(migrationMap);
            this.initMapCombobox();
            this.myMapComboBox.setSelectedItem(migrationMap);
            try {
                this.myMigrationMapSet.saveMaps();
            }
            catch (IOException e) {
                LOG.error("Cannot save migration maps", (Throwable)e);
            }
        }
    }

    private void removeMap() {
        MigrationMap map2 = this.getMigrationMap();
        if (map2 == null) {
            return;
        }
        this.myMigrationMapSet.removeMap(map2);
        MigrationMap[] maps = this.myMigrationMapSet.getMaps();
        this.initMapCombobox();
        if (maps.length > 0) {
            this.myMapComboBox.setSelectedItem(maps[0]);
        }
        try {
            this.myMigrationMapSet.saveMaps();
        }
        catch (IOException e) {
            LOG.error("Cannot save migration maps", (Throwable)e);
        }
    }

    public MigrationMap getMigrationMap() {
        return (MigrationMap)this.myMapComboBox.getSelectedItem();
    }

    private void initMapCombobox() {
        MigrationMap[] maps;
        if (this.myMapComboBox.getItemCount() > 0) {
            this.myMapComboBox.removeAllItems();
        }
        for (MigrationMap map2 : maps = this.myMigrationMapSet.getMaps()) {
            this.myMapComboBox.addItem(map2);
        }
        this.updateDescription();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JSeparator jSeparator;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.promptLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/RefactoringBundle").getString("select.migration.map"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myMapComboBox = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.mySeparator = jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(3, 0, 1, 3, 2, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        this.myDescriptionScroll = jBScrollPane;
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 3, 0, 3, 7, 7, new Dimension(-1, 28), new Dimension(-1, 28), new Dimension(-1, 48)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myEditMapButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("migration.edit.button"));
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myNewMapButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("migration.new.button"));
        jPanel2.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveMapButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/RefactoringBundle").getString("migration.remove.button"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

