/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class MoveInstanceMembersUtil {
    private static final Logger LOG = Logger.getInstance(MoveInstanceMembersUtil.class);

    public static Map<PsiClass, Set<PsiMember>> getThisClassesToMembers(PsiMember member) {
        LinkedHashMap<PsiClass, Set<PsiMember>> map2 = new LinkedHashMap<PsiClass, Set<PsiMember>>();
        MoveInstanceMembersUtil.getThisClassesToMembers((PsiElement)member, map2, member);
        return map2;
    }

    private static void getThisClassesToMembers(PsiElement scope, Map<PsiClass, Set<PsiMember>> map2, PsiMember refMember) {
        PsiElement[] children;
        if (scope instanceof PsiExpression) {
            PsiExpression expression2 = (PsiExpression)scope;
            if (!(scope instanceof PsiReferenceExpression) || !((PsiReferenceExpression)scope).isReferenceTo((PsiElement)refMember)) {
                Pair<PsiMember, PsiClass> pair = MoveInstanceMembersUtil.getMemberAndClassReferencedByThis(expression2);
                if (pair != null) {
                    PsiClass refClass = (PsiClass)pair.getSecond();
                    PsiMember member = (PsiMember)pair.getFirst();
                    if (refClass != null) {
                        boolean inherited = false;
                        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)scope, PsiClass.class, (boolean)true);
                        while (parentClass != null && PsiTreeUtil.isAncestor((PsiElement)refMember, (PsiElement)parentClass, (boolean)false)) {
                            if (parentClass == refClass || parentClass.isInheritor(refClass, true)) {
                                inherited = true;
                                break;
                            }
                            parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, (boolean)true);
                        }
                        if (!inherited && !PsiTreeUtil.isAncestor((PsiElement)refMember, (PsiElement)member, (boolean)false)) {
                            MoveInstanceMembersUtil.addReferencedMember(map2, refClass, member);
                        }
                    }
                }
                if (expression2 instanceof PsiThisExpression) {
                    PsiClass thisClass;
                    PsiJavaCodeReferenceElement thisQualifier = ((PsiThisExpression)expression2).getQualifier();
                    PsiClass psiClass = thisClass = thisQualifier == null ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class, (boolean)true) : (PsiClass)thisQualifier.resolve();
                    if (thisClass != null && !PsiTreeUtil.isAncestor((PsiElement)refMember, (PsiElement)thisClass, (boolean)false)) {
                        MoveInstanceMembersUtil.addReferencedMember(map2, thisClass, null);
                    }
                }
            }
        }
        for (PsiElement child : children = scope.getChildren()) {
            MoveInstanceMembersUtil.getThisClassesToMembers(child, map2, refMember);
        }
    }

    private static void addReferencedMember(Map<PsiClass, Set<PsiMember>> map2, PsiClass classReferenced, PsiMember member) {
        Set<PsiMember> members = map2.get(classReferenced);
        if (members == null) {
            members = new HashSet<PsiMember>();
            map2.put(classReferenced, members);
        }
        members.add(member);
    }

    @Nullable
    private static Pair<PsiMember, PsiClass> getMemberAndClassReferencedByThis(PsiExpression expression2) {
        PsiClass resolved;
        PsiJavaCodeReferenceElement classReference2;
        PsiNewExpression newExpression;
        PsiExpression qualifier;
        if (expression2 instanceof PsiReferenceExpression) {
            PsiElement resolved2;
            PsiExpression qualifier2 = ((PsiReferenceExpression)expression2).getQualifierExpression();
            if ((qualifier2 == null || qualifier2 instanceof PsiThisExpression) && (resolved2 = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiMember && !((PsiMember)resolved2).hasModifierProperty("static")) {
                PsiClass referencedClass = MoveInstanceMembersUtil.getReferencedClass((PsiMember)resolved2, qualifier2, expression2);
                return Pair.create((Object)((PsiMember)resolved2), (Object)referencedClass);
            }
        } else if (expression2 instanceof PsiNewExpression && ((qualifier = (newExpression = (PsiNewExpression)expression2).getQualifier()) == null || qualifier instanceof PsiThisExpression) && (classReference2 = newExpression.getClassOrAnonymousClassReference()) != null && (resolved = (PsiClass)classReference2.resolve()) != null && !resolved.hasModifierProperty("static")) {
            PsiClass referencedClass = MoveInstanceMembersUtil.getReferencedClass((PsiMember)resolved, qualifier, expression2);
            return new Pair((Object)resolved, (Object)referencedClass);
        }
        return null;
    }

    @Nullable
    private static PsiClass getReferencedClass(PsiMember member, PsiExpression exprQualifier, PsiExpression expression2) {
        if (exprQualifier != null) {
            PsiType type2 = exprQualifier.getType();
            if (type2 instanceof PsiClassType) {
                return ((PsiClassType)type2).resolve();
            }
            return null;
        }
        PsiClass referencedClass = member.getContainingClass();
        if (referencedClass == null) {
            return null;
        }
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class);
        assert (parentClass != null);
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)referencedClass, (boolean)false)) {
            referencedClass = parentClass;
        }
        return referencedClass;
    }

    @Nullable
    public static PsiClass getClassReferencedByThis(PsiExpression expression2) {
        PsiClass enclosingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class);
        if (enclosingClass == null) {
            return null;
        }
        Pair<PsiMember, PsiClass> pair = MoveInstanceMembersUtil.getMemberAndClassReferencedByThis(expression2);
        if (pair != null) {
            return (PsiClass)pair.getSecond();
        }
        if (expression2 instanceof PsiThisExpression) {
            PsiJavaCodeReferenceElement thisQualifier = ((PsiThisExpression)expression2).getQualifier();
            if (thisQualifier == null) {
                return enclosingClass;
            }
            return (PsiClass)thisQualifier.resolve();
        }
        return null;
    }

    public static void moveInitializerToConstructor(PsiElementFactory factory, PsiMethod constructor, PsiField field) {
        PsiExpression initializer = field.getInitializer();
        PsiExpression initializerCopy = (PsiExpression)initializer.copy();
        PsiCodeBlock body2 = constructor.getBody();
        if (body2 != null) {
            try {
                String fieldName = field.getName();
                PsiReferenceExpression refExpr = (PsiReferenceExpression)factory.createExpressionFromText(fieldName, (PsiElement)body2);
                if (refExpr.resolve() != null) {
                    fieldName = "this." + fieldName;
                }
                PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(fieldName + "= y;", null);
                if (initializerCopy instanceof PsiArrayInitializerExpression) {
                    PsiType type2 = initializer.getType();
                    PsiNewExpression newExpression = (PsiNewExpression)factory.createExpressionFromText("new " + type2.getCanonicalText() + "{}", (PsiElement)body2);
                    newExpression.getArrayInitializer().replace((PsiElement)initializerCopy);
                    initializerCopy = newExpression;
                }
                ((PsiAssignmentExpression)statement.getExpression()).getRExpression().replace((PsiElement)initializerCopy);
                statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)field.getManager().getProject()).reformat((PsiElement)statement);
                body2.add((PsiElement)statement);
                initializer.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

