/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassNameReferenceEditor
extends ReferenceEditorWithBrowseButton {
    public static final Key<Boolean> CLASS_NAME_REFERENCE_FRAGMENT = Key.create((String)"CLASS_NAME_REFERENCE_FRAGMENT");
    private final Project myProject;
    private PsiClass mySelectedClass;
    private String myChooserTitle;

    public ClassNameReferenceEditor(@NotNull Project project, @Nullable PsiClass selectedClass) {
        if (project == null) {
            ClassNameReferenceEditor.$$$reportNull$$$0(0);
        }
        this(project, selectedClass, null);
    }

    public ClassNameReferenceEditor(@NotNull Project project, @Nullable PsiClass selectedClass, @Nullable GlobalSearchScope resolveScope) {
        if (project == null) {
            ClassNameReferenceEditor.$$$reportNull$$$0(1);
        }
        super(null, project, s -> {
            if (project == null) {
                ClassNameReferenceEditor.$$$reportNull$$$0(2);
            }
            PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project).findPackage("");
            PsiJavaCodeReferenceCodeFragment fragment = JavaCodeFragmentFactory.getInstance((Project)project).createReferenceCodeFragment(s, (PsiElement)defaultPackage, true, true);
            fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
            if (resolveScope != null) {
                fragment.forceResolveScope(resolveScope);
            }
            fragment.putUserData(CLASS_NAME_REFERENCE_FRAGMENT, (Object)true);
            return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
        }, selectedClass != null ? selectedClass.getQualifiedName() : "");
        this.myProject = project;
        this.myChooserTitle = "Choose Class";
        this.addActionListener(new ChooseClassAction());
    }

    public String getChooserTitle() {
        return this.myChooserTitle;
    }

    public void setChooserTitle(String chooserTitle) {
        this.myChooserTitle = chooserTitle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/refactoring/ui/ClassNameReferenceEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ChooseClassAction
    implements ActionListener {
        private ChooseClassAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)ClassNameReferenceEditor.this.myProject).createWithInnerClassesScopeChooser(ClassNameReferenceEditor.this.myChooserTitle, GlobalSearchScope.projectScope((Project)ClassNameReferenceEditor.this.myProject), new ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return aClass.getParent() instanceof PsiJavaFile || aClass.hasModifierProperty("static");
                }
            }, null);
            if (ClassNameReferenceEditor.this.mySelectedClass != null) {
                chooser.selectDirectory(ClassNameReferenceEditor.this.mySelectedClass.getContainingFile().getContainingDirectory());
            }
            chooser.showDialog();
            ClassNameReferenceEditor.this.mySelectedClass = chooser.getSelected();
            if (ClassNameReferenceEditor.this.mySelectedClass != null) {
                ClassNameReferenceEditor.this.setText(ClassNameReferenceEditor.this.mySelectedClass.getQualifiedName());
            }
        }
    }
}

