/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.createTest;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.createTest.JavaTestGenerator;
import com.intellij.testIntegration.createTest.MissedTestsDialog;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class GenerateMissedTestsAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getText() {
        if ("Generate missed test methods" == null) {
            GenerateMissedTestsAction.$$$reportNull$$$0(0);
        }
        return "Generate missed test methods";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            GenerateMissedTestsAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            GenerateMissedTestsAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            GenerateMissedTestsAction.$$$reportNull$$$0(3);
        }
        if (!TestFramework.EXTENSION_NAME.hasAnyExtensions()) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiMethod)) {
            return false;
        }
        if (!((PsiMethod)parent).hasModifierProperty("public") || ((PsiMethod)parent).hasModifierProperty("abstract")) {
            return false;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        return aClass != null && TestFrameworks.detectFramework((PsiClass)aClass) == null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiClass srcClass;
        if (project == null) {
            GenerateMissedTestsAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            GenerateMissedTestsAction.$$$reportNull$$$0(5);
        }
        if ((srcClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) == null) {
            return;
        }
        Collection testClasses = TestFinderHelper.findTestsForClass((PsiElement)srcClass);
        if (testClasses.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, "No tests found.");
            return;
        }
        if (testClasses.size() == 1) {
            GenerateMissedTestsAction.generateMissedTests((PsiClass)ContainerUtil.getFirstItem((Collection)testClasses), srcClass, editor);
            return;
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder((List)ContainerUtil.newArrayList((Iterable)testClasses)).setRenderer((ListCellRenderer)((Object)new PsiClassListCellRenderer())).setItemChosenCallback(selectedClass -> GenerateMissedTestsAction.generateMissedTests((PsiClass)selectedClass, srcClass, editor)).setTitle("Choose Test").createPopup().showInBestPositionFor(editor);
    }

    private static void generateMissedTests(PsiClass testClass, PsiClass srcClass, Editor srcEditor) {
        if (testClass != null) {
            TestFramework framework = TestFrameworks.detectFramework((PsiClass)testClass);
            if (framework != null) {
                Project project = testClass.getProject();
                Editor editor = CodeInsightUtil.positionCursorAtLBrace(project, testClass.getContainingFile(), testClass);
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{testClass})) {
                    return;
                }
                MissedTestsDialog dialog = new MissedTestsDialog(project, srcClass, testClass, framework);
                if (dialog.showAndGet()) {
                    WriteCommandAction.runWriteCommandAction((Project)project, () -> JavaTestGenerator.addTestMethods(editor, testClass, srcClass, framework, dialog.getSelectedMethods(), false, false));
                }
            } else {
                HintManager.getInstance().showErrorHint(srcEditor, "Failed to detect test framework for " + testClass.getQualifiedName());
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testIntegration/createTest/GenerateMissedTestsAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testIntegration/createTest/GenerateMissedTestsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

