/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiteralFormatUtil {
    private static final CharFilter UNDERSCORES_FILTER = new CharFilter(){

        public boolean accept(char ch) {
            return ch != '_';
        }
    };

    private LiteralFormatUtil() {
    }

    @NotNull
    public static String removeUnderscores(@NotNull String text2) {
        if (text2 == null) {
            LiteralFormatUtil.$$$reportNull$$$0(0);
        }
        String string = StringUtil.strip((String)text2, (CharFilter)UNDERSCORES_FILTER);
        if (string == null) {
            LiteralFormatUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String format(@NotNull String original, @Nullable PsiType type2) {
        if (original == null) {
            LiteralFormatUtil.$$$reportNull$$$0(2);
        }
        boolean isFP = PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2);
        String text2 = original;
        String prefix = "";
        String suffix = "";
        int groupSize = 3;
        if (text2.startsWith("0x") || text2.startsWith("0X") || text2.startsWith("0b") || text2.startsWith("0B")) {
            prefix = text2.substring(0, 2);
            text2 = text2.substring(2);
            groupSize = 4;
        }
        if (text2.length() == 0) {
            String string = original;
            if (string == null) {
                LiteralFormatUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        char last = text2.charAt(text2.length() - 1);
        if (StringUtil.containsChar((String)"Ll", (char)last) || isFP && StringUtil.containsChar((String)"FfDd", (char)last)) {
            int pos = text2.length() - 1;
            suffix = text2.substring(pos);
            text2 = text2.substring(0, pos);
        }
        if (text2.length() == 0) {
            String string = original;
            if (string == null) {
                LiteralFormatUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        boolean hasPoint = false;
        String fractional = "";
        String exponentMark = "";
        String exponent = "";
        if (isFP) {
            int pos = StringUtil.indexOfAny((String)text2, (String)("0x".equals(prefix) || "0X".equals(prefix) ? "Pp" : "Ee"));
            if (pos >= 0) {
                int pos2 = Math.max(StringUtil.indexOfAny((String)text2, (String)"+-", (int)pos, (int)text2.length()), pos) + 1;
                exponentMark = text2.substring(pos, pos2);
                exponent = text2.substring(pos2);
                text2 = text2.substring(0, pos);
            }
            if ((pos = text2.indexOf(46)) >= 0) {
                hasPoint = true;
                fractional = text2.substring(pos + 1);
                text2 = text2.substring(0, pos);
            }
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix);
        LiteralFormatUtil.appendFromEnd(buffer, text2, groupSize);
        if (isFP) {
            if (hasPoint) {
                buffer.append('.');
            }
            LiteralFormatUtil.appendFromStart(buffer, fractional, groupSize);
            buffer.append(exponentMark);
            LiteralFormatUtil.appendFromEnd(buffer, exponent, 3);
        }
        buffer.append(suffix);
        String string = buffer.toString();
        if (string == null) {
            LiteralFormatUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void appendFromEnd(StringBuilder buffer, String original, int groupSize) {
        int pointer;
        int position = buffer.length();
        for (pointer = original.length(); pointer > groupSize; pointer -= groupSize) {
            buffer.insert(position, original.substring(pointer - groupSize, pointer));
            buffer.insert(position, '_');
        }
        if (pointer > 0) {
            buffer.insert(position, original.substring(0, pointer));
        }
    }

    private static void appendFromStart(StringBuilder buffer, String original, int groupSize) {
        int pointer = 0;
        while (pointer + groupSize < original.length()) {
            buffer.append(original, pointer, pointer + groupSize);
            buffer.append('_');
            pointer += groupSize;
        }
        if (pointer < original.length()) {
            buffer.append(original.substring(pointer));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/LiteralFormatUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/LiteralFormatUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "removeUnderscores";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeUnderscores";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

