/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.CanonicalPsiTypeConverter;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanonicalPsiTypeConverterImpl
extends CanonicalPsiTypeConverter
implements CustomReferenceConverter<PsiType> {
    @NonNls
    static final String[] PRIMITIVES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short"};
    @NonNls
    private static final String ARRAY_PREFIX = "[L";
    private static final JavaClassReferenceProvider CLASS_REFERENCE_PROVIDER = new JavaClassReferenceProvider();

    public PsiType fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        try {
            return JavaPsiFacade.getElementFactory((Project)context.getFile().getProject()).createTypeFromText(s.replace('$', '.'), null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public String toString(PsiType t, ConvertContext context) {
        return t == null ? null : t.getCanonicalText();
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiType> genericDomValue, PsiElement element, ConvertContext context) {
        String typeText = genericDomValue.getStringValue();
        if (typeText == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                CanonicalPsiTypeConverterImpl.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = this.getReferences((PsiType)genericDomValue.getValue(), typeText, 0, element);
        if (psiReferenceArray == null) {
            CanonicalPsiTypeConverterImpl.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    public PsiReference[] getReferences(@Nullable PsiType type2, String typeText, int startOffsetInText, final @NotNull PsiElement element) {
        if (element == null) {
            CanonicalPsiTypeConverterImpl.$$$reportNull$$$0(2);
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        assert (manipulator != null);
        String trimmed = typeText.trim();
        int offset = manipulator.getRangeInElement(element).getStartOffset() + startOffsetInText + typeText.indexOf(trimmed);
        if (trimmed.startsWith(ARRAY_PREFIX)) {
            offset += ARRAY_PREFIX.length();
            trimmed = trimmed.endsWith(";") ? trimmed.substring(ARRAY_PREFIX.length(), trimmed.length() - 1) : trimmed.substring(ARRAY_PREFIX.length());
        }
        if (type2 != null) {
            type2 = type2.getDeepComponentType();
        }
        final boolean isPrimitiveType = type2 instanceof PsiPrimitiveType;
        return new JavaClassReferenceSet(trimmed, element, offset, false, CLASS_REFERENCE_PROVIDER){

            @Override
            @NotNull
            protected JavaClassReference createReference(int refIndex, @NotNull String subRefText, @NotNull TextRange textRange, boolean staticImport) {
                if (subRefText == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (textRange == null) {
                    1.$$$reportNull$$$0(1);
                }
                JavaClassReference javaClassReference = new JavaClassReference(this, textRange, refIndex, subRefText, staticImport){

                    @Override
                    public boolean isSoft() {
                        return true;
                    }

                    @Override
                    @NotNull
                    public JavaResolveResult advancedResolve(boolean incompleteCode) {
                        if (isPrimitiveType) {
                            CandidateInfo candidateInfo = new CandidateInfo(element, PsiSubstitutor.EMPTY, false, false, element);
                            if (candidateInfo == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return candidateInfo;
                        }
                        JavaResolveResult javaResolveResult = super.advancedResolve(incompleteCode);
                        if (javaResolveResult == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return javaResolveResult;
                    }

                    @Override
                    public void processVariants(@NotNull PsiScopeProcessor processor) {
                        if (processor == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (processor instanceof JavaCompletionProcessor) {
                            ((JavaCompletionProcessor)processor).setCompletionElements(this.getVariants());
                        } else {
                            super.processVariants(processor);
                        }
                    }

                    @Override
                    @NotNull
                    public Object[] getVariants() {
                        Object[] variants = super.getVariants();
                        if (this.myIndex == 0) {
                            Object[] objectArray = ArrayUtil.mergeArrays((Object[])variants, (Object[])PRIMITIVES, (ArrayFactory)ArrayUtil.OBJECT_ARRAY_FACTORY);
                            if (objectArray == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            return objectArray;
                        }
                        if (variants == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return variants;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 2: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 2: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/util/xml/CanonicalPsiTypeConverterImpl$1$1";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "processor";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "advancedResolve";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/util/xml/CanonicalPsiTypeConverterImpl$1$1";
                                break;
                            }
                            case 3: 
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getVariants";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "processVariants";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 2: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                if (javaClassReference == null) {
                    1.$$$reportNull$$$0(2);
                }
                return javaClassReference;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "subRefText";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "textRange";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/xml/CanonicalPsiTypeConverterImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/xml/CanonicalPsiTypeConverterImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createReference";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createReference";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.getAllReferences();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/CanonicalPsiTypeConverterImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/CanonicalPsiTypeConverterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

