/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.annotation;

import com.intellij.codeInsight.daemon.impl.quickfix.AddAnnotationAttributeNameFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateAnnotationMethodFromUsageFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleElementAnnotationInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("single.element.annotation.name", new Object[0]);
        if (string == null) {
            SingleElementAnnotationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = this.getDisplayName();
        if (string == null) {
            SingleElementAnnotationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExpandAnnotationVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ExpandAnnotationFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/annotation/SingleElementAnnotationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ExpandAnnotationVisitor
    extends BaseInspectionVisitor {
        private ExpandAnnotationVisitor() {
        }

        public void visitNameValuePair(PsiNameValuePair pair) {
            PsiAnnotationMemberValue value2;
            PsiType valueType;
            PsiElement resolved;
            PsiReference reference;
            Set<String> usedNames;
            PsiElement parent;
            super.visitNameValuePair(pair);
            if (pair.getName() == null && pair.getValue() != null && (parent = pair.getParent()) instanceof PsiAnnotationParameterList && !(usedNames = AddAnnotationAttributeNameFix.getUsedAttributeNames((PsiAnnotationParameterList)parent)).contains("value") && (reference = pair.getReference()) != null && (resolved = reference.resolve()) instanceof PsiMethod && AddAnnotationAttributeNameFix.isCompatibleReturnType((PsiMethod)resolved, valueType = CreateAnnotationMethodFromUsageFix.getAnnotationValueType(value2 = pair.getValue()))) {
                this.registerError((PsiElement)pair, new Object[0]);
            }
        }
    }

    private static class ExpandAnnotationFix
    extends InspectionGadgetsFix {
        private ExpandAnnotationFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("single.element.annotation.quickfix", new Object[0]);
            if (string == null) {
                ExpandAnnotationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("single.element.annotation.family.quickfix", new Object[0]);
            if (string == null) {
                ExpandAnnotationFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiNameValuePair annotationParameter = (PsiNameValuePair)descriptor.getPsiElement();
            String text2 = ExpandAnnotationFix.buildReplacementText(annotationParameter);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)annotationParameter.getProject());
            PsiAnnotation newAnnotation = factory.createAnnotationFromText("@A(" + text2 + " )", (PsiElement)annotationParameter);
            annotationParameter.replace((PsiElement)newAnnotation.getParameterList().getAttributes()[0]);
        }

        private static String buildReplacementText(@NotNull PsiNameValuePair annotationParameter) {
            if (annotationParameter == null) {
                ExpandAnnotationFix.$$$reportNull$$$0(2);
            }
            PsiAnnotationMemberValue value2 = annotationParameter.getValue();
            return "value=" + (value2 != null ? value2.getText() : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/annotation/SingleElementAnnotationInspection$ExpandAnnotationFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotationParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/annotation/SingleElementAnnotationInspection$ExpandAnnotationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "buildReplacementText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

