/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;

public class CollectionAddedToSelfInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("collection.added.to.self.display.name", new Object[0]);
        if (string == null) {
            CollectionAddedToSelfInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String methodName = (String)infos[0];
        String string = InspectionGadgetsBundle.message("collection.added.to.self.problem.descriptor", methodName);
        if (string == null) {
            CollectionAddedToSelfInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CollectionAddedToSelfVisitor();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/CollectionAddedToSelfInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CollectionAddedToSelfVisitor
    extends BaseInspectionVisitor {
        private CollectionAddedToSelfVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            PsiExpression[] arguments;
            if (call == null) {
                CollectionAddedToSelfVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if ("equals".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (!(referent instanceof PsiVariable)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression selfArgument = null;
            for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(qualifier, argument)) continue;
                selfArgument = argument;
            }
            if (selfArgument == null) {
                return;
            }
            PsiType qualifierType = qualifier.getType();
            if (!InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.Collection") && !InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.Map")) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (!CollectionUtils.isCollectionClassOrInterface(aClass)) {
                return;
            }
            this.registerError((PsiElement)selfArgument, methodName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/bugs/CollectionAddedToSelfInspection$CollectionAddedToSelfVisitor", "visitMethodCallExpression"));
        }
    }
}

