/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CloneableImplementsCloneInspection
extends BaseInspection {
    public boolean m_ignoreCloneableDueToInheritance = false;

    @NotNull
    public String getID() {
        if ("CloneableClassWithoutClone" == null) {
            CloneableImplementsCloneInspection.$$$reportNull$$$0(0);
        }
        return "CloneableClassWithoutClone";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cloneable.class.without.clone.display.name", new Object[0]);
        if (string == null) {
            CloneableImplementsCloneInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("cloneable.class.without.clone.problem.descriptor", new Object[0]);
        if (string == null) {
            CloneableImplementsCloneInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("cloneable.class.without.clone.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreCloneableDueToInheritance");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass.hasModifierProperty("final")) {
            return null;
        }
        PsiMethod[] superMethods = aClass.findMethodsByName("clone", true);
        boolean generateThrows = false;
        for (PsiMethod method : superMethods) {
            if (!CloneUtils.isClone(method)) continue;
            if (method.hasModifierProperty("final")) {
                return null;
            }
            generateThrows = MethodUtils.hasInThrows(method, "java.lang.CloneNotSupportedException");
            break;
        }
        return new CreateCloneMethodFix(generateThrows);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneableImplementsCloneVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/cloneable/CloneableImplementsCloneInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class CloneableImplementsCloneVisitor
    extends BaseInspectionVisitor {
        private CloneableImplementsCloneVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiMethod[] methods;
            if (aClass == null) {
                CloneableImplementsCloneVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (CloneableImplementsCloneInspection.this.m_ignoreCloneableDueToInheritance ? !CloneUtils.isDirectlyCloneable(aClass) : !CloneUtils.isCloneable(aClass)) {
                return;
            }
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (!CloneUtils.isClone(method)) continue;
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/cloneable/CloneableImplementsCloneInspection$CloneableImplementsCloneVisitor", "visitClass"));
        }
    }

    private static class CreateCloneMethodFix
    extends InspectionGadgetsFix {
        private final boolean myGenerateThrows;

        CreateCloneMethodFix(boolean generateThrows) {
            this.myGenerateThrows = generateThrows;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("cloneable.class.without.clone.quickfix", new Object[0]);
            if (string == null) {
                CreateCloneMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            Editor editor;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            StringBuilder methodText = new StringBuilder();
            if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)aClass) && JavaCodeStyleSettings.getInstance((PsiFile)aClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION) {
                methodText.append("@java.lang.Override ");
            }
            methodText.append("public ").append(aClass.getName());
            PsiTypeParameterList typeParameterList = aClass.getTypeParameterList();
            if (typeParameterList != null) {
                methodText.append(typeParameterList.getText());
            }
            methodText.append(" clone() ");
            if (this.myGenerateThrows) {
                methodText.append("throws java.lang.CloneNotSupportedException ");
            }
            methodText.append("{\nreturn (").append(element.getText()).append(") super.clone();\n").append("}");
            PsiMethod method = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText(methodText.toString(), element);
            PsiElement newElement = parent.add((PsiElement)method);
            if (this.isOnTheFly() && (editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) != null) {
                GenerateMembersUtil.positionCaret(editor, newElement, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneableImplementsCloneInspection$CreateCloneMethodFix", "getFamilyName"));
        }
    }
}

