/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInsight.daemon.impl.quickfix.ConvertSwitchToIfIntention;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchStatementWithTooFewBranchesInspection
extends BaseInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 2;
    public int m_limit = 2;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("switch.statement.with.too.few.branches.display.name", new Object[0]);
        if (string == null) {
            SwitchStatementWithTooFewBranchesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("switch.statement.with.too.few.branches.min.option", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer branchCount = (Integer)infos[0];
        if (branchCount == 0) {
            String string = InspectionGadgetsBundle.message("switch.statement.with.single.default.message", new Object[0]);
            if (string == null) {
                SwitchStatementWithTooFewBranchesInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("switch.statement.with.too.few.branches.problem.descriptor", branchCount);
        if (string == null) {
            SwitchStatementWithTooFewBranchesInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Integer branchCount = (Integer)infos[0];
        return (Boolean)infos[1] != false ? new UnwrapSwitchStatementFix(branchCount) : null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementWithTooFewBranchesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/SwitchStatementWithTooFewBranchesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnwrapSwitchStatementFix
    extends InspectionGadgetsFix {
        int myBranchCount;

        private UnwrapSwitchStatementFix(int branchCount) {
            this.myBranchCount = branchCount;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = this.myBranchCount == 0 ? this.getFamilyName() : CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"switch", "if"});
            if (string == null) {
                UnwrapSwitchStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.unwrap.statement", (Object[])new Object[]{"switch"});
            if (string == null) {
                UnwrapSwitchStatementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiSwitchStatement statement;
            if (project == null) {
                UnwrapSwitchStatementFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                UnwrapSwitchStatementFix.$$$reportNull$$$0(3);
            }
            if ((statement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiSwitchStatement.class)) == null) {
                return;
            }
            ConvertSwitchToIfIntention.doProcessIntention(statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/SwitchStatementWithTooFewBranchesInspection$UnwrapSwitchStatementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/SwitchStatementWithTooFewBranchesInspection$UnwrapSwitchStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class SwitchStatementWithTooFewBranchesVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementWithTooFewBranchesVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            PsiCodeBlock body2;
            if (statement == null) {
                SwitchStatementWithTooFewBranchesVisitor.$$$reportNull$$$0(0);
            }
            if ((body2 = statement.getBody()) == null) {
                return;
            }
            int branches = 0;
            boolean defaultFound = false;
            for (PsiSwitchLabelStatement child : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)body2, PsiSwitchLabelStatement.class)) {
                if (child.isDefaultCase()) {
                    defaultFound = true;
                    continue;
                }
                if (++branches < SwitchStatementWithTooFewBranchesInspection.this.m_limit) continue;
                return;
            }
            if (branches == 0 && !defaultFound) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, branches, ConvertSwitchToIfIntention.isAvailable(statement));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/SwitchStatementWithTooFewBranchesInspection$SwitchStatementWithTooFewBranchesVisitor", "visitSwitchStatement"));
        }
    }
}

