/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.exceptions;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiCatchCanBeSplitInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multi.catch.can.be.split.name", new Object[0]);
        if (string == null) {
            MultiCatchCanBeSplitInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = this.getDisplayName();
        if (string == null) {
            MultiCatchCanBeSplitInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SplitMultiCatchVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SplitMultiCatchFix();
    }

    private static void doFixImpl(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            MultiCatchCanBeSplitInspection.$$$reportNull$$$0(2);
        }
        if (!((parent = element.getParent()) instanceof PsiCatchSection)) {
            return;
        }
        PsiCatchSection catchSection = (PsiCatchSection)parent;
        PsiElement grandParent = catchSection.getParent();
        if (!(grandParent instanceof PsiTryStatement)) {
            return;
        }
        PsiParameter parameter2 = catchSection.getParameter();
        if (parameter2 == null) {
            return;
        }
        PsiType type2 = parameter2.getType();
        if (!(type2 instanceof PsiDisjunctionType)) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)element.getProject());
        for (PsiType disjunction : ((PsiDisjunctionType)type2).getDisjunctions()) {
            PsiCatchSection copy = (PsiCatchSection)catchSection.copy();
            PsiTypeElement typeElement = (PsiTypeElement)ObjectUtils.assertNotNull((Object)((PsiParameter)ObjectUtils.assertNotNull((Object)copy.getParameter())).getTypeElement());
            PsiTypeElement newTypeElement = factory.createTypeElementFromText(disjunction.getCanonicalText(true), (PsiElement)catchSection);
            PsiElement replaced = typeElement.replace((PsiElement)newTypeElement);
            grandParent.addBefore((PsiElement)copy, (PsiElement)catchSection);
            styleManager.shortenClassReferences(replaced);
        }
        catchSection.delete();
    }

    private static boolean isAcceptable(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            MultiCatchCanBeSplitInspection.$$$reportNull$$$0(3);
        }
        if ((parent = element.getParent()) instanceof PsiCatchSection) {
            PsiType type2 = ((PsiCatchSection)parent).getCatchType();
            return type2 instanceof PsiDisjunctionType;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/exceptions/MultiCatchCanBeSplitInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/exceptions/MultiCatchCanBeSplitInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doFixImpl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SplitMultiCatchFix
    extends InspectionGadgetsFix {
        private SplitMultiCatchFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("multi.catch.can.be.split.quickfix", new Object[0]);
            if (string == null) {
                SplitMultiCatchFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            MultiCatchCanBeSplitInspection.doFixImpl(descriptor.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/exceptions/MultiCatchCanBeSplitInspection$SplitMultiCatchFix", "getFamilyName"));
        }
    }

    private static class SplitMultiCatchVisitor
    extends BaseInspectionVisitor {
        private SplitMultiCatchVisitor() {
        }

        public void visitParameter(PsiParameter parameter2) {
            super.visitParameter(parameter2);
            if (MultiCatchCanBeSplitInspection.isAcceptable((PsiElement)parameter2)) {
                this.registerError((PsiElement)parameter2, new Object[0]);
            }
        }

        public void visitKeyword(PsiKeyword keyword) {
            super.visitKeyword(keyword);
            if (this.isOnTheFly() && keyword.getTokenType() == JavaTokenType.CATCH_KEYWORD && MultiCatchCanBeSplitInspection.isAcceptable((PsiElement)keyword)) {
                this.registerError((PsiElement)keyword, new Object[0]);
            }
        }
    }
}

