/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class CouplingVisitor
extends JavaRecursiveElementWalkingVisitor {
    private int m_inClass;
    private final PsiMethod m_method;
    private final boolean m_includeJavaClasses;
    private final boolean m_includeLibraryClasses;
    private final Set<String> m_dependencies;

    CouplingVisitor(@NotNull PsiMethod method, boolean includeJavaClasses, boolean includeLibraryClasses) {
        if (method == null) {
            CouplingVisitor.$$$reportNull$$$0(0);
        }
        this.m_dependencies = new HashSet<String>(10);
        this.m_method = method;
        this.m_includeJavaClasses = includeJavaClasses;
        this.m_includeLibraryClasses = includeLibraryClasses;
    }

    public void visitVariable(@NotNull PsiVariable variable) {
        if (variable == null) {
            CouplingVisitor.$$$reportNull$$$0(1);
        }
        super.visitVariable(variable);
        PsiType type2 = variable.getType();
        this.addDependency(type2);
    }

    public void visitMethod(@NotNull PsiMethod method) {
        if (method == null) {
            CouplingVisitor.$$$reportNull$$$0(2);
        }
        super.visitMethod(method);
        PsiType returnType = method.getReturnType();
        this.addDependency(returnType);
        this.addDependenciesForThrowsList(method);
    }

    private void addDependenciesForThrowsList(PsiMethod method) {
        PsiClassType[] throwsTypes;
        PsiReferenceList throwsList = method.getThrowsList();
        for (PsiClassType throwsType : throwsTypes = throwsList.getReferencedTypes()) {
            this.addDependency((PsiType)throwsType);
        }
    }

    public void visitNewExpression(@NotNull PsiNewExpression exp) {
        if (exp == null) {
            CouplingVisitor.$$$reportNull$$$0(3);
        }
        super.visitNewExpression(exp);
        PsiType classType = exp.getType();
        this.addDependency(classType);
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression exp) {
        super.visitClassObjectAccessExpression(exp);
        PsiTypeElement operand2 = exp.getOperand();
        this.addDependency(operand2);
    }

    public void visitClass(@NotNull PsiClass aClass) {
        PsiClassType[] superTypes;
        int wasInClass;
        if (aClass == null) {
            CouplingVisitor.$$$reportNull$$$0(4);
        }
        if ((wasInClass = this.m_inClass++) == 0) {
            super.visitClass(aClass);
        }
        for (PsiClassType superType : superTypes = aClass.getSuperTypes()) {
            this.addDependency((PsiType)superType);
        }
    }

    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            CouplingVisitor.$$$reportNull$$$0(5);
        }
        super.elementFinished(element);
        if (element instanceof PsiClass) {
            --this.m_inClass;
        }
    }

    public void visitTryStatement(@NotNull PsiTryStatement statement) {
        PsiParameter[] catchBlockParameters;
        if (statement == null) {
            CouplingVisitor.$$$reportNull$$$0(6);
        }
        super.visitTryStatement(statement);
        for (PsiParameter catchBlockParameter : catchBlockParameters = statement.getCatchBlockParameters()) {
            PsiType catchType = catchBlockParameter.getType();
            this.addDependency(catchType);
        }
    }

    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression exp) {
        if (exp == null) {
            CouplingVisitor.$$$reportNull$$$0(7);
        }
        super.visitInstanceOfExpression(exp);
        PsiTypeElement checkType = exp.getCheckType();
        this.addDependency(checkType);
    }

    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression exp) {
        if (exp == null) {
            CouplingVisitor.$$$reportNull$$$0(8);
        }
        super.visitTypeCastExpression(exp);
        PsiTypeElement castType = exp.getCastType();
        this.addDependency(castType);
    }

    private void addDependency(PsiTypeElement typeElement) {
        if (typeElement == null) {
            return;
        }
        PsiType type2 = typeElement.getType();
        this.addDependency(type2);
    }

    private void addDependency(PsiType type2) {
        if (type2 == null) {
            return;
        }
        PsiType baseType = type2.getDeepComponentType();
        if (ClassUtils.isPrimitive(type2)) {
            return;
        }
        PsiClass containingClass = this.m_method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        if (baseType.equalsToText(qualifiedName)) {
            return;
        }
        String baseTypeName = baseType.getCanonicalText();
        if (!this.m_includeJavaClasses && (baseTypeName.startsWith("java.") || baseTypeName.startsWith("javax."))) {
            return;
        }
        if (StringUtil.startsWithConcatenation((String)baseTypeName, (String[])new String[]{qualifiedName, "."})) {
            return;
        }
        if (!this.m_includeLibraryClasses) {
            Project project = this.m_method.getProject();
            GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(baseTypeName, searchScope);
            if (aClass == null) {
                return;
            }
            if (LibraryUtil.classIsInLibrary(aClass)) {
                return;
            }
        }
        this.m_dependencies.add(baseTypeName);
    }

    int getNumDependencies() {
        return this.m_dependencies.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/methodmetrics/CouplingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVariable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNewExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "elementFinished";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTryStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInstanceOfExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeCastExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

