/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class MethodNameSameAsParentNameInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.name.same.as.parent.name.display.name", new Object[0]);
        if (string == null) {
            MethodNameSameAsParentNameInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.name.same.as.parent.name.problem.descriptor", new Object[0]);
        if (string == null) {
            MethodNameSameAsParentNameInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodNameSameAsParentClassNameVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/naming/MethodNameSameAsParentNameInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MethodNameSameAsParentClassNameVisitor
    extends BaseInspectionVisitor {
        private MethodNameSameAsParentClassNameVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MethodNameSameAsParentClassNameVisitor.$$$reportNull$$$0(0);
            }
            if (method.isConstructor()) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiClass parent = containingClass.getSuperClass();
            if (parent == null) {
                return;
            }
            String parentName = parent.getName();
            if (parentName == null) {
                return;
            }
            String methodName = method.getName();
            if (!methodName.equals(parentName)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/MethodNameSameAsParentNameInspection$MethodNameSameAsParentClassNameVisitor", "visitMethod"));
        }
    }
}

