/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchUtils {
    private SwitchUtils() {
    }

    public static int calculateBranchCount(@NotNull PsiSwitchStatement statement) {
        PsiCodeBlock body2;
        if (statement == null) {
            SwitchUtils.$$$reportNull$$$0(0);
        }
        if ((body2 = statement.getBody()) == null) {
            return 0;
        }
        int branches = 0;
        boolean defaultFound = false;
        for (PsiSwitchLabelStatement child : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)body2, PsiSwitchLabelStatement.class)) {
            if (child.isDefaultCase()) {
                defaultFound = true;
                continue;
            }
            ++branches;
        }
        return defaultFound ? -branches - 1 : branches;
    }

    @Nullable
    public static PsiExpression getSwitchExpression(PsiIfStatement statement, int minimumBranches, boolean nullSafe, boolean stringEquality) {
        LanguageLevel languageLevel;
        PsiExpression condition2 = statement.getCondition();
        PsiExpression possibleSwitchExpression = SwitchUtils.determinePossibleSwitchExpressions(condition2, languageLevel = PsiUtil.getLanguageLevel((PsiElement)statement));
        if (!SwitchUtils.canBeSwitchExpression(possibleSwitchExpression, languageLevel)) {
            return null;
        }
        if (nullSafe && NullabilityUtil.getExpressionNullability(possibleSwitchExpression, true) != Nullability.NOT_NULL) {
            return null;
        }
        if (!stringEquality && !ExpressionUtils.hasStringType(possibleSwitchExpression)) {
            return null;
        }
        int branchCount = 0;
        while (true) {
            ++branchCount;
            if (!SwitchUtils.canBeMadeIntoCase(statement.getCondition(), possibleSwitchExpression, languageLevel)) break;
            PsiStatement elseBranch = statement.getElseBranch();
            if (!(elseBranch instanceof PsiIfStatement)) {
                if (branchCount < minimumBranches) {
                    return null;
                }
                return possibleSwitchExpression;
            }
            statement = (PsiIfStatement)elseBranch;
        }
        return null;
    }

    private static boolean canBeMadeIntoCase(PsiExpression expression2, PsiExpression switchExpression, LanguageLevel languageLevel) {
        expression2 = ParenthesesUtils.stripParentheses(expression2);
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_7)) {
            PsiExpression stringSwitchExpression = SwitchUtils.determinePossibleJdk17SwitchExpression(expression2);
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, stringSwitchExpression)) {
                return true;
            }
        }
        if (!(expression2 instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
        IElementType operation = polyadicExpression.getOperationTokenType();
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        if (operation.equals(JavaTokenType.OROR)) {
            for (PsiExpression operand2 : operands2) {
                if (SwitchUtils.canBeMadeIntoCase(operand2, switchExpression, languageLevel)) continue;
                return false;
            }
            return true;
        }
        if (operation.equals(JavaTokenType.EQEQ) && operands2.length == 2) {
            return SwitchUtils.canBeCaseLabel(operands2[0], languageLevel) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, operands2[1]) || SwitchUtils.canBeCaseLabel(operands2[1], languageLevel) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, operands2[0]);
        }
        return false;
    }

    private static boolean canBeSwitchExpression(PsiExpression expression2, LanguageLevel languageLevel) {
        if (expression2 == null) {
            return false;
        }
        PsiType type2 = expression2.getType();
        if (PsiType.CHAR.equals((Object)type2) || PsiType.BYTE.equals((Object)type2) || PsiType.SHORT.equals((Object)type2) || PsiType.INT.equals((Object)type2)) {
            return true;
        }
        if (type2 instanceof PsiClassType && languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            if (ExpressionUtils.isAnnotatedNullable(expression2)) {
                return false;
            }
            if (type2.equalsToText("java.lang.Character") || type2.equalsToText("java.lang.Byte") || type2.equalsToText("java.lang.Short") || type2.equalsToText("java.lang.Integer")) {
                return true;
            }
            if (TypeConversionUtil.isEnumType((PsiType)type2)) {
                return true;
            }
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_7) && type2.equalsToText("java.lang.String")) {
                return true;
            }
        }
        return false;
    }

    private static PsiExpression determinePossibleSwitchExpressions(PsiExpression expression2, LanguageLevel languageLevel) {
        PsiExpression jdk17Expression;
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
            return null;
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_7) && (jdk17Expression = SwitchUtils.determinePossibleJdk17SwitchExpression(expression2)) != null) {
            return jdk17Expression;
        }
        if (!(expression2 instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
        IElementType operation = polyadicExpression.getOperationTokenType();
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        if (operation.equals(JavaTokenType.OROR) && operands2.length > 0) {
            return SwitchUtils.determinePossibleSwitchExpressions(operands2[0], languageLevel);
        }
        if (operation.equals(JavaTokenType.EQEQ) && operands2.length == 2) {
            PsiExpression lhs = ParenthesesUtils.stripParentheses(operands2[0]);
            PsiExpression rhs = ParenthesesUtils.stripParentheses(operands2[1]);
            if (SwitchUtils.canBeCaseLabel(lhs, languageLevel)) {
                return rhs;
            }
            if (SwitchUtils.canBeCaseLabel(rhs, languageLevel)) {
                return lhs;
            }
        } else {
            EqualityCheck check = EqualityCheck.from(expression2);
            if (check != null) {
                PsiExpression left = check.getLeft();
                PsiExpression right = check.getRight();
                if (SwitchUtils.canBeCaseLabel(left, languageLevel)) {
                    return right;
                }
                if (SwitchUtils.canBeCaseLabel(right, languageLevel)) {
                    return left;
                }
            }
        }
        return null;
    }

    private static PsiExpression determinePossibleJdk17SwitchExpression(PsiExpression expression2) {
        EqualityCheck check = EqualityCheck.from(expression2);
        if (check == null) {
            return null;
        }
        PsiExpression left = check.getLeft();
        PsiExpression right = check.getRight();
        if (PsiUtil.isConstantExpression((PsiExpression)left)) {
            return right;
        }
        if (PsiUtil.isConstantExpression((PsiExpression)right)) {
            return left;
        }
        return null;
    }

    private static boolean canBeCaseLabel(PsiExpression expression2, LanguageLevel languageLevel) {
        PsiElement referent;
        if (expression2 == null) {
            return false;
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5) && expression2 instanceof PsiReferenceExpression && (referent = ((PsiReference)expression2).resolve()) instanceof PsiEnumConstant) {
            return true;
        }
        PsiType type2 = expression2.getType();
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_7) && TypeUtils.isJavaLangString(type2) && PsiUtil.isConstantExpression((PsiExpression)expression2)) {
            return true;
        }
        return (PsiType.INT.equals((Object)type2) || PsiType.SHORT.equals((Object)type2) || PsiType.BYTE.equals((Object)type2) || PsiType.CHAR.equals((Object)type2)) && PsiUtil.isConstantExpression((PsiExpression)expression2);
    }

    public static String findUniqueLabelName(PsiStatement statement, @NonNls String baseName) {
        PsiElement ancestor = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMember.class);
        if (ancestor == null || !SwitchUtils.checkForLabel(baseName, ancestor)) {
            return baseName;
        }
        int val = 1;
        String name;
        while (SwitchUtils.checkForLabel(name = baseName + val, ancestor)) {
            ++val;
        }
        return name;
    }

    private static boolean checkForLabel(String name, PsiElement ancestor) {
        LabelSearchVisitor visitor = new LabelSearchVisitor(name);
        ancestor.accept((PsiElementVisitor)visitor);
        return visitor.isUsed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/SwitchUtils", "calculateBranchCount"));
    }

    public static class IfStatementBranch {
        private final Set<String> topLevelVariables = new HashSet<String>(3);
        private final LinkedList<String> comments = new LinkedList();
        private final LinkedList<String> statementComments = new LinkedList();
        private final List<PsiExpression> caseExpressions = new ArrayList<PsiExpression>(3);
        private final PsiStatement statement;
        private final boolean elseBranch;

        public IfStatementBranch(PsiStatement branch, boolean elseBranch) {
            this.statement = branch;
            this.elseBranch = elseBranch;
            this.calculateVariablesDeclared(this.statement);
        }

        public void addComment(String comment) {
            this.comments.addFirst(comment);
        }

        public void addStatementComment(String comment) {
            this.statementComments.addFirst(comment);
        }

        public void addCaseExpression(PsiExpression expression2) {
            this.caseExpressions.add(expression2);
        }

        public PsiStatement getStatement() {
            return this.statement;
        }

        public List<PsiExpression> getCaseExpressions() {
            return Collections.unmodifiableList(this.caseExpressions);
        }

        public boolean isElse() {
            return this.elseBranch;
        }

        public boolean topLevelDeclarationsConflictWith(IfStatementBranch testBranch) {
            return IfStatementBranch.intersects(this.topLevelVariables, testBranch.topLevelVariables);
        }

        private static boolean intersects(Set<String> set1, Set<String> set2) {
            for (String s : set1) {
                if (!set2.contains(s)) continue;
                return true;
            }
            return false;
        }

        public List<String> getComments() {
            return this.comments;
        }

        public List<String> getStatementComments() {
            return this.statementComments;
        }

        public void calculateVariablesDeclared(PsiStatement statement) {
            block4: {
                PsiStatement[] statements;
                block3: {
                    PsiElement[] elements;
                    if (statement == null) {
                        return;
                    }
                    if (!(statement instanceof PsiDeclarationStatement)) break block3;
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                    for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
                        PsiVariable variable = (PsiVariable)element;
                        String varName = variable.getName();
                        this.topLevelVariables.add(varName);
                    }
                    break block4;
                }
                if (!(statement instanceof PsiBlockStatement)) break block4;
                PsiBlockStatement block = (PsiBlockStatement)statement;
                PsiCodeBlock codeBlock = block.getCodeBlock();
                for (PsiStatement statement1 : statements = codeBlock.getStatements()) {
                    this.calculateVariablesDeclared(statement1);
                }
            }
        }
    }

    private static class LabelSearchVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final String m_labelName;
        private boolean m_used = false;

        LabelSearchVisitor(String name) {
            this.m_labelName = name;
        }

        public void visitElement(PsiElement element) {
            if (this.m_used) {
                return;
            }
            super.visitElement(element);
        }

        public void visitLabeledStatement(PsiLabeledStatement statement) {
            PsiIdentifier labelIdentifier = statement.getLabelIdentifier();
            String labelText = labelIdentifier.getText();
            if (labelText.equals(this.m_labelName)) {
                this.m_used = true;
            }
        }

        public boolean isUsed() {
            return this.m_used;
        }
    }
}

