/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.siyeh.ig.psiutils.ArrayContentsAssignedVisitor;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAssignedFromVisitor;
import com.siyeh.ig.psiutils.VariableAssignedVisitor;
import com.siyeh.ig.psiutils.VariablePassedAsArgumentExcludedVisitor;
import com.siyeh.ig.psiutils.VariablePassedAsArgumentVisitor;
import com.siyeh.ig.psiutils.VariableReturnedVisitor;
import com.siyeh.ig.psiutils.VariableUsedInArrayInitializerVisitor;
import com.siyeh.ig.psiutils.VariableUsedInInnerClassVisitor;
import com.siyeh.ig.psiutils.VariableUsedVisitor;
import com.siyeh.ig.psiutils.VariableValueUsedVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableAccessUtils {
    private VariableAccessUtils() {
    }

    public static boolean variableIsAssignedFrom(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(0);
        }
        if (context == null) {
            return false;
        }
        VariableAssignedFromVisitor visitor = new VariableAssignedFromVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAssignedFrom();
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(1);
        }
        if (context == null) {
            return false;
        }
        VariablePassedAsArgumentVisitor visitor = new VariablePassedAsArgumentVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isPassed();
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, @Nullable PsiElement context, Processor<? super PsiCall> callProcessor) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(2);
        }
        return VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context, false, callProcessor);
    }

    public static boolean variableIsPassedAsMethodArgument(@NotNull PsiVariable variable, @Nullable PsiElement context, boolean builderPattern, Processor<? super PsiCall> callProcessor) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(3);
        }
        if (context == null) {
            return false;
        }
        VariablePassedAsArgumentExcludedVisitor visitor = new VariablePassedAsArgumentExcludedVisitor(variable, builderPattern, callProcessor);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isPassed();
    }

    public static boolean variableIsUsedInArrayInitializer(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(4);
        }
        if (context == null) {
            return false;
        }
        VariableUsedInArrayInitializerVisitor visitor = new VariableUsedInArrayInitializerVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isPassed();
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(5);
        }
        if (variable instanceof PsiField) {
            if (variable.hasModifierProperty("private")) {
                PsiClass aClass = PsiUtil.getTopLevelClass((PsiElement)variable);
                return VariableAccessUtils.variableIsAssigned(variable, (PsiElement)aClass);
            }
            return DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)variable, false) || ReferencesSearch.search((PsiElement)variable).anyMatch(reference -> {
                PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)reference.getElement(), PsiExpression.class);
                return expression2 != null && PsiUtil.isAccessedForWriting((PsiExpression)expression2);
            });
        }
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiMethod.class, PsiLambdaExpression.class, PsiCatchSection.class, PsiForStatement.class, PsiForeachStatement.class});
        return VariableAccessUtils.variableIsAssigned(variable, context);
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(6);
        }
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor = new VariableAssignedVisitor(variable, true);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAssigned();
    }

    public static boolean variableIsAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context, boolean recurseIntoClasses) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(7);
        }
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor = new VariableAssignedVisitor(variable, recurseIntoClasses);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAssigned();
    }

    public static boolean variableIsReturned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(8);
        }
        return VariableAccessUtils.variableIsReturned(variable, context, false);
    }

    public static boolean variableIsReturned(@NotNull PsiVariable variable, @Nullable PsiElement context, boolean builderPattern) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(9);
        }
        if (context == null) {
            return false;
        }
        VariableReturnedVisitor visitor = new VariableReturnedVisitor(variable, builderPattern);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isReturned();
    }

    public static boolean variableValueIsUsed(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(10);
        }
        if (context == null) {
            return false;
        }
        VariableValueUsedVisitor visitor = new VariableValueUsedVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isVariableValueUsed();
    }

    public static boolean arrayContentsAreAssigned(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(11);
        }
        if (context == null) {
            return false;
        }
        ArrayContentsAssignedVisitor visitor = new ArrayContentsAssignedVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAssigned();
    }

    public static boolean variableIsUsedInInnerClass(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(12);
        }
        if (context == null) {
            return false;
        }
        VariableUsedInInnerClassVisitor visitor = new VariableUsedInInnerClassVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isUsedInInnerClass();
    }

    public static boolean mayEvaluateToVariable(@Nullable PsiExpression expression2, @NotNull PsiVariable variable) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(13);
        }
        return VariableAccessUtils.mayEvaluateToVariable(expression2, variable, false);
    }

    static boolean mayEvaluateToVariable(@Nullable PsiExpression expression2, @NotNull PsiVariable variable, boolean builderPattern) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(14);
        }
        if (expression2 == null) {
            return false;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression containedExpression = parenthesizedExpression.getExpression();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable, builderPattern);
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
            PsiExpression containedExpression = typeCastExpression.getOperand();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable, builderPattern);
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression2;
            PsiExpression thenExpression2 = conditional.getThenExpression();
            PsiExpression elseExpression2 = conditional.getElseExpression();
            return VariableAccessUtils.mayEvaluateToVariable(thenExpression2, variable, builderPattern) || VariableAccessUtils.mayEvaluateToVariable(elseExpression2, variable, builderPattern);
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiArrayAccessExpression) {
                return false;
            }
            PsiType type2 = variable.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return false;
            }
            PsiArrayType arrayType = (PsiArrayType)type2;
            int dimensions = arrayType.getArrayDimensions();
            if (dimensions <= 1) {
                return false;
            }
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression2;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            int count = 1;
            while (arrayExpression instanceof PsiArrayAccessExpression) {
                arrayAccessExpression = (PsiArrayAccessExpression)arrayExpression;
                arrayExpression = arrayAccessExpression.getArrayExpression();
                ++count;
            }
            return count != dimensions && VariableAccessUtils.mayEvaluateToVariable(arrayExpression, variable, builderPattern);
        }
        if (builderPattern && expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiType returnType = method.getReturnType();
            PsiType variableType = variable.getType();
            if (!variableType.equals(returnType)) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return VariableAccessUtils.mayEvaluateToVariable(qualifier, variable, true);
        }
        return VariableAccessUtils.evaluatesToVariable(expression2, variable);
    }

    public static boolean evaluatesToVariable(@Nullable PsiExpression expression2, @NotNull PsiVariable variable) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(15);
        }
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
        PsiElement target = referenceExpression.resolve();
        return variable.equals(target);
    }

    @Contract(value="_, null -> false")
    public static boolean variableIsUsed(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(16);
        }
        return context != null && VariableUsedVisitor.isVariableUsedIn(variable, context);
    }

    public static boolean variableIsDecremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(17);
        }
        return VariableAccessUtils.variableIsIncrementedOrDecremented(variable, statement, false);
    }

    public static boolean variableIsIncremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(18);
        }
        return VariableAccessUtils.variableIsIncrementedOrDecremented(variable, statement, true);
    }

    private static boolean variableIsIncrementedOrDecremented(@NotNull PsiVariable variable, @Nullable PsiStatement statement, boolean incremented) {
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(19);
        }
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression2 = expressionStatement.getExpression();
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiUnaryExpression) {
            PsiUnaryExpression unaryExpression = (PsiUnaryExpression)expression2;
            IElementType tokenType = unaryExpression.getOperationTokenType();
            if (!tokenType.equals(incremented ? JavaTokenType.PLUSPLUS : JavaTokenType.MINUSMINUS)) {
                return false;
            }
            PsiExpression operand2 = unaryExpression.getOperand();
            return VariableAccessUtils.evaluatesToVariable(operand2, variable);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!VariableAccessUtils.evaluatesToVariable(lhs, variable)) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            rhs = ParenthesesUtils.stripParentheses(rhs);
            if (tokenType == JavaTokenType.EQ) {
                if (!(rhs instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
                IElementType binaryTokenType = binaryExpression.getOperationTokenType();
                if (binaryTokenType != (incremented ? JavaTokenType.PLUS : JavaTokenType.MINUS)) {
                    return false;
                }
                PsiExpression lOperand = binaryExpression.getLOperand();
                PsiExpression rOperand = binaryExpression.getROperand();
                if (ExpressionUtils.isOne(lOperand) ? VariableAccessUtils.evaluatesToVariable(rOperand, variable) : ExpressionUtils.isOne(rOperand) && VariableAccessUtils.evaluatesToVariable(lOperand, variable)) {
                    return true;
                }
            } else if (tokenType == (incremented ? JavaTokenType.PLUSEQ : JavaTokenType.MINUSEQ) && ExpressionUtils.isOne(rhs)) {
                return true;
            }
        }
        return false;
    }

    public static boolean variableIsAssignedBeforeReference(@NotNull PsiReferenceExpression referenceExpression, @Nullable PsiElement context) {
        if (referenceExpression == null) {
            VariableAccessUtils.$$$reportNull$$$0(20);
        }
        if (context == null) {
            return false;
        }
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)target;
        return VariableAccessUtils.variableIsAssignedAtPoint(variable, context, (PsiElement)referenceExpression);
    }

    public static boolean variableIsAssignedAtPoint(@NotNull PsiVariable variable, @Nullable PsiElement context, @NotNull PsiElement point) {
        PsiElement[] children;
        if (variable == null) {
            VariableAccessUtils.$$$reportNull$$$0(21);
        }
        if (point == null) {
            VariableAccessUtils.$$$reportNull$$$0(22);
        }
        if (context == null) {
            return false;
        }
        PsiElement directChild = VariableAccessUtils.getDirectChildWhichContainsElement(context, point);
        if (directChild == null) {
            return false;
        }
        for (PsiElement child : children = context.getChildren()) {
            if (child == directChild) {
                return VariableAccessUtils.variableIsAssignedAtPoint(variable, directChild, point);
            }
            if (!VariableAccessUtils.variableIsAssigned(variable, child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement getDirectChildWhichContainsElement(@NotNull PsiElement ancestor, @NotNull PsiElement descendant) {
        if (ancestor == null) {
            VariableAccessUtils.$$$reportNull$$$0(23);
        }
        if (descendant == null) {
            VariableAccessUtils.$$$reportNull$$$0(24);
        }
        if (ancestor == descendant) {
            return null;
        }
        PsiElement child = descendant;
        PsiElement parent = child.getParent();
        while (!parent.equals(ancestor)) {
            child = parent;
            if ((parent = child.getParent()) != null) continue;
            return null;
        }
        return child;
    }

    public static Set<PsiVariable> collectUsedVariables(PsiElement context) {
        if (context == null) {
            return Collections.emptySet();
        }
        VariableCollectingVisitor visitor = new VariableCollectingVisitor();
        context.accept((PsiElementVisitor)visitor);
        return visitor.getUsedVariables();
    }

    public static boolean isAnyVariableAssigned(@NotNull Collection<? extends PsiVariable> variables, @Nullable PsiElement context) {
        if (variables == null) {
            VariableAccessUtils.$$$reportNull$$$0(25);
        }
        if (context == null) {
            return false;
        }
        VariableAssignedVisitor visitor = new VariableAssignedVisitor(variables, true);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isAssigned();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/VariableAccessUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsAssignedFrom";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsPassedAsMethodArgument";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsUsedInArrayInitializer";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsAssigned";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsReturned";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "variableValueIsUsed";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "arrayContentsAreAssigned";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsUsedInInnerClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "mayEvaluateToVariable";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluatesToVariable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsUsed";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsDecremented";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsIncremented";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsIncrementedOrDecremented";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsAssignedBeforeReference";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "variableIsAssignedAtPoint";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "getDirectChildWhichContainsElement";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnyVariableAssigned";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VariableCollectingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiVariable> usedVariables = new HashSet<PsiVariable>();

        private VariableCollectingVisitor() {
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            PsiElement target = expression2.resolve();
            if (!(target instanceof PsiVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)target;
            this.usedVariables.add(variable);
        }

        public Set<PsiVariable> getUsedVariables() {
            return this.usedVariables;
        }
    }
}

