/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import org.jetbrains.annotations.NotNull;

public class SocketResourceInspection
extends ResourceInspection {
    @NotNull
    public String getID() {
        if ("SocketOpenedButNotSafelyClosed" == null) {
            SocketResourceInspection.$$$reportNull$$$0(0);
        }
        return "SocketOpenedButNotSafelyClosed";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("socket.opened.not.closed.display.name", new Object[0]);
        if (string == null) {
            SocketResourceInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean isResourceCreation(PsiExpression expression2) {
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"accept".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || !TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.net.ServerSocket")) {
                return false;
            }
            return TypeUtils.expressionHasTypeOrSubtype((PsiExpression)methodCallExpression, "java.net.Socket");
        }
        if (expression2 instanceof PsiNewExpression) {
            return TypeUtils.expressionHasTypeOrSubtype(expression2, "java.net.Socket", "java.net.DatagramSocket", "java.net.ServerSocket") != null;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/resources/SocketResourceInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

