/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspectionBase;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NonSerializableFieldInSerializableClassInspection
extends SerializableInspectionBase {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);

    @Override
    @NotNull
    protected JComponent[] createAdditionalOptions() {
        JComponent[] jComponentArray = new JComponent[]{SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.ignorableAnnotations), InspectionGadgetsBundle.message("ignore.if.annotated.by", new Object[0]))};
        if (jComponentArray == null) {
            NonSerializableFieldInSerializableClassInspection.$$$reportNull$$$0(0);
        }
        return jComponentArray;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.serializable.field.in.serializable.class.display.name", new Object[0]);
        if (string == null) {
            NonSerializableFieldInSerializableClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.serializable.field.in.serializable.class.problem.descriptor", new Object[0]);
        if (string == null) {
            NonSerializableFieldInSerializableClassInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        InspectionGadgetsFix[] inspectionGadgetsFixArray = AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)field, (List<String>)((Object)this.ignorableAnnotations));
        if (inspectionGadgetsFixArray == null) {
            NonSerializableFieldInSerializableClassInspection.$$$reportNull$$$0(3);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableFieldInSerializableClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/NonSerializableFieldInSerializableClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NonSerializableFieldInSerializableClassVisitor
    extends BaseInspectionVisitor {
        private NonSerializableFieldInSerializableClassVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                NonSerializableFieldInSerializableClassVisitor.$$$reportNull$$$0(0);
            }
            if (field.hasModifierProperty("transient") || field.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (NonSerializableFieldInSerializableClassInspection.this.ignoreAnonymousInnerClasses && aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            PsiType fieldType = field.getType();
            if (SerializationUtils.isProbablySerializable(fieldType)) {
                return;
            }
            PsiClass fieldClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)fieldType);
            if (fieldClass != null && NonSerializableFieldInSerializableClassInspection.this.isIgnoredSubclass(fieldClass)) {
                return;
            }
            if (SerializationUtils.hasWriteObject(aClass) || SerializationUtils.hasWriteReplace(aClass)) {
                return;
            }
            if (NonSerializableFieldInSerializableClassInspection.this.isIgnoredSubclass(aClass)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (Collection)((Object)NonSerializableFieldInSerializableClassInspection.this.ignorableAnnotations), (int)0)) {
                return;
            }
            this.registerFieldError(field, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/serialization/NonSerializableFieldInSerializableClassInspection$NonSerializableFieldInSerializableClassVisitor", "visitField"));
        }
    }
}

