/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ObjectsEqualsCanBeSimplifiedInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher OBJECTS_EQUALS = CallMatcher.staticCall("java.util.Objects", "equals").parameterCount(2);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ObjectsEqualsCanBeSimplifiedInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                ObjectsEqualsCanBeSimplifiedInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (!OBJECTS_EQUALS.test(call)) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                PsiExpression arg1 = args[0];
                PsiExpression arg2 = args[1];
                PsiElement nameElement = Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement());
                if (this.processPrimitives(nameElement, arg1, arg2)) {
                    return;
                }
                PsiClass argClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)arg1.getType());
                if (argClass == null) {
                    return;
                }
                if (NullabilityUtil.getExpressionNullability(arg1, true) == Nullability.NOT_NULL) {
                    PsiMethod[] equalsMethods;
                    for (PsiMethod method : equalsMethods = argClass.findMethodsByName("equals", true)) {
                        if (method.hasModifierProperty("static") || method.getParameterList().getParametersCount() != 1 || TypeUtils.isJavaLangObject(method.getParameterList().getParameters()[0].getType())) continue;
                        return;
                    }
                    holder.registerProblem(nameElement, InspectionsBundle.message((String)"inspection.objects.equals.can.be.simplified.message", (Object[])new Object[]{"equals()"}), new LocalQuickFix[]{new ReplaceWithEqualsFix(false)});
                }
            }

            private boolean processPrimitives(PsiElement nameElement, PsiExpression arg1, PsiExpression arg2) {
                PsiType type1 = arg1.getType();
                PsiType type2 = arg2.getType();
                if (type1 instanceof PsiPrimitiveType && type1.equals(type2) && !TypeConversionUtil.isFloatOrDoubleType((PsiType)type1)) {
                    holder.registerProblem(nameElement, InspectionsBundle.message((String)"inspection.objects.equals.can.be.simplified.message", (Object[])new Object[]{"=="}), new LocalQuickFix[]{new ReplaceWithEqualsFix(true)});
                    return true;
                }
                return false;
            }
        };
        if (javaElementVisitor == null) {
            ObjectsEqualsCanBeSimplifiedInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/ObjectsEqualsCanBeSimplifiedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/ObjectsEqualsCanBeSimplifiedInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithEqualsFix
    implements LocalQuickFix {
        final boolean myEquality;

        private ReplaceWithEqualsFix(boolean equality) {
            this.myEquality = equality;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"Objects.equals()", this.myEquality ? "==" : "equals()"});
            if (string == null) {
                ReplaceWithEqualsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call;
            if (project == null) {
                ReplaceWithEqualsFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithEqualsFix.$$$reportNull$$$0(2);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 2) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String replacement = this.myEquality ? ct.text(args[0], 9) + "==" + ct.text(args[1], 9) : ct.text(args[0], 1) + ".equals(" + ct.text((PsiElement)args[1]) + ")";
            ct.replaceAndRestoreComments((PsiElement)call, replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/ObjectsEqualsCanBeSimplifiedInspection$ReplaceWithEqualsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/ObjectsEqualsCanBeSimplifiedInspection$ReplaceWithEqualsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

