/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.util.VisibilityUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryConstructorInspection
extends BaseInspection {
    public boolean ignoreAnnotations = false;

    @NotNull
    public String getID() {
        if ("RedundantNoArgConstructor" == null) {
            UnnecessaryConstructorInspection.$$$reportNull$$$0(0);
        }
        return "RedundantNoArgConstructor";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.constructor.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryConstructorInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.constructor.annotation.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAnnotations");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryConstructorInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConstructorVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryConstructorFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryConstructorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryConstructorVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiModifierList modifierList;
            PsiAnnotation[] annotations2;
            String modifier;
            PsiMethod[] constructors;
            if (aClass == null) {
                UnnecessaryConstructorVisitor.$$$reportNull$$$0(0);
            }
            if ((constructors = aClass.getConstructors()).length != 1) {
                return;
            }
            PsiMethod constructor = constructors[0];
            if (!constructor.isPhysical() || constructor.getNameIdentifier() == null) {
                return;
            }
            if (!aClass.isEnum() && !constructor.hasModifierProperty(modifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList()))) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            if (!parameterList.isEmpty()) {
                return;
            }
            if (UnnecessaryConstructorInspection.this.ignoreAnnotations && (annotations2 = (modifierList = constructor.getModifierList()).getAnnotations()).length > 0) {
                return;
            }
            PsiReferenceList throwsList = constructor.getThrowsList();
            PsiJavaCodeReferenceElement[] elements = throwsList.getReferenceElements();
            if (elements.length != 0) {
                return;
            }
            PsiCodeBlock body2 = constructor.getBody();
            if (ControlFlowUtils.isEmptyCodeBlock(body2) || this.isSuperConstructorInvocationWithoutArguments(ControlFlowUtils.getOnlyStatementInBlock(body2))) {
                this.registerMethodError(constructor, new Object[0]);
            }
        }

        private boolean isSuperConstructorInvocationWithoutArguments(PsiStatement statement) {
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (!argumentList.isEmpty()) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            return "super".equals(methodExpression.getReferenceName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/style/UnnecessaryConstructorInspection$UnnecessaryConstructorVisitor", "visitClass"));
        }
    }

    private static class UnnecessaryConstructorFix
    extends InspectionGadgetsFix {
        private UnnecessaryConstructorFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.constructor.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryConstructorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement nameIdentifier = descriptor.getPsiElement();
            PsiElement constructor = nameIdentifier.getParent();
            assert (constructor != null);
            UnnecessaryConstructorFix.deleteElement(constructor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryConstructorInspection$UnnecessaryConstructorFix", "getFamilyName"));
        }
    }
}

