/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.testFrameworks.AssertHint;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MisorderedAssertEqualsArgumentsInspectionBase
extends BaseInspection {
    @NonNls
    private static final Set<String> methodNames = ContainerUtil.newHashSet((Object[])new String[]{"assertEquals", "assertEqualsNoOrder", "assertNotEquals", "assertArrayEquals", "assertSame", "assertNotSame", "failNotSame", "failNotEquals"});

    public abstract boolean checkTestNG();

    @Override
    @NotNull
    public final String getDisplayName() {
        String string = InspectionGadgetsBundle.message("misordered.assert.equals.arguments.display.name", new Object[0]);
        if (string == null) {
            MisorderedAssertEqualsArgumentsInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected final String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("misordered.assert.equals.arguments.problem.descriptor", new Object[0]);
        if (string == null) {
            MisorderedAssertEqualsArgumentsInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public final InspectionGadgetsFix buildFix(Object ... infos) {
        return new FlipArgumentsFix();
    }

    @Override
    public final BaseInspectionVisitor buildVisitor() {
        return new MisorderedAssertEqualsParametersVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/testFrameworks/MisorderedAssertEqualsArgumentsInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MisorderedAssertEqualsParametersVisitor
    extends BaseInspectionVisitor {
        private MisorderedAssertEqualsParametersVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                MisorderedAssertEqualsParametersVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            ExpectedActual expectedActual = ExpectedActual.create(expression2, MisorderedAssertEqualsArgumentsInspectionBase.this.checkTestNG());
            if (expectedActual == null) {
                return;
            }
            if (this.looksLikeExpectedArgument(expectedActual.getExpected()) || !this.looksLikeExpectedArgument(expectedActual.getActual())) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private boolean looksLikeExpectedArgument(@Nullable PsiExpression expression2) {
            PsiClassType classType;
            PsiClass aClass;
            if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
                return false;
            }
            PsiType type2 = expression2.getType();
            if (ExpressionUtils.computeConstantExpression(expression2) != null || PsiType.NULL.equals((Object)type2)) {
                return true;
            }
            if (expression2 instanceof PsiReferenceExpression) {
                PsiLocalVariable variable;
                PsiExpression definition;
                PsiField field;
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
                PsiElement target = referenceExpression.resolve();
                if (target instanceof PsiEnumConstant) {
                    return true;
                }
                if (target instanceof PsiField ? (field = (PsiField)target).hasModifierProperty("static") && field.hasModifierProperty("final") : target instanceof PsiLocalVariable && LibraryUtil.isOnlyLibraryCodeUsed((PsiElement)(definition = DeclarationSearchUtils.findDefinition(referenceExpression, (PsiVariable)(variable = (PsiLocalVariable)target))))) {
                    return true;
                }
            }
            if (expression2 instanceof PsiCallExpression && type2 instanceof PsiClassType && (aClass = (classType = (PsiClassType)type2).resolve()) instanceof PsiCompiledElement) {
                return LibraryUtil.isOnlyLibraryCodeUsed((PsiElement)expression2);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/testFrameworks/MisorderedAssertEqualsArgumentsInspectionBase$MisorderedAssertEqualsParametersVisitor", "visitMethodCallExpression"));
        }
    }

    private static class ExpectedActual {
        private final PsiExpression myExpected;
        private final PsiExpression myActual;

        private ExpectedActual(PsiExpression expected, PsiExpression actual) {
            this.myExpected = expected;
            this.myActual = actual;
        }

        public PsiExpression getExpected() {
            return this.myExpected;
        }

        public PsiExpression getActual() {
            return this.myActual;
        }

        private static ExpectedActual create(PsiMethodCallExpression callExpression, boolean checkTestNG) {
            AssertHint hint = AssertHint.create(callExpression, methodName -> methodNames.contains(methodName) ? Integer.valueOf(2) : null, checkTestNG);
            if (hint == null) {
                return null;
            }
            PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
            int index = hint.getArgIndex();
            PsiExpression expectedArgument = arguments[checkTestNG ? index + 1 : index];
            PsiExpression actualArgument = arguments[checkTestNG ? index : index + 1];
            return new ExpectedActual(expectedArgument, actualArgument);
        }
    }

    private class FlipArgumentsFix
    extends InspectionGadgetsFix {
        private FlipArgumentsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("misordered.assert.equals.arguments.flip.quickfix", new Object[0]);
            if (string == null) {
                FlipArgumentsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement parent = methodNameIdentifier.getParent();
            if (parent == null) {
                return;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)parent.getParent();
            if (callExpression == null) {
                return;
            }
            ExpectedActual expectedActual = ExpectedActual.create(callExpression, MisorderedAssertEqualsArgumentsInspectionBase.this.checkTestNG());
            if (expectedActual == null) {
                return;
            }
            PsiExpression expectedArgument = expectedActual.getExpected();
            PsiExpression actualArgument = expectedActual.getActual();
            PsiElement copy = expectedArgument.copy();
            expectedArgument.replace((PsiElement)actualArgument);
            actualArgument.replace(copy);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/testFrameworks/MisorderedAssertEqualsArgumentsInspectionBase$FlipArgumentsFix", "getFamilyName"));
        }
    }
}

