/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SynchronizationUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CallToNativeMethodWhileLockedInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("call.to.native.method.while.locked.display.name", new Object[0]);
        if (string == null) {
            CallToNativeMethodWhileLockedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.native.method.while.locked.problem.descriptor", new Object[0]);
        if (string == null) {
            CallToNativeMethodWhileLockedInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToNativeMethodWhileLockedVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/CallToNativeMethodWhileLockedInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CallToNativeMethodWhileLockedVisitor
    extends BaseInspectionVisitor {
        private static final Set<String> EXCLUDED_CLASS_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"java.lang.Object", "java.lang.System", "sun.misc.Unsafe", "java.lang.invoke.MethodHandle"});

        private CallToNativeMethodWhileLockedVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiMethod method;
            if (expression2 == null) {
                CallToNativeMethodWhileLockedVisitor.$$$reportNull$$$0(0);
            }
            if ((method = expression2.resolveMethod()) == null || !method.hasModifierProperty("native")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (EXCLUDED_CLASS_NAMES.contains(containingClass.getQualifiedName())) {
                return;
            }
            if (!SynchronizationUtil.isInSynchronizedContext((PsiElement)expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/CallToNativeMethodWhileLockedInspection$CallToNativeMethodWhileLockedVisitor", "visitMethodCallExpression"));
        }
    }
}

