/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmbiguousFieldAccessInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("ambiguous.field.access.display.name", new Object[0]);
        if (string == null) {
            AmbiguousFieldAccessInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass fieldClass = (PsiClass)infos[0];
        PsiVariable variable = (PsiVariable)infos[1];
        if (variable instanceof PsiLocalVariable) {
            String string = InspectionGadgetsBundle.message("ambiguous.field.access.hides.local.variable.problem.descriptor", fieldClass.getName());
            if (string == null) {
                AmbiguousFieldAccessInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (variable instanceof PsiParameter) {
            String string = InspectionGadgetsBundle.message("ambiguous.field.access.hides.parameter.problem.descriptor", fieldClass.getName());
            if (string == null) {
                AmbiguousFieldAccessInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("ambiguous.field.access.hides.field.problem.descriptor", fieldClass.getName());
        if (string == null) {
            AmbiguousFieldAccessInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AmbiguousFieldAccessFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AmbiguousFieldAccessVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AmbiguousFieldAccessVisitor
    extends BaseInspectionVisitor {
        private AmbiguousFieldAccessVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            String referenceText;
            super.visitReferenceExpression(expression2);
            if (expression2.isQualified()) {
                return;
            }
            PsiElement target = expression2.resolve();
            if (target == null) {
                return;
            }
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression2);
            if (containingClass == null) {
                return;
            }
            if (!containingClass.isInheritor(fieldClass, true)) {
                return;
            }
            PsiElement parent = containingClass.getParent();
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)expression2.getProject()).getResolveHelper();
            PsiVariable variable = resolveHelper.resolveAccessibleReferencedVariable(referenceText = expression2.getText(), parent);
            if (variable == null || field == variable) {
                return;
            }
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)variable, (PsiElement)containingClass);
            if (commonParent == null) {
                return;
            }
            this.registerError((PsiElement)expression2, fieldClass, variable);
        }
    }

    private static class AmbiguousFieldAccessFix
    extends InspectionGadgetsFix {
        private AmbiguousFieldAccessFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("ambiguous.field.access.quickfix", new Object[0]);
            if (string == null) {
                AmbiguousFieldAccessFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            String newExpressionText = "super." + referenceExpression.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, newExpressionText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AmbiguousFieldAccessInspection$AmbiguousFieldAccessFix", "getFamilyName"));
        }
    }
}

